# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.networkcloud import NetworkCloudMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkCloudMgmtClustersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkCloudMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list_by_subscription(self, resource_group):
        response = self.client.clusters.list_by_subscription(
            api_version="2024-10-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_list_by_resource_group(self, resource_group):
        response = self.client.clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-10-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_get(self, resource_group):
        response = self.client.clusters.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-10-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_create_or_update(self, resource_group):
        response = self.client.clusters.begin_create_or_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            cluster_parameters={
                "aggregatorOrSingleRackDefinition": {
                    "networkRackId": "str",
                    "rackSerialNumber": "str",
                    "rackSkuId": "str",
                    "availabilityZone": "str",
                    "bareMetalMachineConfigurationData": [
                        {
                            "bmcCredentials": {"password": "str", "username": "str"},
                            "bmcMacAddress": "str",
                            "bootMacAddress": "str",
                            "rackSlot": 0,
                            "serialNumber": "str",
                            "bmcConnectionString": "str",
                            "machineDetails": "str",
                            "machineName": "str",
                        }
                    ],
                    "rackLocation": "str",
                    "storageApplianceConfigurationData": [
                        {
                            "adminCredentials": {"password": "str", "username": "str"},
                            "rackSlot": 0,
                            "serialNumber": "str",
                            "storageApplianceName": "str",
                        }
                    ],
                },
                "clusterType": "str",
                "clusterVersion": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "location": "str",
                "networkFabricId": "str",
                "analyticsOutputSettings": {
                    "analyticsWorkspaceId": "str",
                    "associatedIdentity": {"identityType": "str", "userAssignedIdentityResourceId": "str"},
                },
                "analyticsWorkspaceId": "str",
                "availableUpgradeVersions": [
                    {
                        "controlImpact": "str",
                        "expectedDuration": "str",
                        "impactDescription": "str",
                        "supportExpiryDate": "str",
                        "targetClusterVersion": "str",
                        "workloadImpact": "str",
                    }
                ],
                "clusterCapacity": {
                    "availableApplianceStorageGB": 0,
                    "availableCoreCount": 0,
                    "availableHostStorageGB": 0,
                    "availableMemoryGB": 0,
                    "totalApplianceStorageGB": 0,
                    "totalCoreCount": 0,
                    "totalHostStorageGB": 0,
                    "totalMemoryGB": 0,
                },
                "clusterConnectionStatus": "str",
                "clusterExtendedLocation": {"name": "str", "type": "str"},
                "clusterLocation": "str",
                "clusterManagerConnectionStatus": "str",
                "clusterManagerId": "str",
                "clusterServicePrincipal": {
                    "applicationId": "str",
                    "password": "str",
                    "principalId": "str",
                    "tenantId": "str",
                },
                "commandOutputSettings": {
                    "associatedIdentity": {"identityType": "str", "userAssignedIdentityResourceId": "str"},
                    "containerUrl": "str",
                },
                "computeDeploymentThreshold": {"grouping": "str", "type": "str", "value": 0},
                "computeRackDefinitions": [
                    {
                        "networkRackId": "str",
                        "rackSerialNumber": "str",
                        "rackSkuId": "str",
                        "availabilityZone": "str",
                        "bareMetalMachineConfigurationData": [
                            {
                                "bmcCredentials": {"password": "str", "username": "str"},
                                "bmcMacAddress": "str",
                                "bootMacAddress": "str",
                                "rackSlot": 0,
                                "serialNumber": "str",
                                "bmcConnectionString": "str",
                                "machineDetails": "str",
                                "machineName": "str",
                            }
                        ],
                        "rackLocation": "str",
                        "storageApplianceConfigurationData": [
                            {
                                "adminCredentials": {"password": "str", "username": "str"},
                                "rackSlot": 0,
                                "serialNumber": "str",
                                "storageApplianceName": "str",
                            }
                        ],
                    }
                ],
                "detailedStatus": "str",
                "detailedStatusMessage": "str",
                "hybridAksExtendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "managedResourceGroupConfiguration": {"location": "str", "name": "str"},
                "manualActionCount": 0,
                "name": "str",
                "provisioningState": "str",
                "runtimeProtectionConfiguration": {"enforcementLevel": "Disabled"},
                "secretArchive": {"keyVaultId": "str", "useKeyVault": "False"},
                "secretArchiveSettings": {
                    "associatedIdentity": {"identityType": "str", "userAssignedIdentityResourceId": "str"},
                    "vaultUri": "str",
                },
                "supportExpiryDate": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "updateStrategy": {
                    "strategyType": "str",
                    "thresholdType": "str",
                    "thresholdValue": 0,
                    "maxUnavailable": 0,
                    "waitTimeMinutes": 15,
                },
                "vulnerabilityScanningSettings": {"containerScan": "str"},
                "workloadResourceIds": ["str"],
            },
            api_version="2024-10-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_delete(self, resource_group):
        response = self.client.clusters.begin_delete(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-10-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_update(self, resource_group):
        response = self.client.clusters.begin_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-10-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_continue_update_version(self, resource_group):
        response = self.client.clusters.begin_continue_update_version(
            resource_group_name=resource_group.name,
            cluster_name="str",
            cluster_continue_update_version_parameters={"machineGroupTargetingMode": "AlphaByRack"},
            api_version="2024-10-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_deploy(self, resource_group):
        response = self.client.clusters.begin_deploy(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-10-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_scan_runtime(self, resource_group):
        response = self.client.clusters.begin_scan_runtime(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-10-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_clusters_begin_update_version(self, resource_group):
        response = self.client.clusters.begin_update_version(
            resource_group_name=resource_group.name,
            cluster_name="str",
            cluster_update_version_parameters={"targetClusterVersion": "str"},
            api_version="2024-10-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
