---
id: next-steps
title: Next Steps
sidebar_label: Next Steps
custom_edit_url: https://github.com/microsoft/fast/edit/master/sites/website/versioned_docs/version-legacy/fast-element/next-steps.md
description: Now that you're familiar with the robust and powerful features of FASTElement, you're ready to build your own components and apps.
keywords:
  - next steps
---

We've seen how to use `FASTElement` to declaratively build Web Components. In addition to the basics of element and attribute definition, `FASTElement` also provides a way to declare templates capable of high-performance rendering, and efficient, incremental batched updates. Finally, CSS can easily be associated with an element in a way that leverages core platform optimizations for performance and low memory allocation.

Now that you're familiar with the robust and powerful features of `FASTElement`, you're ready to build your own components and apps. But you don't have to start from scratch there either! If you haven't already explored them, check out our [FAST Components](../components/getting-started.md), which provide all the basic UI building-blocks you'd expect in a modern component library. You can also leverage the same adaptive design system that our own components use to enable robust theming throughout all you create. Read more on that in [Styling Components](../design-systems/fast-frame.md#configuring-components). Finally, you'll want to take advantage of a modern toolset by installing [a powerful editor and plugins](../tools/vscode.md).

For a quick reference, check out [our Cheat Sheet](../resources/cheat-sheet.md).