<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/uwsgi/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/uwsgi/metadata.yaml"
sidebar_label: "uWSGI"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Web Servers and Web Proxies"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# uWSGI


<img src="https://netdata.cloud/img/uwsgi.svg" width="150"/>


Plugin: go.d.plugin
Module: uwsgi

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitors UWSGI worker health and performance by collecting metrics like requests, transmitted data, exceptions, and harakiris.


It fetches [Stats Server](https://uwsgi-docs.readthedocs.io/en/latest/StatsServer.html) statistics over TCP.


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

Automatically discovers and collects UWSGI statistics from the following default locations:

- localhost:1717


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per uWSGI instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| uwsgi.transmitted_data | tx | bytes/s |
| uwsgi.requests | requests | requests/s |
| uwsgi.harakiris | harakiris | harakiris/s |
| uwsgi.respawns | respawns | respawns/s |

### Per worker

These metrics refer to the Worker process.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| worker_id | Worker ID. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| uwsgi.worker_transmitted_data | tx | bytes/s |
| uwsgi.worker_requests | requests | requests/s |
| uwsgi.worker_delta_requests | delta_requests | requests/s |
| uwsgi.worker_average_request_time | avg | milliseconds |
| uwsgi.worker_harakiris | harakiris | harakiris/s |
| uwsgi.worker_exceptions | exceptions | exceptions/s |
| uwsgi.worker_status | idle, busy, cheap, pause, sig | status |
| uwsgi.worker_request_handling_status | accepting, not_accepting | status |
| uwsgi.worker_respawns | respawns | respawns/s |
| uwsgi.worker_memory_rss | rss | bytes |
| uwsgi.worker_memory_vsz | vsz | bytes |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Enable the uWSGI Stats Server

See [Stats Server](https://uwsgi-docs.readthedocs.io/en/latest/StatsServer.html) for details.



### Configuration

#### File

The configuration file name for this integration is `go.d/uwsgi.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/uwsgi.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| address | The IP address and port where the UWSGI [Stats Server](https://uwsgi-docs.readthedocs.io/en/latest/StatsServer.html) listens for connections. | 127.0.0.1:1717 | yes |
| timeout | Connection, read, and write timeout duration in seconds. The timeout includes name resolution. | 1 | no |

</details>

#### Examples

##### Basic

A basic example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:1717

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:1717

  - name: remote
    address: 203.0.113.0:1717

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `uwsgi` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m uwsgi
  ```

### Getting Logs

If you're encountering problems with the `uwsgi` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep uwsgi
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep uwsgi /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep uwsgi
```


