+++
title = "htmx 2.0.0-beta1 has been released!"
date = 2024-03-15
[taxonomies]
tag = ["posts", "announcements"]
+++

## htmx 2.0.0-beta1 Release

I'm happy to announce the first beta release of htmx 2.0

This is an _beta_ release and should NOT be considered ready for production.  We are releasing it to begin 
final testing against real world scenarios.

If you are able to do so, please switch to the release and do a quick run through any htmx-powered functionality you
have and let us know if there are issues.

Of particular concern to us are the following changes:

* We removed the deprecated `hx-sse` and `hx-ws` attributes in favor of the extensions (which are available in 1.x)
* `DELETE` requests now use parameters, rather than form encoded bodies, for their payload (This is in accordance w/ the spec.)

A complete upgrade guide can be found here:

[htmx 1.x -> 2.x Migration Guide](@/migration-guide-htmx-1.md)

Note that htmx 2.x will no longer be IE compatible, but 1.x will continue to be supported for IE users.

### Installing

The beta can be installed via a package manager referencing version `2.0.0-beta1`, or can be linked via a CDN:

```html
<script src="https://unpkg.com/htmx.org@2.0.0-beta1/dist/htmx.min.js"></script>
```

or <a href="https://unpkg.com/htmx.org@2.0.0-beta1/dist/htmx.min.js" download>Downloaded</a>

### Extensions

Extensions have been removed from the main codebase and are now in this github repo:

<https://github.com/bigskysoftware/htmx-extensions/tree/main/ext>

They are available at <https://extensions.htmx.org>

There was one breaking change in the extensions, SSE, so you must use the newer version of that extension:

https://github.com/bigskysoftware/htmx-extensions/blob/main/ext/sse.js

### New Features

* Add config option to ignore nested oob-swaps instead of processing them (#1235)
* Add textContent swap style (#2356)
* Complete JSdoc in htmx.js + generated TypeScript definition (Thank you @Telroshan!) (#2336)
* Finished the [extensions website](https://extensions.htmx.org)
* Added an [htmx 1.x compatibility extension](https://github.com/bigskysoftware/htmx-extensions/blob/main/src/htmx-1-compat/README.md)
