{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetTitle: String;
    procedure SetTitle(const Value: String);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdInfo: TMFString;
    { Internal wrapper for property @code(Info). This wrapper API may change, we advise to access simpler @code(Info) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInfo: TMFString read FFdInfo;
    {  }
    procedure SetInfo(const Value: array of string); overload;
    {  }
    procedure SetInfo(const Value: TCastleStringList); overload;

    strict private FFdTitle: TSFString;
    { Internal wrapper for property @code(Title). This wrapper API may change, we advise to access simpler @code(Title) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTitle: TSFString read FFdTitle;
    {  }
    property Title: String read GetTitle write SetTitle;

{$endif read_interface}

{$ifdef read_implementation}

{ TWorldInfoNode ----------------------------------------------- }

procedure TWorldInfoNode.SetInfo(const Value: array of string);
begin
  FdInfo.Send(Value);
end;

procedure TWorldInfoNode.SetInfo(const Value: TCastleStringList);
begin
  FdInfo.Send(Value);
end;

function TWorldInfoNode.GetTitle: String;
begin
  Result := FdTitle.Value;
end;

procedure TWorldInfoNode.SetTitle(const Value: String);
begin
  FdTitle.Send(Value);
end;

class function TWorldInfoNode.ClassX3DType: String;
begin
  Result := 'WorldInfo';
end;

procedure TWorldInfoNode.CreateNode;
begin
  inherited;

  FFdInfo := TMFString.Create(Self, False, 'info', []);
   FdInfo.ChangeAlways := chNone;
  AddField(FFdInfo);

  FFdTitle := TSFString.Create(Self, False, 'title', '');
   FdTitle.ChangeAlways := chNone;
  AddField(FFdTitle);
end;

{$endif read_implementation}
