/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.ual.eawt;

import com.apple.eawt.AppEvent;
import com.apple.eawt.AppEventListener;
import com.apple.eawt.AppHiddenListener;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.Application;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitStrategy;
import com.apple.eawt.ScreenSleepListener;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.AppForegroundEvent;
import java.awt.desktop.AppForegroundListener;
import java.awt.desktop.AppHiddenEvent;
import java.awt.desktop.AppReopenedEvent;
import java.awt.desktop.AppReopenedListener;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.OpenURIEvent;
import java.awt.desktop.OpenURIHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PrintFilesEvent;
import java.awt.desktop.PrintFilesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitResponse;
import java.awt.desktop.ScreenSleepEvent;
import java.awt.desktop.SystemEventListener;
import java.awt.desktop.SystemSleepEvent;
import java.awt.desktop.SystemSleepListener;
import java.awt.desktop.UserSessionEvent;
import java.awt.desktop.UserSessionListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuBar;

public final class NewApplicationAdapter {
    private static NewApplicationAdapter instance = null;
    private final Application application = Application.getApplication();
    private final Map<SystemEventListener, List<AppEventListener>> listeners = new IdentityHashMap<SystemEventListener, List<AppEventListener>>();

    public static NewApplicationAdapter getInstance() {
        if (instance == null) {
            instance = new NewApplicationAdapter();
        }
        return instance;
    }

    private NewApplicationAdapter() {
    }

    public void addAppEventListener(final SystemEventListener systemEventListener) {
        AppEventListener appEventListener;
        List<AppEventListener> list = this.listeners.get(systemEventListener);
        if (list == null) {
            list = new ArrayList<AppEventListener>();
            this.listeners.put(systemEventListener, list);
        }
        if (systemEventListener instanceof AppForegroundListener) {
            appEventListener = new com.apple.eawt.AppForegroundListener(){

                public void appMovedToBackground(AppEvent.AppForegroundEvent appForegroundEvent) {
                    AppForegroundEvent appForegroundEvent2 = new AppForegroundEvent();
                    ((AppForegroundListener)systemEventListener).appMovedToBackground(appForegroundEvent2);
                }

                public void appRaisedToForeground(AppEvent.AppForegroundEvent appForegroundEvent) {
                    AppForegroundEvent appForegroundEvent2 = new AppForegroundEvent();
                    ((AppForegroundListener)systemEventListener).appRaisedToForeground(appForegroundEvent2);
                }
            };
            this.application.addAppEventListener(appEventListener);
            list.add(appEventListener);
        }
        if (systemEventListener instanceof java.awt.desktop.AppHiddenListener) {
            appEventListener = new AppHiddenListener(){

                public void appHidden(AppEvent.AppHiddenEvent appHiddenEvent) {
                    AppHiddenEvent appHiddenEvent2 = new AppHiddenEvent();
                    ((java.awt.desktop.AppHiddenListener)systemEventListener).appHidden(appHiddenEvent2);
                }

                public void appUnhidden(AppEvent.AppHiddenEvent appHiddenEvent) {
                    AppHiddenEvent appHiddenEvent2 = new AppHiddenEvent();
                    ((java.awt.desktop.AppHiddenListener)systemEventListener).appUnhidden(appHiddenEvent2);
                }
            };
            this.application.addAppEventListener(appEventListener);
            list.add(appEventListener);
        }
        if (systemEventListener instanceof AppReopenedListener) {
            appEventListener = new AppReOpenedListener(){

                public void appReOpened(AppEvent.AppReOpenedEvent appReOpenedEvent) {
                    AppReopenedEvent appReopenedEvent = new AppReopenedEvent();
                    ((AppReopenedListener)systemEventListener).appReopened(appReopenedEvent);
                }
            };
            this.application.addAppEventListener(appEventListener);
            list.add(appEventListener);
        }
        if (systemEventListener instanceof java.awt.desktop.ScreenSleepListener) {
            appEventListener = new ScreenSleepListener(){

                public void screenAboutToSleep(AppEvent.ScreenSleepEvent screenSleepEvent) {
                    ScreenSleepEvent screenSleepEvent2 = new ScreenSleepEvent();
                    ((java.awt.desktop.ScreenSleepListener)systemEventListener).screenAboutToSleep(screenSleepEvent2);
                }

                public void screenAwoke(AppEvent.ScreenSleepEvent screenSleepEvent) {
                    ScreenSleepEvent screenSleepEvent2 = new ScreenSleepEvent();
                    ((java.awt.desktop.ScreenSleepListener)systemEventListener).screenAwoke(screenSleepEvent2);
                }
            };
            this.application.addAppEventListener(appEventListener);
            list.add(appEventListener);
        }
        if (systemEventListener instanceof SystemSleepListener) {
            appEventListener = new com.apple.eawt.SystemSleepListener(){

                public void systemAboutToSleep(AppEvent.SystemSleepEvent systemSleepEvent) {
                    SystemSleepEvent systemSleepEvent2 = new SystemSleepEvent();
                    ((SystemSleepListener)systemEventListener).systemAboutToSleep(systemSleepEvent2);
                }

                public void systemAwoke(AppEvent.SystemSleepEvent systemSleepEvent) {
                    SystemSleepEvent systemSleepEvent2 = new SystemSleepEvent();
                    ((SystemSleepListener)systemEventListener).systemAwoke(systemSleepEvent2);
                }
            };
            this.application.addAppEventListener(appEventListener);
            list.add(appEventListener);
        }
        if (systemEventListener instanceof UserSessionListener) {
            appEventListener = new com.apple.eawt.UserSessionListener(){

                public void userSessionActivated(AppEvent.UserSessionEvent userSessionEvent) {
                    UserSessionEvent.Reason reason = UserSessionEvent.Reason.UNSPECIFIED;
                    UserSessionEvent userSessionEvent2 = new UserSessionEvent(reason);
                    ((UserSessionListener)systemEventListener).userSessionActivated(userSessionEvent2);
                }

                public void userSessionDeactivated(AppEvent.UserSessionEvent userSessionEvent) {
                    UserSessionEvent.Reason reason = UserSessionEvent.Reason.UNSPECIFIED;
                    UserSessionEvent userSessionEvent2 = new UserSessionEvent(reason);
                    ((UserSessionListener)systemEventListener).userSessionDeactivated(userSessionEvent2);
                }
            };
            this.application.addAppEventListener(appEventListener);
            list.add(appEventListener);
        }
    }

    public void removeAppEventListener(SystemEventListener systemEventListener) {
        List<AppEventListener> list = this.listeners.remove(systemEventListener);
        if (list != null) {
            for (AppEventListener appEventListener : list) {
                this.application.removeAppEventListener(appEventListener);
            }
        }
    }

    public void disableSuddenTermination() {
        this.application.disableSuddenTermination();
    }

    public void enableSuddenTermination() {
        this.application.enableSuddenTermination();
    }

    public void openHelpViewer() {
        this.application.openHelpViewer();
    }

    public void requestForeground(boolean bl) {
        this.application.requestForeground(bl);
    }

    public void setAboutHandler(final AboutHandler aboutHandler) {
        this.application.setAboutHandler(new com.apple.eawt.AboutHandler(){

            public void handleAbout(AppEvent.AboutEvent aboutEvent) {
                aboutHandler.handleAbout(new AboutEvent());
            }
        });
    }

    public void setDefaultMenuBar(JMenuBar jMenuBar) {
        this.application.setDefaultMenuBar(jMenuBar);
    }

    public void setOpenFileHandler(final OpenFilesHandler openFilesHandler) {
        this.application.setOpenFileHandler(new com.apple.eawt.OpenFilesHandler(){

            public void openFiles(AppEvent.OpenFilesEvent openFilesEvent) {
                openFilesHandler.openFiles(new OpenFilesEvent(openFilesEvent.getFiles(), openFilesEvent.getSearchTerm()));
            }
        });
    }

    public void setOpenURIHandler(final OpenURIHandler openURIHandler) {
        this.application.setOpenURIHandler(new com.apple.eawt.OpenURIHandler(){

            public void openURI(AppEvent.OpenURIEvent openURIEvent) {
                openURIHandler.openURI(new OpenURIEvent(openURIEvent.getURI()));
            }
        });
    }

    public void setPreferencesHandler(final java.awt.desktop.PreferencesHandler preferencesHandler) {
        this.application.setPreferencesHandler(new PreferencesHandler(){

            public void handlePreferences(AppEvent.PreferencesEvent preferencesEvent) {
                preferencesHandler.handlePreferences(new PreferencesEvent());
            }
        });
    }

    public void setPrintFileHandler(final PrintFilesHandler printFilesHandler) {
        this.application.setPrintFileHandler(new com.apple.eawt.PrintFilesHandler(){

            public void printFiles(AppEvent.PrintFilesEvent printFilesEvent) {
                printFilesHandler.printFiles(new PrintFilesEvent(printFilesEvent.getFiles()));
            }
        });
    }

    public void setQuitHandler(final java.awt.desktop.QuitHandler quitHandler) {
        this.application.setQuitHandler(new QuitHandler(){

            public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, final com.apple.eawt.QuitResponse quitResponse) {
                quitHandler.handleQuitRequestWith(new QuitEvent(), new QuitResponse(){

                    public void performQuit() {
                        quitResponse.performQuit();
                    }

                    public void cancelQuit() {
                        quitResponse.cancelQuit();
                    }
                });
            }
        });
    }

    public void setQuitStrategy(java.awt.desktop.QuitStrategy quitStrategy) {
        switch (quitStrategy) {
            case CLOSE_ALL_WINDOWS: {
                this.application.setQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
                break;
            }
            case NORMAL_EXIT: {
                this.application.setQuitStrategy(QuitStrategy.SYSTEM_EXIT_0);
            }
        }
    }
}

