/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "hy" locale.
 */
public class LocalizedNamesImpl_hy extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AI",
        "AN",
        "AQ",
        "AS",
        "AW",
        "AX",
        "BL",
        "BM",
        "BV",
        "CC",
        "CD",
        "CK",
        "CP",
        "CX",
        "DG",
        "EA",
        "EU",
        "FK",
        "FO",
        "GF",
        "GG",
        "GI",
        "GL",
        "GP",
        "GS",
        "GU",
        "HK",
        "HM",
        "IC",
        "IM",
        "IO",
        "JE",
        "KY",
        "ME",
        "MF",
        "MO",
        "MP",
        "MQ",
        "MS",
        "NC",
        "NF",
        "NU",
        "PF",
        "PM",
        "PN",
        "PR",
        "PS",
        "QO",
        "RE",
        "RS",
        "SH",
        "SJ",
        "TA",
        "TC",
        "TF",
        "TK",
        "TL",
        "UM",
        "VG",
        "VI",
        "WF",
        "YT",
        "AZ",
        "AL",
        "DZ",
        "US",
        "AO",
        "AD",
        "AG",
        "AU",
        "AT",
        "AR",
        "EH",
        "AF",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BY",
        "BJ",
        "BO",
        "BA",
        "BW",
        "BG",
        "BT",
        "BF",
        "BI",
        "BR",
        "BN",
        "GA",
        "GM",
        "GY",
        "GH",
        "DE",
        "GT",
        "GN",
        "GW",
        "GD",
        "DK",
        "DM",
        "DO",
        "EG",
        "ET",
        "YE",
        "ZM",
        "ZW",
        "EC",
        "EE",
        "ER",
        "TH",
        "TW",
        "TN",
        "TR",
        "TM",
        "ID",
        "IE",
        "IS",
        "ES",
        "IL",
        "IT",
        "IR",
        "IQ",
        "LA",
        "LV",
        "PL",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "CV",
        "KH",
        "CM",
        "CA",
        "QA",
        "CF",
        "CY",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "CR",
        "CU",
        "HT",
        "AM",
        "GQ",
        "ZA",
        "KR",
        "KP",
        "IN",
        "HN",
        "JO",
        "HR",
        "GR",
        "HU",
        "KZ",
        "JP",
        "MG",
        "MY",
        "MW",
        "MV",
        "MT",
        "ML",
        "MK",
        "MR",
        "MU",
        "MH",
        "MA",
        "GB",
        "MX",
        "AE",
        "FM",
        "MM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NL",
        "NI",
        "NZ",
        "NO",
        "SE",
        "CH",
        "LK",
        "UG",
        "UZ",
        "UA",
        "UY",
        "TD",
        "CZ",
        "CL",
        "CN",
        "PW",
        "PK",
        "PA",
        "PG",
        "PY",
        "PE",
        "PT",
        "JM",
        "DJ",
        "RW",
        "RO",
        "RU",
        "SV",
        "WS",
        "ST",
        "SM",
        "LC",
        "SA",
        "SC",
        "SN",
        "KN",
        "VC",
        "CS",
        "SG",
        "SY",
        "SK",
        "SI",
        "SL",
        "SB",
        "SO",
        "SD",
        "SR",
        "SZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "GE",
        "TJ",
        "TZ",
        "TG",
        "TO",
        "TV",
        "TT",
        "CI",
        "KE",
        "KW",
        "OM",
        "PH",
        "FI",
        "FJ",
        "FR",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Աշխարհ");
    namesMap.put("002", "Աֆրիկա");
    namesMap.put("005", "Հարավային Ամերիկա");
    namesMap.put("011", "Արևմտյան Աֆրիկա");
    namesMap.put("014", "Արևելյան Աֆրիկա");
    namesMap.put("015", "Հյուսիսային Աֆրիկա");
    namesMap.put("018", "Հարավային Աֆրիկա [018]");
    namesMap.put("AD", "Անդորա");
    namesMap.put("AE", "Միացյալ Արաբական Էմիրաթներ");
    namesMap.put("AF", "Աֆղանստան");
    namesMap.put("AG", "Անտիգուա-Բարբուդա");
    namesMap.put("AL", "Ալբանիա");
    namesMap.put("AM", "Հայաստանի Հանրապետութիւն");
    namesMap.put("AO", "Անգոլա");
    namesMap.put("AR", "Արգենտինա");
    namesMap.put("AT", "Ավստրիա");
    namesMap.put("AU", "Ավստրալիա");
    namesMap.put("AZ", "Ադրբեջան");
    namesMap.put("BA", "Բոսնիա-Հերցեգովինա");
    namesMap.put("BB", "Բարբադոս");
    namesMap.put("BD", "Բանգլադեշ");
    namesMap.put("BE", "Բելգիա");
    namesMap.put("BF", "Բուրկինա Ֆասո");
    namesMap.put("BG", "Բուլղարիա");
    namesMap.put("BH", "Բահրեյն");
    namesMap.put("BI", "Բուրունդի");
    namesMap.put("BJ", "Բենին");
    namesMap.put("BN", "Բրունեյ");
    namesMap.put("BO", "Բոլիվիա");
    namesMap.put("BR", "Բրազիլիա");
    namesMap.put("BS", "Բահամներ");
    namesMap.put("BT", "Բուտան");
    namesMap.put("BW", "Բոտսվանա");
    namesMap.put("BY", "Բելոռուս");
    namesMap.put("BZ", "Բելիզ");
    namesMap.put("CA", "Կանադա");
    namesMap.put("CF", "Կենտրոնական Աֆրիկյան Հանրապետություն");
    namesMap.put("CG", "Կոնգո");
    namesMap.put("CH", "Շվեյցարիա");
    namesMap.put("CI", "Փղոսկրի Ափ");
    namesMap.put("CL", "Չիլի");
    namesMap.put("CM", "Կամերուն");
    namesMap.put("CN", "Չինաստան");
    namesMap.put("CO", "Կոլումբիա");
    namesMap.put("CR", "Կոստա-Ռիկա");
    namesMap.put("CS", "Սերբիա և Մոնտենեգրո");
    namesMap.put("CU", "Կուբա");
    namesMap.put("CV", "Կաբո-Վերդե");
    namesMap.put("CY", "Կիպրոս");
    namesMap.put("CZ", "Չեխիայի Հանրապետություն");
    namesMap.put("DE", "Գերմանիա");
    namesMap.put("DJ", "Ջիբուտի");
    namesMap.put("DK", "Դանիա");
    namesMap.put("DM", "Դոմինիկա");
    namesMap.put("DO", "Դոմինիկյան Հանրապետություն");
    namesMap.put("DZ", "Ալժիր");
    namesMap.put("EC", "Էկվադոր");
    namesMap.put("EE", "Էստոնիա");
    namesMap.put("EG", "Եգիպտոս");
    namesMap.put("EH", "Արեվմտյան Սահարա");
    namesMap.put("ER", "Էրիտրեա");
    namesMap.put("ES", "Իսպանիա");
    namesMap.put("ET", "Եթովպիա");
    namesMap.put("FI", "Ֆինլանդիա");
    namesMap.put("FJ", "Ֆիջի");
    namesMap.put("FM", "Միկրոնեզիա");
    namesMap.put("FR", "Ֆրանսիա");
    namesMap.put("GA", "Գաբոն");
    namesMap.put("GB", "Մեծ Բրիտանիա");
    namesMap.put("GD", "Գրենադա");
    namesMap.put("GE", "Վրաստան");
    namesMap.put("GH", "Գանա");
    namesMap.put("GM", "Գամբիա");
    namesMap.put("GN", "Գվինեա");
    namesMap.put("GQ", "Հասարակածային Գվինեա");
    namesMap.put("GR", "Հունաստան");
    namesMap.put("GT", "Գվատեմալա");
    namesMap.put("GW", "Գվինեա-Բիսաու");
    namesMap.put("GY", "Գայանա");
    namesMap.put("HN", "Հոնդուրաս");
    namesMap.put("HR", "Հորվաթիա");
    namesMap.put("HT", "Հաիթի");
    namesMap.put("HU", "Հունգարիա");
    namesMap.put("ID", "Ինդոնեզիա");
    namesMap.put("IE", "Իռլանդիա");
    namesMap.put("IL", "Իսրայել");
    namesMap.put("IN", "Հնդկաստան");
    namesMap.put("IQ", "Իրաք");
    namesMap.put("IR", "Իրան");
    namesMap.put("IS", "Իսլանդիա");
    namesMap.put("IT", "Իտալիա");
    namesMap.put("JM", "Ջամայկա");
    namesMap.put("JO", "Հորդանան");
    namesMap.put("JP", "Ճապոնիա");
    namesMap.put("KE", "Քենիա");
    namesMap.put("KG", "Կիրգիզստան");
    namesMap.put("KH", "Կամբոջա");
    namesMap.put("KI", "Կիրիբատի");
    namesMap.put("KM", "Կոմորոս");
    namesMap.put("KN", "Սենտ Կիտս-Նեվիս");
    namesMap.put("KP", "Հյուսիսային Կորեա");
    namesMap.put("KR", "Հարավային Կորեա");
    namesMap.put("KW", "Քուվեյթ");
    namesMap.put("KZ", "Ղազախստան");
    namesMap.put("LA", "Լաոս");
    namesMap.put("LB", "Լիբանան");
    namesMap.put("LC", "Սանտա Լուչիա");
    namesMap.put("LI", "Լիխտենշտեյն");
    namesMap.put("LK", "Շրի Լանկա");
    namesMap.put("LR", "Լիբերիա");
    namesMap.put("LS", "Լեսոտո");
    namesMap.put("LT", "Լիտվա");
    namesMap.put("LU", "Լյուքսեմբուրգ");
    namesMap.put("LV", "Լատվիա");
    namesMap.put("LY", "Լիբիա");
    namesMap.put("MA", "Մարոկո");
    namesMap.put("MC", "Մոնակո");
    namesMap.put("MD", "Մոլդովա");
    namesMap.put("MG", "Մադագասկար");
    namesMap.put("MH", "Մարշալյան կղզիներ");
    namesMap.put("MK", "Մակեդոնիա");
    namesMap.put("ML", "Մալի");
    namesMap.put("MM", "Մյանմա");
    namesMap.put("MN", "Մոնղոլիա");
    namesMap.put("MR", "Մավրիտանիա");
    namesMap.put("MT", "Մալթա");
    namesMap.put("MU", "Մավրիտոս");
    namesMap.put("MV", "Մալդիվներ");
    namesMap.put("MW", "Մալավի");
    namesMap.put("MX", "Մեքսիկա");
    namesMap.put("MY", "Մալայզիա");
    namesMap.put("MZ", "Մոզամբիկ");
    namesMap.put("NA", "Նամիբիա");
    namesMap.put("NE", "Նիգեր");
    namesMap.put("NG", "Նիգերիա");
    namesMap.put("NI", "Նիկարագուա");
    namesMap.put("NL", "Նիդերլանդեր");
    namesMap.put("NO", "Նորվեգիա");
    namesMap.put("NP", "Նեպալ");
    namesMap.put("NR", "Նաուրու");
    namesMap.put("NZ", "Նոր Զելանդիա");
    namesMap.put("OM", "Օման");
    namesMap.put("PA", "Պանամա");
    namesMap.put("PE", "Պերու");
    namesMap.put("PG", "Պապուա Նոր Գվինեա");
    namesMap.put("PH", "Ֆիլիպիններ");
    namesMap.put("PK", "Պակիստան");
    namesMap.put("PL", "Լեհաստան");
    namesMap.put("PT", "Պորտուգալիա");
    namesMap.put("PW", "Պալաու");
    namesMap.put("PY", "Պարագվայ");
    namesMap.put("QA", "Կատար");
    namesMap.put("RO", "Ռումինիա");
    namesMap.put("RU", "Ռուսաստան");
    namesMap.put("RW", "Ռուանդա");
    namesMap.put("SA", "Սաուդիան Արաբիա");
    namesMap.put("SB", "Սոլոմոնյան կղզիներ");
    namesMap.put("SC", "Սեյշելներ");
    namesMap.put("SD", "Սուդան");
    namesMap.put("SE", "Շվեդիա");
    namesMap.put("SG", "Սինգապուր");
    namesMap.put("SI", "Սլովենիա");
    namesMap.put("SK", "Սլովակիա");
    namesMap.put("SL", "Սյերա-Լեոնե");
    namesMap.put("SM", "Սան Մարինո");
    namesMap.put("SN", "Սենեգալ");
    namesMap.put("SO", "Սոմալի");
    namesMap.put("SR", "Սուրինամ");
    namesMap.put("ST", "Սան-Թոմե-Փրինսիպի");
    namesMap.put("SV", "Սալվադոր");
    namesMap.put("SY", "Սիրիա");
    namesMap.put("SZ", "Սվազիլենդ");
    namesMap.put("TD", "Չադ");
    namesMap.put("TG", "Տոգո");
    namesMap.put("TH", "Թաիլանդ");
    namesMap.put("TJ", "Տաճիկստան");
    namesMap.put("TM", "Թուրքմենստան");
    namesMap.put("TN", "Թունիս");
    namesMap.put("TO", "Տոնգա");
    namesMap.put("TR", "Թուրքիա");
    namesMap.put("TT", "Տրինիդադ-Տոբագո");
    namesMap.put("TV", "Տուվալու");
    namesMap.put("TW", "Թայվան");
    namesMap.put("TZ", "Տանզանիա");
    namesMap.put("UA", "Ուկրաինա");
    namesMap.put("UG", "Ուգանդա");
    namesMap.put("US", "Ամէրիկայի Միացյալ Նահանգնէր");
    namesMap.put("UY", "Ուրուգվայ");
    namesMap.put("UZ", "Ուզբեկստան");
    namesMap.put("VA", "Վատիկան");
    namesMap.put("VC", "Սենտ Վիսենտ-Գրենադիններ");
    namesMap.put("VE", "Վենեսուելա");
    namesMap.put("VN", "Վիետնամ");
    namesMap.put("VU", "Վանուատու");
    namesMap.put("WS", "Սամոա");
    namesMap.put("YE", "Եմեն");
    namesMap.put("ZA", "Հարավային Աֆրիկա");
    namesMap.put("ZM", "Զամբիա");
    namesMap.put("ZW", "Զիմբաբվե");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Աշխարհ",
        "002": "Աֆրիկա",
        "005": "Հարավային Ամերիկա",
        "011": "Արևմտյան Աֆրիկա",
        "014": "Արևելյան Աֆրիկա",
        "015": "Հյուսիսային Աֆրիկա",
        "018": "Հարավային Աֆրիկա [018]",
        "AD": "Անդորա",
        "AE": "Միացյալ Արաբական Էմիրաթներ",
        "AF": "Աֆղանստան",
        "AG": "Անտիգուա-Բարբուդա",
        "AL": "Ալբանիա",
        "AM": "Հայաստանի Հանրապետութիւն",
        "AO": "Անգոլա",
        "AR": "Արգենտինա",
        "AT": "Ավստրիա",
        "AU": "Ավստրալիա",
        "AZ": "Ադրբեջան",
        "BA": "Բոսնիա-Հերցեգովինա",
        "BB": "Բարբադոս",
        "BD": "Բանգլադեշ",
        "BE": "Բելգիա",
        "BF": "Բուրկինա Ֆասո",
        "BG": "Բուլղարիա",
        "BH": "Բահրեյն",
        "BI": "Բուրունդի",
        "BJ": "Բենին",
        "BN": "Բրունեյ",
        "BO": "Բոլիվիա",
        "BR": "Բրազիլիա",
        "BS": "Բահամներ",
        "BT": "Բուտան",
        "BW": "Բոտսվանա",
        "BY": "Բելոռուս",
        "BZ": "Բելիզ",
        "CA": "Կանադա",
        "CF": "Կենտրոնական Աֆրիկյան Հանրապետություն",
        "CG": "Կոնգո",
        "CH": "Շվեյցարիա",
        "CI": "Փղոսկրի Ափ",
        "CL": "Չիլի",
        "CM": "Կամերուն",
        "CN": "Չինաստան",
        "CO": "Կոլումբիա",
        "CR": "Կոստա-Ռիկա",
        "CS": "Սերբիա և Մոնտենեգրո",
        "CU": "Կուբա",
        "CV": "Կաբո-Վերդե",
        "CY": "Կիպրոս",
        "CZ": "Չեխիայի Հանրապետություն",
        "DE": "Գերմանիա",
        "DJ": "Ջիբուտի",
        "DK": "Դանիա",
        "DM": "Դոմինիկա",
        "DO": "Դոմինիկյան Հանրապետություն",
        "DZ": "Ալժիր",
        "EC": "Էկվադոր",
        "EE": "Էստոնիա",
        "EG": "Եգիպտոս",
        "EH": "Արեվմտյան Սահարա",
        "ER": "Էրիտրեա",
        "ES": "Իսպանիա",
        "ET": "Եթովպիա",
        "FI": "Ֆինլանդիա",
        "FJ": "Ֆիջի",
        "FM": "Միկրոնեզիա",
        "FR": "Ֆրանսիա",
        "GA": "Գաբոն",
        "GB": "Մեծ Բրիտանիա",
        "GD": "Գրենադա",
        "GE": "Վրաստան",
        "GH": "Գանա",
        "GM": "Գամբիա",
        "GN": "Գվինեա",
        "GQ": "Հասարակածային Գվինեա",
        "GR": "Հունաստան",
        "GT": "Գվատեմալա",
        "GW": "Գվինեա-Բիսաու",
        "GY": "Գայանա",
        "HN": "Հոնդուրաս",
        "HR": "Հորվաթիա",
        "HT": "Հաիթի",
        "HU": "Հունգարիա",
        "ID": "Ինդոնեզիա",
        "IE": "Իռլանդիա",
        "IL": "Իսրայել",
        "IN": "Հնդկաստան",
        "IQ": "Իրաք",
        "IR": "Իրան",
        "IS": "Իսլանդիա",
        "IT": "Իտալիա",
        "JM": "Ջամայկա",
        "JO": "Հորդանան",
        "JP": "Ճապոնիա",
        "KE": "Քենիա",
        "KG": "Կիրգիզստան",
        "KH": "Կամբոջա",
        "KI": "Կիրիբատի",
        "KM": "Կոմորոս",
        "KN": "Սենտ Կիտս-Նեվիս",
        "KP": "Հյուսիսային Կորեա",
        "KR": "Հարավային Կորեա",
        "KW": "Քուվեյթ",
        "KZ": "Ղազախստան",
        "LA": "Լաոս",
        "LB": "Լիբանան",
        "LC": "Սանտա Լուչիա",
        "LI": "Լիխտենշտեյն",
        "LK": "Շրի Լանկա",
        "LR": "Լիբերիա",
        "LS": "Լեսոտո",
        "LT": "Լիտվա",
        "LU": "Լյուքսեմբուրգ",
        "LV": "Լատվիա",
        "LY": "Լիբիա",
        "MA": "Մարոկո",
        "MC": "Մոնակո",
        "MD": "Մոլդովա",
        "MG": "Մադագասկար",
        "MH": "Մարշալյան կղզիներ",
        "MK": "Մակեդոնիա",
        "ML": "Մալի",
        "MM": "Մյանմա",
        "MN": "Մոնղոլիա",
        "MR": "Մավրիտանիա",
        "MT": "Մալթա",
        "MU": "Մավրիտոս",
        "MV": "Մալդիվներ",
        "MW": "Մալավի",
        "MX": "Մեքսիկա",
        "MY": "Մալայզիա",
        "MZ": "Մոզամբիկ",
        "NA": "Նամիբիա",
        "NE": "Նիգեր",
        "NG": "Նիգերիա",
        "NI": "Նիկարագուա",
        "NL": "Նիդերլանդեր",
        "NO": "Նորվեգիա",
        "NP": "Նեպալ",
        "NR": "Նաուրու",
        "NZ": "Նոր Զելանդիա",
        "OM": "Օման",
        "PA": "Պանամա",
        "PE": "Պերու",
        "PG": "Պապուա Նոր Գվինեա",
        "PH": "Ֆիլիպիններ",
        "PK": "Պակիստան",
        "PL": "Լեհաստան",
        "PT": "Պորտուգալիա",
        "PW": "Պալաու",
        "PY": "Պարագվայ",
        "QA": "Կատար",
        "RO": "Ռումինիա",
        "RU": "Ռուսաստան",
        "RW": "Ռուանդա",
        "SA": "Սաուդիան Արաբիա",
        "SB": "Սոլոմոնյան կղզիներ",
        "SC": "Սեյշելներ",
        "SD": "Սուդան",
        "SE": "Շվեդիա",
        "SG": "Սինգապուր",
        "SI": "Սլովենիա",
        "SK": "Սլովակիա",
        "SL": "Սյերա-Լեոնե",
        "SM": "Սան Մարինո",
        "SN": "Սենեգալ",
        "SO": "Սոմալի",
        "SR": "Սուրինամ",
        "ST": "Սան-Թոմե-Փրինսիպի",
        "SV": "Սալվադոր",
        "SY": "Սիրիա",
        "SZ": "Սվազիլենդ",
        "TD": "Չադ",
        "TG": "Տոգո",
        "TH": "Թաիլանդ",
        "TJ": "Տաճիկստան",
        "TM": "Թուրքմենստան",
        "TN": "Թունիս",
        "TO": "Տոնգա",
        "TR": "Թուրքիա",
        "TT": "Տրինիդադ-Տոբագո",
        "TV": "Տուվալու",
        "TW": "Թայվան",
        "TZ": "Տանզանիա",
        "UA": "Ուկրաինա",
        "UG": "Ուգանդա",
        "US": "Ամէրիկայի Միացյալ Նահանգնէր",
        "UY": "Ուրուգվայ",
        "UZ": "Ուզբեկստան",
        "VA": "Վատիկան",
        "VC": "Սենտ Վիսենտ-Գրենադիններ",
        "VE": "Վենեսուելա",
        "VN": "Վիետնամ",
        "VU": "Վանուատու",
        "WS": "Սամոա",
        "YE": "Եմեն",
        "ZA": "Հարավային Աֆրիկա",
        "ZM": "Զամբիա",
        "ZW": "Զիմբաբվե"
    };
  }-*/;
}
