/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.google.gwt.text.shared.SimpleSafeHtmlRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberCell
extends AbstractCell<Number> {
    private final NumberFormat format;
    private final SafeHtmlRenderer<String> renderer;

    public NumberCell() {
        this(NumberFormat.getDecimalFormat(), SimpleSafeHtmlRenderer.getInstance());
    }

    public NumberCell(NumberFormat format) {
        this(format, SimpleSafeHtmlRenderer.getInstance());
    }

    public NumberCell(SafeHtmlRenderer<String> renderer) {
        this(NumberFormat.getDecimalFormat(), renderer);
    }

    public NumberCell(NumberFormat format, SafeHtmlRenderer<String> renderer) {
        super(new String[0]);
        if (format == null) {
            throw new IllegalArgumentException("format == null");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("renderer == null");
        }
        this.format = format;
        this.renderer = renderer;
    }

    @Override
    public void render(Cell.Context context, Number value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render(this.format.format(value)));
        }
    }
}

