/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.soap;

import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.exceptions.ServiceAccessException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.service.ServiceCallConfig;
import amazon.fws.clicommando.security.CryptoProxy;
import amazon.fws.clicommando.soap.SoapClientHelper;
import amazon.fws.clicommando.soap.SoapSigner;
import amazon.fws.clicommando.util.ConsoleOutputControl;
import amazon.fws.clicommando.util.ExceptionUtils;
import amazon.fws.clicommando.util.ReflectionUtil;
import amazon.fws.clicommando.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.util.dom.DOMInHandler;
import org.codehaus.xfire.util.dom.DOMOutHandler;
import org.w3c.dom.Document;
import sun.security.provider.certpath.SunCertPathBuilderException;

public class SoapClient {
    public static final String SOAP_HEADER_START_TAG = "<Header>";
    public static final String SOAP_HEADER_END_TAG = "</Header>";
    public static final String SOAP_BODY_START_TAG = "<Body>";
    public static final String SOAP_BODY_END_TAG = "</Body>";
    private ServiceCallConfig callConfig;
    private Object portObject;
    private CryptoProxy crypto;
    private Object request;
    private Client client = null;
    private SoapSigner soapSigner = null;
    private Document requestBody;
    private int httpStatusCode;
    private String responseBodyString;
    private String responseHeaderString;

    public SoapClient(ServiceCallConfig callConfig) {
        this.callConfig = callConfig;
        this.init();
    }

    public void call() {
        String commandClassName = this.callConfig.getAction();
        StringBuilder commandMethodName = new StringBuilder();
        this.setMemoryOutput();
        commandMethodName.append(commandClassName);
        ReflectionUtil.toMethodName(commandMethodName);
        this.createRequestObject();
        ReflectionUtil.loadParameters(this.request, this.callConfig.getParameters());
        this.invokeRequest(commandClassName, commandMethodName.toString());
        this.setConsoleOutput();
    }

    public void init() {
        this.crypto = new CryptoProxy(this.callConfig.getPrivateSecretReference(), this.callConfig.getPublicSecretReference());
        this.portObject = SoapClientHelper.createServicePort(this.callConfig.getServiceName(), this.callConfig.getServicePackage(), this.callConfig.getServiceUrl());
        this.client = Client.getInstance((Object)this.portObject);
        this.addHandlers(this.client);
        HttpClientParams params = new HttpClientParams();
        params.setSoTimeout(this.callConfig.getTimeout());
        this.client.setProperty("httpClient.params", (Object)params);
        this.client.setProperty("disable.expect-continue", (Object)"true");
        this.client.setProperty("Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; XFire Client +http://xfire.codehaus.org)", (Object)this.callConfig.getUserAgent());
    }

    public void addHandlers(Client client) {
        client.addOutHandler((Handler)new DOMOutHandler());
        AbstractHandler signatureHandler = new AbstractHandler(){

            public void invoke(MessageContext ctx) throws Exception {
                Document doc = (Document)ctx.getOutMessage().getProperty((Object)"dom.message");
                if (SoapClient.this.soapSigner != null) {
                    SoapClient.this.soapSigner.sign(doc, SoapClient.this.crypto, SoapClient.this.callConfig.getSoapVersion());
                }
                SoapClient.this.requestBody = doc;
                SoapClient.this.responseBodyString = null;
                SoapClient.this.responseHeaderString = null;
                SoapClient.this.httpStatusCode = 0;
            }
        };
        client.addOutHandler((Handler)signatureHandler);
        client.addInHandler((Handler)new DOMInHandler());
        client.addInHandler((Handler)new AbstractHandler(){

            public void invoke(MessageContext ctx) throws Exception {
                SoapClient.this.httpStatusCode = (Integer)ctx.getProperty("http.status.code");
                Document doc = (Document)ctx.getInMessage().getProperty((Object)"dom.message");
                SoapClient.this.createHeaderBody(StringUtils.xmlToString(doc));
            }
        });
        client.addFaultHandler((Handler)new AbstractHandler(){

            public void invoke(MessageContext ctx) throws Exception {
                SoapClient.this.httpStatusCode = (Integer)ctx.getProperty("http.status.code");
                Document doc = (Document)ctx.getInMessage().getProperty((Object)"dom.message");
                SoapClient.this.createHeaderBody(StringUtils.xmlToString(doc));
            }
        });
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public final String getRequestBody() {
        return StringUtils.xmlToString(this.requestBody);
    }

    public final String getResponseBody() {
        return this.responseBodyString == null ? "" : this.responseBodyString;
    }

    public final String getResponseHeader() {
        return "BEGIN: Soap response header\n" + this.responseHeaderString + "\nEND: Soap response header";
    }

    private void createHeaderBody(String soapResponseXml) {
        String header = StringUtils.substring(soapResponseXml, SOAP_HEADER_START_TAG, SOAP_HEADER_END_TAG);
        String body = StringUtils.substring(soapResponseXml, SOAP_BODY_START_TAG, SOAP_BODY_END_TAG);
        this.responseBodyString = body == null ? "" : body;
        this.responseHeaderString = header == null ? "" : header;
    }

    public void setSoapSigner(SoapSigner soapSigner) {
        this.soapSigner = soapSigner;
    }

    private void createRequestObject() {
        try {
            this.request = SoapClientHelper.createRequest(this.callConfig.getServiceName(), this.callConfig.getServicePackage(), this.callConfig.getAction());
        }
        catch (InternalErrorException e) {
            throw new BadInputException(ErrorMessages.ErrorCode.ILLEGAL_COMMAND, this.callConfig.getAction());
        }
    }

    private void invokeRequest(String commandClassName, String commandMethodName) {
        block13: {
            Class[] paramTypes = new Class[]{this.request.getClass()};
            Object[] paramsArgs = new Object[]{this.request};
            try {
                try {
                    Method method = this.portObject.getClass().getDeclaredMethod(commandMethodName, paramTypes);
                    method.invoke(this.portObject, paramsArgs);
                }
                catch (InvocationTargetException e) {
                    String errMsg;
                    Exception rootCause = ExceptionUtils.getRootCause(e, null);
                    if (rootCause instanceof CliCommandoException) {
                        throw (CliCommandoException)rootCause;
                    }
                    if (this.httpStatusCode > 0 && rootCause instanceof XFireFault && (errMsg = rootCause.getLocalizedMessage()) != null && errMsg.contains("WSSecurityCorruptSignedInfo")) {
                        throw new BadInputException(ErrorMessages.ErrorCode.BAD_CREDENTIALS_CANNOT_SIGN, errMsg);
                    }
                    if (!(rootCause instanceof UnmarshalException) && this.httpStatusCode == 0) {
                        if (rootCause instanceof UnknownHostException || rootCause instanceof ConnectException) {
                            throw new BadInputException(ErrorMessages.ErrorCode.MALFORMED_URL, "Reason: " + rootCause.getMessage() + " - " + this.callConfig.getServiceUrl());
                        }
                        if (rootCause instanceof SocketTimeoutException) {
                            throw new ServiceAccessException(e.getMessage(), ErrorMessages.ErrorCode.COMMAND_TIMEOUT, new String[0]);
                        }
                        if (rootCause instanceof SunCertPathBuilderException) {
                            throw new BadInputException(ErrorMessages.ErrorCode.SSL_NOT_AUTH, rootCause.getLocalizedMessage());
                        }
                        if (rootCause instanceof IllegalArgumentException) {
                            String msg = rootCause.getMessage();
                            String string = msg = msg == null ? "" : msg;
                            if (msg.contains("host")) {
                                throw new BadInputException(ErrorMessages.ErrorCode.MALFORMED_URL, "Reason: " + rootCause.getMessage() + " - " + this.callConfig.getServiceUrl());
                            }
                        }
                        throw new InternalErrorException("Failure reason: " + rootCause.getLocalizedMessage(), rootCause);
                    }
                    Object var9_9 = null;
                    this.setConsoleOutput();
                    break block13;
                }
                catch (Exception e) {
                    throw new ConfigurationErrorException("Cannot get command class: " + commandClassName + " Reason: " + e.getLocalizedMessage());
                }
                Object var9_8 = null;
                this.setConsoleOutput();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.setConsoleOutput();
                throw throwable;
            }
        }
    }

    private void setMemoryOutput() {
        ConsoleOutputControl.consoleStderr(false);
        ConsoleOutputControl.consoleStdout(false);
        ConsoleOutputControl.resetStderr();
        ConsoleOutputControl.resetStdout();
    }

    private void setConsoleOutput() {
        ConsoleOutputControl.consoleStderr(true);
        ConsoleOutputControl.consoleStdout(true);
        ConsoleOutputControl.resetStderr();
        ConsoleOutputControl.resetStdout();
    }
}

