/* automatically generated by rust-bindgen 0.72.0 */

#[doc = " Everything ok, no error occurred."]
pub const heif_error_code_heif_error_Ok: heif_error_code = 0;
#[doc = " Input file does not exist."]
pub const heif_error_code_heif_error_Input_does_not_exist: heif_error_code = 1;
#[doc = " Error in input file. Corrupted or invalid content."]
pub const heif_error_code_heif_error_Invalid_input: heif_error_code = 2;
#[doc = " Input file type is not supported."]
pub const heif_error_code_heif_error_Unsupported_filetype: heif_error_code = 3;
#[doc = " Image requires an unsupported decoder feature."]
pub const heif_error_code_heif_error_Unsupported_feature: heif_error_code = 4;
#[doc = " Library API has been used in an invalid way."]
pub const heif_error_code_heif_error_Usage_error: heif_error_code = 5;
#[doc = " Could not allocate enough memory."]
pub const heif_error_code_heif_error_Memory_allocation_error: heif_error_code = 6;
#[doc = " The decoder plugin generated an error"]
pub const heif_error_code_heif_error_Decoder_plugin_error: heif_error_code = 7;
#[doc = " The encoder plugin generated an error"]
pub const heif_error_code_heif_error_Encoder_plugin_error: heif_error_code = 8;
#[doc = " Error during encoding or when writing to the output"]
pub const heif_error_code_heif_error_Encoding_error: heif_error_code = 9;
#[doc = " Application has asked for a color profile type that does not exist"]
pub const heif_error_code_heif_error_Color_profile_does_not_exist: heif_error_code = 10;
#[doc = " Error loading a dynamic plugin"]
pub const heif_error_code_heif_error_Plugin_loading_error: heif_error_code = 11;
#[doc = " Operation has been canceled"]
pub const heif_error_code_heif_error_Canceled: heif_error_code = 12;
#[doc = " Operation has been canceled"]
pub const heif_error_code_heif_error_End_of_sequence: heif_error_code = 13;
pub type heif_error_code = libc::c_uint;
#[doc = " no further information available"]
pub const heif_suberror_code_heif_suberror_Unspecified: heif_suberror_code = 0;
#[doc = " End of data reached unexpectedly."]
pub const heif_suberror_code_heif_suberror_End_of_data: heif_suberror_code = 100;
#[doc = " Size of box (defined in header) is wrong"]
pub const heif_suberror_code_heif_suberror_Invalid_box_size: heif_suberror_code = 101;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_ftyp_box: heif_suberror_code = 102;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_idat_box: heif_suberror_code = 103;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_meta_box: heif_suberror_code = 104;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_hdlr_box: heif_suberror_code = 105;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_hvcC_box: heif_suberror_code = 106;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_pitm_box: heif_suberror_code = 107;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_ipco_box: heif_suberror_code = 108;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_ipma_box: heif_suberror_code = 109;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_iloc_box: heif_suberror_code = 110;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_iinf_box: heif_suberror_code = 111;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_iprp_box: heif_suberror_code = 112;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_iref_box: heif_suberror_code = 113;
#[doc = " Mandatory 'ftyp' box is missing"]
pub const heif_suberror_code_heif_suberror_No_pict_handler: heif_suberror_code = 114;
#[doc = " An item property referenced in the 'ipma' box is not existing in the 'ipco' container."]
pub const heif_suberror_code_heif_suberror_Ipma_box_references_nonexisting_property:
    heif_suberror_code = 115;
#[doc = " No properties have been assigned to an item."]
pub const heif_suberror_code_heif_suberror_No_properties_assigned_to_item: heif_suberror_code = 116;
#[doc = " Image has no (compressed) data"]
pub const heif_suberror_code_heif_suberror_No_item_data: heif_suberror_code = 117;
#[doc = " Invalid specification of image grid (tiled image)"]
pub const heif_suberror_code_heif_suberror_Invalid_grid_data: heif_suberror_code = 118;
#[doc = " Tile-images in a grid image are missing"]
pub const heif_suberror_code_heif_suberror_Missing_grid_images: heif_suberror_code = 119;
#[doc = " Tile-images in a grid image are missing"]
pub const heif_suberror_code_heif_suberror_Invalid_clean_aperture: heif_suberror_code = 120;
#[doc = " Invalid specification of overlay image"]
pub const heif_suberror_code_heif_suberror_Invalid_overlay_data: heif_suberror_code = 121;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_Overlay_image_outside_of_canvas: heif_suberror_code =
    122;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_Auxiliary_image_type_unspecified: heif_suberror_code =
    123;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_No_or_invalid_primary_item: heif_suberror_code = 124;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_No_infe_box: heif_suberror_code = 125;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_Unknown_color_profile_type: heif_suberror_code = 126;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_Wrong_tile_image_chroma_format: heif_suberror_code = 127;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_Invalid_fractional_number: heif_suberror_code = 128;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_Invalid_image_size: heif_suberror_code = 129;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_Invalid_pixi_box: heif_suberror_code = 130;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_No_av1C_box: heif_suberror_code = 131;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_Wrong_tile_image_pixel_depth: heif_suberror_code = 132;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_Unknown_NCLX_color_primaries: heif_suberror_code = 133;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_Unknown_NCLX_transfer_characteristics:
    heif_suberror_code = 134;
#[doc = " Overlay image completely outside of visible canvas area"]
pub const heif_suberror_code_heif_suberror_Unknown_NCLX_matrix_coefficients: heif_suberror_code =
    135;
#[doc = " Invalid specification of region item"]
pub const heif_suberror_code_heif_suberror_Invalid_region_data: heif_suberror_code = 136;
#[doc = " Image has no ispe property"]
pub const heif_suberror_code_heif_suberror_No_ispe_property: heif_suberror_code = 137;
#[doc = " Image has no ispe property"]
pub const heif_suberror_code_heif_suberror_Camera_intrinsic_matrix_undefined: heif_suberror_code =
    138;
#[doc = " Image has no ispe property"]
pub const heif_suberror_code_heif_suberror_Camera_extrinsic_matrix_undefined: heif_suberror_code =
    139;
#[doc = " Invalid JPEG 2000 codestream - usually a missing marker"]
pub const heif_suberror_code_heif_suberror_Invalid_J2K_codestream: heif_suberror_code = 140;
#[doc = " Invalid JPEG 2000 codestream - usually a missing marker"]
pub const heif_suberror_code_heif_suberror_No_vvcC_box: heif_suberror_code = 141;
#[doc = " icbr is only needed in some situations, this error is for those cases"]
pub const heif_suberror_code_heif_suberror_No_icbr_box: heif_suberror_code = 142;
#[doc = " icbr is only needed in some situations, this error is for those cases"]
pub const heif_suberror_code_heif_suberror_No_avcC_box: heif_suberror_code = 143;
#[doc = " we got a mini box, but could not read it properly"]
pub const heif_suberror_code_heif_suberror_Invalid_mini_box: heif_suberror_code = 149;
#[doc = " Decompressing generic compression or header compression data failed (e.g. bitstream corruption)"]
pub const heif_suberror_code_heif_suberror_Decompression_invalid_data: heif_suberror_code = 150;
#[doc = " Decompressing generic compression or header compression data failed (e.g. bitstream corruption)"]
pub const heif_suberror_code_heif_suberror_No_moov_box: heif_suberror_code = 151;
#[doc = " A security limit preventing unreasonable memory allocations was exceeded by the input file.\n Please check whether the file is valid. If it is, contact us so that we could increase the\n security limits further."]
pub const heif_suberror_code_heif_suberror_Security_limit_exceeded: heif_suberror_code = 1000;
#[doc = " There was an error from the underlying compression / decompression library.\n One possibility is lack of resources (e.g. memory)."]
pub const heif_suberror_code_heif_suberror_Compression_initialisation_error: heif_suberror_code =
    1001;
#[doc = " also used for Invalid_input"]
pub const heif_suberror_code_heif_suberror_Nonexisting_item_referenced: heif_suberror_code = 2000;
#[doc = " An API argument was given a NULL pointer, which is not allowed for that function."]
pub const heif_suberror_code_heif_suberror_Null_pointer_argument: heif_suberror_code = 2001;
#[doc = " Image channel referenced that does not exist in the image"]
pub const heif_suberror_code_heif_suberror_Nonexisting_image_channel_referenced:
    heif_suberror_code = 2002;
#[doc = " The version of the passed plugin is not supported."]
pub const heif_suberror_code_heif_suberror_Unsupported_plugin_version: heif_suberror_code = 2003;
#[doc = " The version of the passed writer is not supported."]
pub const heif_suberror_code_heif_suberror_Unsupported_writer_version: heif_suberror_code = 2004;
#[doc = " The given (encoder) parameter name does not exist."]
pub const heif_suberror_code_heif_suberror_Unsupported_parameter: heif_suberror_code = 2005;
#[doc = " The value for the given parameter is not in the valid range."]
pub const heif_suberror_code_heif_suberror_Invalid_parameter_value: heif_suberror_code = 2006;
#[doc = " Error in property specification"]
pub const heif_suberror_code_heif_suberror_Invalid_property: heif_suberror_code = 2007;
#[doc = " Image reference cycle found in iref"]
pub const heif_suberror_code_heif_suberror_Item_reference_cycle: heif_suberror_code = 2008;
#[doc = " Image was coded with an unsupported compression method."]
pub const heif_suberror_code_heif_suberror_Unsupported_codec: heif_suberror_code = 3000;
#[doc = " Image is specified in an unknown way, e.g. as tiled grid image (which is supported)"]
pub const heif_suberror_code_heif_suberror_Unsupported_image_type: heif_suberror_code = 3001;
#[doc = " Image is specified in an unknown way, e.g. as tiled grid image (which is supported)"]
pub const heif_suberror_code_heif_suberror_Unsupported_data_version: heif_suberror_code = 3002;
#[doc = " The conversion of the source image to the requested chroma / colorspace is not supported."]
pub const heif_suberror_code_heif_suberror_Unsupported_color_conversion: heif_suberror_code = 3003;
#[doc = " The conversion of the source image to the requested chroma / colorspace is not supported."]
pub const heif_suberror_code_heif_suberror_Unsupported_item_construction_method:
    heif_suberror_code = 3004;
#[doc = " The conversion of the source image to the requested chroma / colorspace is not supported."]
pub const heif_suberror_code_heif_suberror_Unsupported_header_compression_method:
    heif_suberror_code = 3005;
#[doc = " Generically compressed data used an unsupported compression method"]
pub const heif_suberror_code_heif_suberror_Unsupported_generic_compression_method:
    heif_suberror_code = 3006;
#[doc = " Generically compressed data used an unsupported compression method"]
pub const heif_suberror_code_heif_suberror_Unsupported_essential_property: heif_suberror_code =
    3007;
#[doc = " --- Encoder_plugin_error ---"]
pub const heif_suberror_code_heif_suberror_Unsupported_bit_depth: heif_suberror_code = 4000;
#[doc = " --- Encoding_error ---"]
pub const heif_suberror_code_heif_suberror_Cannot_write_output_data: heif_suberror_code = 5000;
#[doc = " --- Encoding_error ---"]
pub const heif_suberror_code_heif_suberror_Encoder_initialization: heif_suberror_code = 5001;
#[doc = " --- Encoding_error ---"]
pub const heif_suberror_code_heif_suberror_Encoder_encoding: heif_suberror_code = 5002;
#[doc = " --- Encoding_error ---"]
pub const heif_suberror_code_heif_suberror_Encoder_cleanup: heif_suberror_code = 5003;
#[doc = " --- Encoding_error ---"]
pub const heif_suberror_code_heif_suberror_Too_many_regions: heif_suberror_code = 5004;
#[doc = " a specific plugin file cannot be loaded"]
pub const heif_suberror_code_heif_suberror_Plugin_loading_error: heif_suberror_code = 6000;
#[doc = " trying to remove a plugin that is not loaded"]
pub const heif_suberror_code_heif_suberror_Plugin_is_not_loaded: heif_suberror_code = 6001;
#[doc = " error while scanning the directory for plugins"]
pub const heif_suberror_code_heif_suberror_Cannot_read_plugin_directory: heif_suberror_code = 6002;
#[doc = " no decoder found for that compression format"]
pub const heif_suberror_code_heif_suberror_No_matching_decoder_installed: heif_suberror_code = 6003;
pub type heif_suberror_code = libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_error {
    #[doc = " main error category"]
    pub code: heif_error_code,
    #[doc = " more detailed error code"]
    pub subcode: heif_suberror_code,
    #[doc = " textual error message (is always defined, you do not have to check for NULL)"]
    pub message: *const libc::c_char,
}
unsafe extern "C" {
    #[doc = " Version string of linked libheif library."]
    pub fn heif_get_version() -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Numeric version of linked libheif library, encoded as 0xHHMMLL00 = hh.mm.ll, where hh, mm, ll is the decimal representation of HH, MM, LL.\n For example: 0x02150300 is version 2.21.3"]
    pub fn heif_get_version_number() -> u32;
}
unsafe extern "C" {
    #[doc = " Numeric part \"HH\" from above. Returned as a decimal number."]
    pub fn heif_get_version_number_major() -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Numeric part \"MM\" from above. Returned as a decimal number."]
    pub fn heif_get_version_number_minor() -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Numeric part \"LL\" from above. Returned as a decimal number."]
    pub fn heif_get_version_number_maintenance() -> libc::c_int;
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_context {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_image_handle {
    _unused: [u8; 0],
}
pub type heif_item_id = u32;
pub type heif_property_id = u32;
unsafe extern "C" {
    #[doc = " Free a string returned by libheif in various API functions.\n You may pass NULL."]
    pub fn heif_string_release(arg1: *const libc::c_char);
}
#[doc = " ========================= library initialization ======================"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_init_params {
    pub version: libc::c_int,
}
unsafe extern "C" {
    #[doc = " Initialise library.\n\n You should call heif_init() when you start using libheif and heif_deinit() when you are finished.\n These calls are reference counted. Each call to heif_init() should be matched by one call to heif_deinit().\n\n For backwards compatibility, it is not really necessary to call heif_init(), but some library memory objects\n will never be freed if you do not call heif_init()/heif_deinit().\n\n heif_init() will load the external modules installed in the default plugin path. Thus, you need it when you\n want to load external plugins from the default path.\n Codec plugins that are compiled into the library directly (selected by the compile-time parameters of libheif)\n will be available even without heif_init().\n\n Make sure that you do not have one part of your program use heif_init()/heif_deinit() and another part that does\n not use it as the latter may try to use an uninitialized library. If in doubt, enclose everything with init/deinit.\n\n You may pass nullptr to get default parameters. Currently, no parameters are supported."]
    pub fn heif_init(arg1: *mut heif_init_params) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Deinitialise and clean up library.\n\n You should call heif_init() when you start using libheif and heif_deinit() when you are finished.\n These calls are reference counted. Each call to heif_init() should be matched by one call to heif_deinit().\n\n Note: heif_deinit() must not be called after exit(), for example in a global C++ object's destructor.\n If you do, global variables in libheif might have already been released when heif_deinit() is running,\n leading to a crash.\n\n \\sa heif_init()"]
    pub fn heif_deinit();
}
pub const heif_plugin_type_heif_plugin_type_encoder: heif_plugin_type = 0;
pub const heif_plugin_type_heif_plugin_type_decoder: heif_plugin_type = 1;
#[doc = " --- Plugins are currently only supported on Unix platforms."]
pub type heif_plugin_type = libc::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct heif_plugin_info {
    #[doc = " version of this info struct"]
    pub version: libc::c_int,
    pub type_: heif_plugin_type,
    pub plugin: *const libc::c_void,
    #[doc = " for internal use only"]
    pub internal_handle: *mut libc::c_void,
}
unsafe extern "C" {
    pub fn heif_load_plugin(
        filename: *const libc::c_char,
        out_plugin: *mut *const heif_plugin_info,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_load_plugins(
        directory: *const libc::c_char,
        out_plugins: *mut *const heif_plugin_info,
        out_nPluginsLoaded: *mut libc::c_int,
        output_array_size: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_unload_plugin(plugin: *const heif_plugin_info) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get a NULL terminated array of the plugin directories that are searched by libheif.\n This includes the paths specified in the environment variable LIBHEIF_PLUGIN_PATHS and the built-in path\n (if not overridden by the environment variable)."]
    pub fn heif_get_plugin_directories() -> *const *const libc::c_char;
}
unsafe extern "C" {
    pub fn heif_free_plugin_directories(arg1: *const *const libc::c_char);
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_decoder_plugin {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_encoder_plugin {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn heif_register_decoder_plugin(arg1: *const heif_decoder_plugin) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_register_encoder_plugin(arg1: *const heif_encoder_plugin) -> heif_error;
}
unsafe extern "C" {
    #[doc = " DEPRECATED. Use heif_register_decoder_plugin(const struct heif_decoder_plugin*) instead."]
    pub fn heif_register_decoder(
        heif: *mut heif_context,
        arg1: *const heif_decoder_plugin,
    ) -> heif_error;
}
pub const heif_chroma_heif_chroma_undefined: heif_chroma = 99;
pub const heif_chroma_heif_chroma_monochrome: heif_chroma = 0;
pub const heif_chroma_heif_chroma_420: heif_chroma = 1;
pub const heif_chroma_heif_chroma_422: heif_chroma = 2;
pub const heif_chroma_heif_chroma_444: heif_chroma = 3;
pub const heif_chroma_heif_chroma_interleaved_RGB: heif_chroma = 10;
pub const heif_chroma_heif_chroma_interleaved_RGBA: heif_chroma = 11;
#[doc = " HDR, big endian."]
pub const heif_chroma_heif_chroma_interleaved_RRGGBB_BE: heif_chroma = 12;
#[doc = " HDR, big endian."]
pub const heif_chroma_heif_chroma_interleaved_RRGGBBAA_BE: heif_chroma = 13;
#[doc = " HDR, little endian."]
pub const heif_chroma_heif_chroma_interleaved_RRGGBB_LE: heif_chroma = 14;
#[doc = " HDR, little endian."]
pub const heif_chroma_heif_chroma_interleaved_RRGGBBAA_LE: heif_chroma = 15;
pub type heif_chroma = libc::c_uint;
pub const heif_colorspace_heif_colorspace_undefined: heif_colorspace = 99;
#[doc = " heif_colorspace_YCbCr should be used with one of these heif_chroma values:\n * heif_chroma_444\n * heif_chroma_422\n * heif_chroma_420"]
pub const heif_colorspace_heif_colorspace_YCbCr: heif_colorspace = 0;
#[doc = " heif_colorspace_RGB should be used with one of these heif_chroma values:\n * heif_chroma_444 (for planar RGB)\n * heif_chroma_interleaved_RGB\n * heif_chroma_interleaved_RGBA\n * heif_chroma_interleaved_RRGGBB_BE\n * heif_chroma_interleaved_RRGGBBAA_BE\n * heif_chroma_interleaved_RRGGBB_LE\n * heif_chroma_interleaved_RRGGBBAA_LE"]
pub const heif_colorspace_heif_colorspace_RGB: heif_colorspace = 1;
#[doc = " heif_colorspace_monochrome should only be used with heif_chroma = heif_chroma_monochrome"]
pub const heif_colorspace_heif_colorspace_monochrome: heif_colorspace = 2;
#[doc = " Indicates that this image has no visual channels."]
pub const heif_colorspace_heif_colorspace_nonvisual: heif_colorspace = 3;
pub type heif_colorspace = libc::c_uint;
pub const heif_channel_heif_channel_Y: heif_channel = 0;
pub const heif_channel_heif_channel_Cb: heif_channel = 1;
pub const heif_channel_heif_channel_Cr: heif_channel = 2;
pub const heif_channel_heif_channel_R: heif_channel = 3;
pub const heif_channel_heif_channel_G: heif_channel = 4;
pub const heif_channel_heif_channel_B: heif_channel = 5;
pub const heif_channel_heif_channel_Alpha: heif_channel = 6;
pub const heif_channel_heif_channel_interleaved: heif_channel = 10;
pub const heif_channel_heif_channel_filter_array: heif_channel = 11;
pub const heif_channel_heif_channel_depth: heif_channel = 12;
pub const heif_channel_heif_channel_disparity: heif_channel = 13;
pub type heif_channel = libc::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct heif_image {
    _unused: [u8; 0],
}
unsafe extern "C" {
    #[doc = " Get the colorspace format of the image."]
    pub fn heif_image_get_colorspace(arg1: *const heif_image) -> heif_colorspace;
}
unsafe extern "C" {
    #[doc = " Get the chroma format of the image."]
    pub fn heif_image_get_chroma_format(arg1: *const heif_image) -> heif_chroma;
}
unsafe extern "C" {
    #[doc = " Get the width of a specified image channel.\n\n @param img the image to get the width for\n @param channel the channel to select\n @return the width of the channel in pixels, or -1 the channel does not exist in the image"]
    pub fn heif_image_get_width(img: *const heif_image, channel: heif_channel) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the height of a specified image channel.\n\n @param img the image to get the height for\n @param channel the channel to select\n @return the height of the channel in pixels, or -1 the channel does not exist in the image"]
    pub fn heif_image_get_height(img: *const heif_image, channel: heif_channel) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the width of the main channel.\n\n This is the Y channel in YCbCr or mono, or any in RGB.\n\n @param img the image to get the primary width for\n @return the width in pixels"]
    pub fn heif_image_get_primary_width(img: *const heif_image) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the height of the main channel.\n\n This is the Y channel in YCbCr or mono, or any in RGB.\n\n @param img the image to get the primary height for\n @return the height in pixels"]
    pub fn heif_image_get_primary_height(img: *const heif_image) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_crop(
        img: *mut heif_image,
        left: libc::c_int,
        right: libc::c_int,
        top: libc::c_int,
        bottom: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_image_extract_area(
        arg1: *const heif_image,
        x0: u32,
        y0: u32,
        w: u32,
        h: u32,
        limits: *const heif_security_limits,
        out_image: *mut *mut heif_image,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the number of bits per pixel in the given image channel. Returns -1 if\n a non-existing channel was given.\n Note that the number of bits per pixel may be different for each color channel.\n This function returns the number of bits used for storage of each pixel.\n Especially for HDR images, this is probably not what you want. Have a look at\n heif_image_get_bits_per_pixel_range() instead."]
    pub fn heif_image_get_bits_per_pixel(
        arg1: *const heif_image,
        channel: heif_channel,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the number of bits per pixel in the given image channel. This function returns\n the number of bits used for representing the pixel value, which might be smaller\n than the number of bits used in memory.\n For example, in 12bit HDR images, this function returns '12', while still 16 bits\n are reserved for storage. For interleaved RGBA with 12 bit, this function also returns\n '12', not '48' or '64' (heif_image_get_bits_per_pixel returns 64 in this case)."]
    pub fn heif_image_get_bits_per_pixel_range(
        arg1: *const heif_image,
        channel: heif_channel,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_has_channel(arg1: *const heif_image, channel: heif_channel) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get a pointer to the actual pixel data.\n The 'out_stride' is returned as \"bytes per line\".\n When out_stride is NULL, no value will be written.\n Returns NULL if a non-existing channel was given.\n Deprecated, use the safer version heif_image_get_plane_readonly2() instead."]
    pub fn heif_image_get_plane_readonly(
        arg1: *const heif_image,
        channel: heif_channel,
        out_stride: *mut libc::c_int,
    ) -> *const u8;
}
unsafe extern "C" {
    #[doc = " Deprecated, use the safer version heif_image_get_plane2() instead."]
    pub fn heif_image_get_plane(
        arg1: *mut heif_image,
        channel: heif_channel,
        out_stride: *mut libc::c_int,
    ) -> *mut u8;
}
unsafe extern "C" {
    #[doc = " These are safer variants of the two functions above.\n The 'stride' parameter is often multiplied by the image height in the client application.\n For very large images, this can lead to integer overflows and, consequently, illegal memory accesses.\n The changed 'stride' parameter types eliminates this common error."]
    pub fn heif_image_get_plane_readonly2(
        arg1: *const heif_image,
        channel: heif_channel,
        out_stride: *mut usize,
    ) -> *const u8;
}
unsafe extern "C" {
    pub fn heif_image_get_plane2(
        arg1: *mut heif_image,
        channel: heif_channel,
        out_stride: *mut usize,
    ) -> *mut u8;
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_scaling_options {
    _unused: [u8; 0],
}
unsafe extern "C" {
    #[doc = " Currently, heif_scaling_options is not defined yet. Pass a NULL pointer."]
    pub fn heif_image_scale_image(
        input: *const heif_image,
        output: *mut *mut heif_image,
        width: libc::c_int,
        height: libc::c_int,
        options: *const heif_scaling_options,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Extends the image size to match the given size by extending the right and bottom borders.\n The border areas are filled with zero."]
    pub fn heif_image_extend_to_size_fill_with_zero(
        image: *mut heif_image,
        width: u32,
        height: u32,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Fills the image decoding warnings into the provided 'out_warnings' array.\n The size of the array has to be provided in max_output_buffer_entries.\n If max_output_buffer_entries==0, the number of decoder warnings is returned.\n The function fills the warnings into the provided buffer, starting with 'first_warning_idx'.\n It returns the number of warnings filled into the buffer.\n Note: you can iterate through all warnings by using 'max_output_buffer_entries=1' and iterate 'first_warning_idx'."]
    pub fn heif_image_get_decoding_warnings(
        image: *mut heif_image,
        first_warning_idx: libc::c_int,
        out_warnings: *mut heif_error,
        max_output_buffer_entries: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " This function is only for decoder plugin implementors."]
    pub fn heif_image_add_decoding_warning(image: *mut heif_image, err: heif_error);
}
unsafe extern "C" {
    #[doc = " Release heif_image."]
    pub fn heif_image_release(arg1: *const heif_image);
}
unsafe extern "C" {
    pub fn heif_image_get_pixel_aspect_ratio(
        arg1: *const heif_image,
        aspect_h: *mut u32,
        aspect_v: *mut u32,
    );
}
unsafe extern "C" {
    pub fn heif_image_set_pixel_aspect_ratio(arg1: *mut heif_image, aspect_h: u32, aspect_v: u32);
}
unsafe extern "C" {
    #[doc = " Create a new image of the specified resolution and colorspace.\n\n <p>This does not allocate memory for the image data. Use {@link heif_image_add_plane} to\n add the corresponding planes to match the specified {@code colorspace} and {@code chroma}.\n\n @param width the width of the image in pixels\n @param height the height of the image in pixels\n @param colorspace the colorspace of the image\n @param chroma the chroma of the image\n @param out_image pointer to pointer of the resulting image\n @return whether the creation succeeded or there was an error"]
    pub fn heif_image_create(
        width: libc::c_int,
        height: libc::c_int,
        colorspace: heif_colorspace,
        chroma: heif_chroma,
        out_image: *mut *mut heif_image,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add an image plane to the image.\n\n <p>The image plane needs to match the colorspace and chroma of the image. Note\n that this does not need to be a single \"planar\" format - interleaved pixel channels\n can also be used if the chroma is interleaved.\n\n <p>The indicated bit_depth corresponds to the bit depth per channel. For example,\n with an interleaved format like RRGGBB where each color is represented by 10 bits,\n the {@code bit_depth} would be {@code 10} rather than {@code 30}.\n\n <p>For backward compatibility, one can also specify 24bits for RGB and 32bits for RGBA,\n instead of the preferred 8 bits. However, this use is deprecated.\n\n @param image the parent image to add the channel plane to\n @param channel the channel of the plane to add\n @param width the width of the plane\n @param height the height of the plane\n @param bit_depth the bit depth per color channel\n @return whether the addition succeeded or there was an error\n\n @note The width and height are usually the same as the parent image, but can be\n less for subsampling.\n\n @note The specified width can differ from the row stride of the resulting image plane.\n Always use the result of {@link heif_image_get_plane} or {@link heif_image_get_plane_readonly}\n to determine row stride."]
    pub fn heif_image_add_plane(
        image: *mut heif_image,
        channel: heif_channel,
        width: libc::c_int,
        height: libc::c_int,
        bit_depth: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " The security limits should preferably be the limits from a heif_context.\n The memory allocated will then be registered in the memory budget of that context."]
    pub fn heif_image_add_plane_safe(
        image: *mut heif_image,
        channel: heif_channel,
        width: libc::c_int,
        height: libc::c_int,
        bit_depth: libc::c_int,
        limits: *const heif_security_limits,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Signal that the image is premultiplied by the alpha pixel values."]
    pub fn heif_image_set_premultiplied_alpha(
        image: *mut heif_image,
        is_premultiplied_alpha: libc::c_int,
    );
}
unsafe extern "C" {
    pub fn heif_image_is_premultiplied_alpha(image: *mut heif_image) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " This function extends the padding of the image so that it has at least the given physical size.\n The padding border is filled with the pixels along the right/bottom border.\n This function may be useful if you want to process the image, but have some external padding requirements.\n The image size will not be modified if it is already larger/equal than the given physical size.\n I.e. you cannot assume that after calling this function, the stride will be equal to min_physical_width."]
    pub fn heif_image_extend_padding_to_size(
        image: *mut heif_image,
        min_physical_width: libc::c_int,
        min_physical_height: libc::c_int,
    ) -> heif_error;
}
pub const heif_chroma_downsampling_algorithm_heif_chroma_downsampling_nearest_neighbor:
    heif_chroma_downsampling_algorithm = 1;
pub const heif_chroma_downsampling_algorithm_heif_chroma_downsampling_average:
    heif_chroma_downsampling_algorithm = 2;
#[doc = " Combine with 'heif_chroma_upsampling_bilinear' for best quality.\n Makes edges look sharper when using YUV 420 with bilinear chroma upsampling."]
pub const heif_chroma_downsampling_algorithm_heif_chroma_downsampling_sharp_yuv:
    heif_chroma_downsampling_algorithm = 3;
pub type heif_chroma_downsampling_algorithm = libc::c_uint;
pub const heif_chroma_upsampling_algorithm_heif_chroma_upsampling_nearest_neighbor:
    heif_chroma_upsampling_algorithm = 1;
pub const heif_chroma_upsampling_algorithm_heif_chroma_upsampling_bilinear:
    heif_chroma_upsampling_algorithm = 2;
pub type heif_chroma_upsampling_algorithm = libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_color_conversion_options {
    #[doc = " 'version' must be 1."]
    pub version: u8,
    #[doc = " --- version 1 options"]
    pub preferred_chroma_downsampling_algorithm: heif_chroma_downsampling_algorithm,
    pub preferred_chroma_upsampling_algorithm: heif_chroma_upsampling_algorithm,
    #[doc = " When set to 'false' libheif may also use a different algorithm if the preferred one is not available\n or using a different algorithm is computationally less complex. Note that currently (v1.17.0) this\n means that for RGB input it will usually choose nearest-neighbor sampling because this is computationally\n the simplest.\n Set this field to 'true' if you want to make sure that the specified algorithm is used even\n at the cost of slightly higher computation times."]
    pub only_use_preferred_chroma_algorithm: u8,
}
pub const heif_alpha_composition_mode_heif_alpha_composition_mode_none:
    heif_alpha_composition_mode = 0;
pub const heif_alpha_composition_mode_heif_alpha_composition_mode_solid_color:
    heif_alpha_composition_mode = 1;
pub const heif_alpha_composition_mode_heif_alpha_composition_mode_checkerboard:
    heif_alpha_composition_mode = 2;
pub type heif_alpha_composition_mode = libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_color_conversion_options_ext {
    pub version: u8,
    #[doc = " --- version 1 options"]
    pub alpha_composition_mode: heif_alpha_composition_mode,
    #[doc = " color values should be specified in the range [0, 65535]"]
    pub background_red: u16,
    #[doc = " color values should be specified in the range [0, 65535]"]
    pub background_green: u16,
    #[doc = " color values should be specified in the range [0, 65535]"]
    pub background_blue: u16,
    pub secondary_background_red: u16,
    pub secondary_background_green: u16,
    pub secondary_background_blue: u16,
    pub checkerboard_square_size: u16,
}
unsafe extern "C" {
    #[doc = " Assumes that it is a version=1 struct."]
    pub fn heif_color_conversion_options_set_defaults(arg1: *mut heif_color_conversion_options);
}
unsafe extern "C" {
    pub fn heif_color_conversion_options_ext_alloc() -> *mut heif_color_conversion_options_ext;
}
unsafe extern "C" {
    pub fn heif_color_conversion_options_ext_copy(
        dst: *mut heif_color_conversion_options_ext,
        src: *const heif_color_conversion_options_ext,
    );
}
unsafe extern "C" {
    pub fn heif_color_conversion_options_ext_free(arg1: *mut heif_color_conversion_options_ext);
}
pub const heif_color_profile_type_heif_color_profile_type_not_present: heif_color_profile_type = 0;
pub const heif_color_profile_type_heif_color_profile_type_nclx: heif_color_profile_type =
    1852009592;
pub const heif_color_profile_type_heif_color_profile_type_rICC: heif_color_profile_type =
    1917403971;
pub const heif_color_profile_type_heif_color_profile_type_prof: heif_color_profile_type =
    1886547814;
#[doc = " ------------------------- color profiles -------------------------"]
pub type heif_color_profile_type = libc::c_uint;
unsafe extern "C" {
    #[doc = " Returns 'heif_color_profile_type_not_present' if there is no color profile.\n If there is an ICC profile and an NCLX profile, the ICC profile is returned.\n TODO: we need a new API for this function as images can contain both NCLX and ICC at the same time.\n       However, you can still use heif_image_handle_get_raw_color_profile() and\n       heif_image_handle_get_nclx_color_profile() to access both profiles."]
    pub fn heif_image_handle_get_color_profile_type(
        handle: *const heif_image_handle,
    ) -> heif_color_profile_type;
}
unsafe extern "C" {
    pub fn heif_image_handle_get_raw_color_profile_size(handle: *const heif_image_handle) -> usize;
}
unsafe extern "C" {
    #[doc = " Returns 'heif_error_Color_profile_does_not_exist' when there is no ICC profile."]
    pub fn heif_image_handle_get_raw_color_profile(
        handle: *const heif_image_handle,
        out_data: *mut libc::c_void,
    ) -> heif_error;
}
#[doc = " g=0.3;0.6, b=0.15;0.06, r=0.64;0.33, w=0.3127,0.3290"]
pub const heif_color_primaries_heif_color_primaries_ITU_R_BT_709_5: heif_color_primaries = 1;
pub const heif_color_primaries_heif_color_primaries_unspecified: heif_color_primaries = 2;
pub const heif_color_primaries_heif_color_primaries_ITU_R_BT_470_6_System_M: heif_color_primaries =
    4;
pub const heif_color_primaries_heif_color_primaries_ITU_R_BT_470_6_System_B_G:
    heif_color_primaries = 5;
pub const heif_color_primaries_heif_color_primaries_ITU_R_BT_601_6: heif_color_primaries = 6;
pub const heif_color_primaries_heif_color_primaries_SMPTE_240M: heif_color_primaries = 7;
pub const heif_color_primaries_heif_color_primaries_generic_film: heif_color_primaries = 8;
pub const heif_color_primaries_heif_color_primaries_ITU_R_BT_2020_2_and_2100_0:
    heif_color_primaries = 9;
pub const heif_color_primaries_heif_color_primaries_SMPTE_ST_428_1: heif_color_primaries = 10;
pub const heif_color_primaries_heif_color_primaries_SMPTE_RP_431_2: heif_color_primaries = 11;
pub const heif_color_primaries_heif_color_primaries_SMPTE_EG_432_1: heif_color_primaries = 12;
pub const heif_color_primaries_heif_color_primaries_EBU_Tech_3213_E: heif_color_primaries = 22;
pub type heif_color_primaries = libc::c_uint;
pub const heif_transfer_characteristics_heif_transfer_characteristic_ITU_R_BT_709_5:
    heif_transfer_characteristics = 1;
pub const heif_transfer_characteristics_heif_transfer_characteristic_unspecified:
    heif_transfer_characteristics = 2;
pub const heif_transfer_characteristics_heif_transfer_characteristic_ITU_R_BT_470_6_System_M:
    heif_transfer_characteristics = 4;
pub const heif_transfer_characteristics_heif_transfer_characteristic_ITU_R_BT_470_6_System_B_G:
    heif_transfer_characteristics = 5;
pub const heif_transfer_characteristics_heif_transfer_characteristic_ITU_R_BT_601_6:
    heif_transfer_characteristics = 6;
pub const heif_transfer_characteristics_heif_transfer_characteristic_SMPTE_240M:
    heif_transfer_characteristics = 7;
pub const heif_transfer_characteristics_heif_transfer_characteristic_linear:
    heif_transfer_characteristics = 8;
pub const heif_transfer_characteristics_heif_transfer_characteristic_logarithmic_100:
    heif_transfer_characteristics = 9;
pub const heif_transfer_characteristics_heif_transfer_characteristic_logarithmic_100_sqrt10:
    heif_transfer_characteristics = 10;
pub const heif_transfer_characteristics_heif_transfer_characteristic_IEC_61966_2_4:
    heif_transfer_characteristics = 11;
pub const heif_transfer_characteristics_heif_transfer_characteristic_ITU_R_BT_1361:
    heif_transfer_characteristics = 12;
pub const heif_transfer_characteristics_heif_transfer_characteristic_IEC_61966_2_1:
    heif_transfer_characteristics = 13;
pub const heif_transfer_characteristics_heif_transfer_characteristic_ITU_R_BT_2020_2_10bit:
    heif_transfer_characteristics = 14;
pub const heif_transfer_characteristics_heif_transfer_characteristic_ITU_R_BT_2020_2_12bit:
    heif_transfer_characteristics = 15;
pub const heif_transfer_characteristics_heif_transfer_characteristic_ITU_R_BT_2100_0_PQ:
    heif_transfer_characteristics = 16;
pub const heif_transfer_characteristics_heif_transfer_characteristic_SMPTE_ST_428_1:
    heif_transfer_characteristics = 17;
pub const heif_transfer_characteristics_heif_transfer_characteristic_ITU_R_BT_2100_0_HLG:
    heif_transfer_characteristics = 18;
pub type heif_transfer_characteristics = libc::c_uint;
pub const heif_matrix_coefficients_heif_matrix_coefficients_RGB_GBR: heif_matrix_coefficients = 0;
#[doc = " TODO: or 709-6 according to h.273"]
pub const heif_matrix_coefficients_heif_matrix_coefficients_ITU_R_BT_709_5:
    heif_matrix_coefficients = 1;
pub const heif_matrix_coefficients_heif_matrix_coefficients_unspecified: heif_matrix_coefficients =
    2;
pub const heif_matrix_coefficients_heif_matrix_coefficients_US_FCC_T47: heif_matrix_coefficients =
    4;
pub const heif_matrix_coefficients_heif_matrix_coefficients_ITU_R_BT_470_6_System_B_G:
    heif_matrix_coefficients = 5;
#[doc = " TODO: or 601-7 according to h.273"]
pub const heif_matrix_coefficients_heif_matrix_coefficients_ITU_R_BT_601_6:
    heif_matrix_coefficients = 6;
pub const heif_matrix_coefficients_heif_matrix_coefficients_SMPTE_240M: heif_matrix_coefficients =
    7;
pub const heif_matrix_coefficients_heif_matrix_coefficients_YCgCo: heif_matrix_coefficients = 8;
pub const heif_matrix_coefficients_heif_matrix_coefficients_ITU_R_BT_2020_2_non_constant_luminance : heif_matrix_coefficients = 9 ;
pub const heif_matrix_coefficients_heif_matrix_coefficients_ITU_R_BT_2020_2_constant_luminance:
    heif_matrix_coefficients = 10;
pub const heif_matrix_coefficients_heif_matrix_coefficients_SMPTE_ST_2085:
    heif_matrix_coefficients = 11;
pub const heif_matrix_coefficients_heif_matrix_coefficients_chromaticity_derived_non_constant_luminance : heif_matrix_coefficients = 12 ;
pub const heif_matrix_coefficients_heif_matrix_coefficients_chromaticity_derived_constant_luminance : heif_matrix_coefficients = 13 ;
pub const heif_matrix_coefficients_heif_matrix_coefficients_ICtCp: heif_matrix_coefficients = 14;
pub type heif_matrix_coefficients = libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_color_profile_nclx {
    #[doc = " === version 1 fields"]
    pub version: u8,
    pub color_primaries: heif_color_primaries,
    pub transfer_characteristics: heif_transfer_characteristics,
    pub matrix_coefficients: heif_matrix_coefficients,
    pub full_range_flag: u8,
    #[doc = " --- decoded values (not used when saving nclx)"]
    pub color_primary_red_x: f32,
    #[doc = " --- decoded values (not used when saving nclx)"]
    pub color_primary_red_y: f32,
    pub color_primary_green_x: f32,
    pub color_primary_green_y: f32,
    pub color_primary_blue_x: f32,
    pub color_primary_blue_y: f32,
    pub color_primary_white_x: f32,
    pub color_primary_white_y: f32,
}
unsafe extern "C" {
    pub fn heif_nclx_color_profile_set_color_primaries(
        nclx: *mut heif_color_profile_nclx,
        cp: u16,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_nclx_color_profile_set_transfer_characteristics(
        nclx: *mut heif_color_profile_nclx,
        transfer_characteristics: u16,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_nclx_color_profile_set_matrix_coefficients(
        nclx: *mut heif_color_profile_nclx,
        matrix_coefficients: u16,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Returns 'heif_error_Color_profile_does_not_exist' when there is no NCLX profile.\n TODO: This function does currently not return an NCLX profile if it is stored in the image bitstream.\n       Only NCLX profiles stored as colr boxes are returned. This may change in the future."]
    pub fn heif_image_handle_get_nclx_color_profile(
        handle: *const heif_image_handle,
        out_data: *mut *mut heif_color_profile_nclx,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Returned color profile has 'version' field set to the maximum allowed.\n Do not fill values for higher versions as these might be outside the allocated structure size.\n May return NULL."]
    pub fn heif_nclx_color_profile_alloc() -> *mut heif_color_profile_nclx;
}
unsafe extern "C" {
    pub fn heif_nclx_color_profile_free(nclx_profile: *mut heif_color_profile_nclx);
}
unsafe extern "C" {
    #[doc = " Note: in early versions of HEIF, there could only be one color profile per image. However, this has been changed.\n This function will now return ICC if one is present and NCLX only if there is no ICC.\n You may better avoid this function and simply query for NCLX and ICC directly."]
    pub fn heif_image_get_color_profile_type(image: *const heif_image) -> heif_color_profile_type;
}
unsafe extern "C" {
    #[doc = " Returns the size of the ICC profile if one is assigned to the image. Otherwise, it returns 0."]
    pub fn heif_image_get_raw_color_profile_size(image: *const heif_image) -> usize;
}
unsafe extern "C" {
    #[doc = " Returns the ICC profile if one is assigned to the image. Otherwise, it returns an error."]
    pub fn heif_image_get_raw_color_profile(
        image: *const heif_image,
        out_data: *mut libc::c_void,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_image_get_nclx_color_profile(
        image: *const heif_image,
        out_data: *mut *mut heif_color_profile_nclx,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " The color profile is not attached to the image handle because we might need it\n for color space transform and encoding."]
    pub fn heif_image_set_raw_color_profile(
        image: *mut heif_image,
        profile_type_fourcc_string: *const libc::c_char,
        profile_data: *const libc::c_void,
        profile_size: usize,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_image_set_nclx_color_profile(
        image: *mut heif_image,
        color_profile: *const heif_color_profile_nclx,
    ) -> heif_error;
}
#[doc = " Note: a value of 0 for any of these values indicates that the value is undefined.\n The unit of these values is Candelas per square meter."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_content_light_level {
    pub max_content_light_level: u16,
    pub max_pic_average_light_level: u16,
}
unsafe extern "C" {
    pub fn heif_image_has_content_light_level(arg1: *const heif_image) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_get_content_light_level(
        arg1: *const heif_image,
        out: *mut heif_content_light_level,
    );
}
unsafe extern "C" {
    #[doc = " Returns whether the image has 'content light level' information. If 0 is returned, the output is not filled."]
    pub fn heif_image_handle_get_content_light_level(
        arg1: *const heif_image_handle,
        out: *mut heif_content_light_level,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_set_content_light_level(
        arg1: *const heif_image,
        in_: *const heif_content_light_level,
    );
}
#[doc = " Note: color coordinates are defined according to the CIE 1931 definition of x as specified in ISO 11664-1 (see also ISO 11664-3 and CIE 15)."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_mastering_display_colour_volume {
    pub display_primaries_x: [u16; 3usize],
    pub display_primaries_y: [u16; 3usize],
    pub white_point_x: u16,
    pub white_point_y: u16,
    pub max_display_mastering_luminance: u32,
    pub min_display_mastering_luminance: u32,
}
#[doc = " The units for max_display_mastering_luminance and min_display_mastering_luminance is Candelas per square meter."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_decoded_mastering_display_colour_volume {
    pub display_primaries_x: [f32; 3usize],
    pub display_primaries_y: [f32; 3usize],
    pub white_point_x: f32,
    pub white_point_y: f32,
    pub max_display_mastering_luminance: f64,
    pub min_display_mastering_luminance: f64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_ambient_viewing_environment {
    pub ambient_illumination: u32,
    pub ambient_light_x: u16,
    pub ambient_light_y: u16,
}
unsafe extern "C" {
    pub fn heif_image_has_mastering_display_colour_volume(arg1: *const heif_image) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_get_mastering_display_colour_volume(
        arg1: *const heif_image,
        out: *mut heif_mastering_display_colour_volume,
    );
}
unsafe extern "C" {
    #[doc = " Returns whether the image has 'mastering display colour volume' information. If 0 is returned, the output is not filled."]
    pub fn heif_image_handle_get_mastering_display_colour_volume(
        arg1: *const heif_image_handle,
        out: *mut heif_mastering_display_colour_volume,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_set_mastering_display_colour_volume(
        arg1: *const heif_image,
        in_: *const heif_mastering_display_colour_volume,
    );
}
unsafe extern "C" {
    #[doc = " Converts the internal numeric representation of heif_mastering_display_colour_volume to the\n normalized values, collected in heif_decoded_mastering_display_colour_volume.\n Values that are out-of-range are decoded to 0, indicating an undefined value (as specified in ISO/IEC 23008-2)."]
    pub fn heif_mastering_display_colour_volume_decode(
        in_: *const heif_mastering_display_colour_volume,
        out: *mut heif_decoded_mastering_display_colour_volume,
    ) -> heif_error;
}
pub type heif_brand2 = u32;
unsafe extern "C" {
    #[doc = " input data should be at least 12 bytes"]
    pub fn heif_read_main_brand(data: *const u8, len: libc::c_int) -> heif_brand2;
}
unsafe extern "C" {
    #[doc = " input data should be at least 16 bytes"]
    pub fn heif_read_minor_version_brand(data: *const u8, len: libc::c_int) -> heif_brand2;
}
unsafe extern "C" {
    #[doc = " 'brand_fourcc' must be 4 character long, but need not be 0-terminated"]
    pub fn heif_fourcc_to_brand(brand_fourcc: *const libc::c_char) -> heif_brand2;
}
unsafe extern "C" {
    #[doc = " the output buffer must be at least 4 bytes long"]
    pub fn heif_brand_to_fourcc(brand: heif_brand2, out_fourcc: *mut libc::c_char);
}
unsafe extern "C" {
    #[doc = " 'brand_fourcc' must be 4 character long, but need not be 0-terminated\n returns 1 if file includes the brand, and 0 if it does not\n returns -1 if the provided data is not sufficient\n            (you should input at least as many bytes as indicated in the first 4 bytes of the file, usually ~50 bytes will do)\n returns -2 on other errors"]
    pub fn heif_has_compatible_brand(
        data: *const u8,
        len: libc::c_int,
        brand_fourcc: *const libc::c_char,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Returns an array of compatible brands. The array is allocated by this function and has to be freed with 'heif_free_list_of_compatible_brands()'.\n The number of entries is returned in out_size."]
    pub fn heif_list_compatible_brands(
        data: *const u8,
        len: libc::c_int,
        out_brands: *mut *mut heif_brand2,
        out_size: *mut libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_free_list_of_compatible_brands(brands_list: *mut heif_brand2);
}
unsafe extern "C" {
    #[doc = " Returns one of these MIME types:\n - image/heic           HEIF file using h265 compression\n - image/heif           HEIF file using any other compression\n - image/heic-sequence  HEIF image sequence using h265 compression\n - image/heif-sequence  HEIF image sequence using any other compression\n - image/avif           AVIF image\n - image/avif-sequence  AVIF sequence\n - image/jpeg    JPEG image\n - image/png     PNG image\n If the format could not be detected, an empty string is returned.\n\n Provide at least 12 bytes of input. With less input, its format might not\n be detected. You may also provide more input to increase detection accuracy.\n\n Note that JPEG and PNG images cannot be decoded by libheif even though the\n formats are detected by this function."]
    pub fn heif_get_file_mime_type(data: *const u8, len: libc::c_int) -> *const libc::c_char;
}
pub const heif_filetype_result_heif_filetype_no: heif_filetype_result = 0;
#[doc = " it is heif and can be read by libheif"]
pub const heif_filetype_result_heif_filetype_yes_supported: heif_filetype_result = 1;
#[doc = " it is heif, but cannot be read by libheif"]
pub const heif_filetype_result_heif_filetype_yes_unsupported: heif_filetype_result = 2;
#[doc = " not sure whether it is an heif, try detection with more input data"]
pub const heif_filetype_result_heif_filetype_maybe: heif_filetype_result = 3;
#[doc = " ========================= file type check ======================"]
pub type heif_filetype_result = libc::c_uint;
unsafe extern "C" {
    #[doc = " input data should be at least 12 bytes"]
    pub fn heif_check_filetype(data: *const u8, len: libc::c_int) -> heif_filetype_result;
}
unsafe extern "C" {
    #[doc = " Check the filetype box content for a supported file type.\n\n <p>The data is assumed to start from the start of the `ftyp` box.\n\n <p>This function checks the compatible brands.\n\n @returns heif_error_ok if a supported brand is found, or other error if not."]
    pub fn heif_has_compatible_filetype(data: *const u8, len: libc::c_int) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_check_jpeg_filetype(data: *const u8, len: libc::c_int) -> libc::c_int;
}
pub const heif_brand_heif_unknown_brand: heif_brand = 0;
#[doc = " HEIF image with h265"]
pub const heif_brand_heif_heic: heif_brand = 1;
#[doc = " 10bit images, or anything that uses h265 with range extension"]
pub const heif_brand_heif_heix: heif_brand = 2;
#[doc = " brands for image sequences"]
pub const heif_brand_heif_hevc: heif_brand = 3;
#[doc = " brands for image sequences"]
pub const heif_brand_heif_hevx: heif_brand = 4;
#[doc = " multiview"]
pub const heif_brand_heif_heim: heif_brand = 5;
#[doc = " scalable"]
pub const heif_brand_heif_heis: heif_brand = 6;
#[doc = " multiview sequence"]
pub const heif_brand_heif_hevm: heif_brand = 7;
#[doc = " scalable sequence"]
pub const heif_brand_heif_hevs: heif_brand = 8;
#[doc = " image, any coding algorithm"]
pub const heif_brand_heif_mif1: heif_brand = 9;
#[doc = " sequence, any coding algorithm"]
pub const heif_brand_heif_msf1: heif_brand = 10;
#[doc = " HEIF image with AV1"]
pub const heif_brand_heif_avif: heif_brand = 11;
pub const heif_brand_heif_avis: heif_brand = 12;
#[doc = " VVC image"]
pub const heif_brand_heif_vvic: heif_brand = 13;
#[doc = " VVC sequence"]
pub const heif_brand_heif_vvis: heif_brand = 14;
#[doc = " EVC image"]
pub const heif_brand_heif_evbi: heif_brand = 15;
#[doc = " EVC sequence"]
pub const heif_brand_heif_evbs: heif_brand = 16;
#[doc = " JPEG2000 image"]
pub const heif_brand_heif_j2ki: heif_brand = 17;
#[doc = " JPEG2000 image sequence"]
pub const heif_brand_heif_j2is: heif_brand = 18;
#[doc = " DEPRECATED, use heif_brand2 and the heif_brand2_* constants instead"]
pub type heif_brand = libc::c_uint;
unsafe extern "C" {
    #[doc = " input data should be at least 12 bytes\n DEPRECATED, use heif_read_main_brand() instead"]
    pub fn heif_main_brand(data: *const u8, len: libc::c_int) -> heif_brand;
}
pub const heif_metadata_compression_heif_metadata_compression_off: heif_metadata_compression = 0;
pub const heif_metadata_compression_heif_metadata_compression_auto: heif_metadata_compression = 1;
#[doc = " only used when reading unknown method from input file"]
pub const heif_metadata_compression_heif_metadata_compression_unknown: heif_metadata_compression =
    2;
pub const heif_metadata_compression_heif_metadata_compression_deflate: heif_metadata_compression =
    3;
#[doc = " do not use for header data"]
pub const heif_metadata_compression_heif_metadata_compression_zlib: heif_metadata_compression = 4;
pub const heif_metadata_compression_heif_metadata_compression_brotli: heif_metadata_compression = 5;
pub type heif_metadata_compression = libc::c_uint;
unsafe extern "C" {
    #[doc = " How many metadata blocks are attached to an image. If you only want to get EXIF data,\n set the type_filter to \"Exif\". Otherwise, set the type_filter to NULL."]
    pub fn heif_image_handle_get_number_of_metadata_blocks(
        handle: *const heif_image_handle,
        type_filter: *const libc::c_char,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " 'type_filter' can be used to get only metadata of specific types, like \"Exif\".\n If 'type_filter' is NULL, it will return all types of metadata IDs."]
    pub fn heif_image_handle_get_list_of_metadata_block_IDs(
        handle: *const heif_image_handle,
        type_filter: *const libc::c_char,
        ids: *mut heif_item_id,
        count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Return a string indicating the type of the metadata, as specified in the HEIF file.\n Exif data will have the type string \"Exif\".\n This string will be valid until the next call to a libheif function.\n You do not have to free this string."]
    pub fn heif_image_handle_get_metadata_type(
        handle: *const heif_image_handle,
        metadata_id: heif_item_id,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " For EXIF, the content type is empty.\n For XMP, the content type is \"application/rdf+xml\"."]
    pub fn heif_image_handle_get_metadata_content_type(
        handle: *const heif_image_handle,
        metadata_id: heif_item_id,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Get the size of the raw metadata, as stored in the HEIF file."]
    pub fn heif_image_handle_get_metadata_size(
        handle: *const heif_image_handle,
        metadata_id: heif_item_id,
    ) -> usize;
}
unsafe extern "C" {
    #[doc = " 'out_data' must point to a memory area of the size reported by heif_image_handle_get_metadata_size().\n The data is returned exactly as stored in the HEIF file.\n For Exif data, you probably have to skip the first four bytes of the data, since they\n indicate the offset to the start of the TIFF header of the Exif data."]
    pub fn heif_image_handle_get_metadata(
        handle: *const heif_image_handle,
        metadata_id: heif_item_id,
        out_data: *mut libc::c_void,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Only valid for item type == \"uri \", an absolute URI"]
    pub fn heif_image_handle_get_metadata_item_uri_type(
        handle: *const heif_image_handle,
        metadata_id: heif_item_id,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Add EXIF metadata to an image."]
    pub fn heif_context_add_exif_metadata(
        arg1: *mut heif_context,
        image_handle: *const heif_image_handle,
        data: *const libc::c_void,
        size: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add XMP metadata to an image."]
    pub fn heif_context_add_XMP_metadata(
        arg1: *mut heif_context,
        image_handle: *const heif_image_handle,
        data: *const libc::c_void,
        size: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " New version of heif_context_add_XMP_metadata() with data compression (experimental)."]
    pub fn heif_context_add_XMP_metadata2(
        arg1: *mut heif_context,
        image_handle: *const heif_image_handle,
        data: *const libc::c_void,
        size: libc::c_int,
        compression: heif_metadata_compression,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add generic, proprietary metadata to an image. You have to specify an 'item_type' that will\n identify your metadata. 'content_type' can be an additional type, or it can be NULL.\n For example, this function can be used to add IPTC metadata (IIM stream, not XMP) to an image.\n Although not standard, we propose to store IPTC data with item type=\"iptc\", content_type=NULL."]
    pub fn heif_context_add_generic_metadata(
        ctx: *mut heif_context,
        image_handle: *const heif_image_handle,
        data: *const libc::c_void,
        size: libc::c_int,
        item_type: *const libc::c_char,
        content_type: *const libc::c_char,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add generic metadata with item_type \"uri \". Items with this type do not have a content_type, but\n an item_uri_type and they have no content_encoding (they are always stored uncompressed)."]
    pub fn heif_context_add_generic_uri_metadata(
        ctx: *mut heif_context,
        image_handle: *const heif_image_handle,
        data: *const libc::c_void,
        size: libc::c_int,
        item_uri_type: *const libc::c_char,
        out_item_id: *mut heif_item_id,
    ) -> heif_error;
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_encoder {
    _unused: [u8; 0],
}
unsafe extern "C" {
    #[doc = " ------------------------- depth images -------------------------"]
    pub fn heif_image_handle_has_depth_image(arg1: *const heif_image_handle) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_get_number_of_depth_images(
        handle: *const heif_image_handle,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_get_list_of_depth_image_IDs(
        handle: *const heif_image_handle,
        ids: *mut heif_item_id,
        count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_get_depth_image_handle(
        handle: *const heif_image_handle,
        depth_image_id: heif_item_id,
        out_depth_handle: *mut *mut heif_image_handle,
    ) -> heif_error;
}
pub const heif_depth_representation_type_heif_depth_representation_type_uniform_inverse_Z:
    heif_depth_representation_type = 0;
pub const heif_depth_representation_type_heif_depth_representation_type_uniform_disparity:
    heif_depth_representation_type = 1;
pub const heif_depth_representation_type_heif_depth_representation_type_uniform_Z:
    heif_depth_representation_type = 2;
pub const heif_depth_representation_type_heif_depth_representation_type_nonuniform_disparity:
    heif_depth_representation_type = 3;
pub type heif_depth_representation_type = libc::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct heif_depth_representation_info {
    pub version: u8,
    #[doc = " version 1 fields"]
    pub has_z_near: u8,
    pub has_z_far: u8,
    pub has_d_min: u8,
    pub has_d_max: u8,
    pub z_near: f64,
    pub z_far: f64,
    pub d_min: f64,
    pub d_max: f64,
    pub depth_representation_type: heif_depth_representation_type,
    pub disparity_reference_view: u32,
    pub depth_nonlinear_representation_model_size: u32,
    pub depth_nonlinear_representation_model: *mut u8,
}
unsafe extern "C" {
    pub fn heif_depth_representation_info_free(info: *const heif_depth_representation_info);
}
unsafe extern "C" {
    #[doc = " Returns true when there is depth_representation_info available\n Note 1: depth_image_id is currently unused because we support only one depth channel per image, but\n you should still provide the correct ID for future compatibility.\n Note 2: Because of an API bug before v1.11.0, the function also works when 'handle' is the handle of the depth image.\n However, you should pass the handle of the main image. Please adapt your code if needed."]
    pub fn heif_image_handle_get_depth_image_representation_info(
        handle: *const heif_image_handle,
        depth_image_id: heif_item_id,
        out: *mut *const heif_depth_representation_info,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " List the number of thumbnails assigned to this image handle. Usually 0 or 1."]
    pub fn heif_image_handle_get_number_of_thumbnails(
        handle: *const heif_image_handle,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_get_list_of_thumbnail_IDs(
        handle: *const heif_image_handle,
        ids: *mut heif_item_id,
        count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the image handle of a thumbnail image."]
    pub fn heif_image_handle_get_thumbnail(
        main_image_handle: *const heif_image_handle,
        thumbnail_id: heif_item_id,
        out_thumbnail_handle: *mut *mut heif_image_handle,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Encode the 'image' as a scaled down thumbnail image.\n The image is scaled down to fit into a square area of width 'bbox_size'.\n If the input image is already so small that it fits into this bounding box, no thumbnail\n image is encoded and NULL is returned in 'out_thumb_image_handle'.\n No error is returned in this case.\n The encoded thumbnail is automatically assigned to the 'master_image_handle'. Hence, you\n do not have to call heif_context_assign_thumbnail()."]
    pub fn heif_context_encode_thumbnail(
        arg1: *mut heif_context,
        image: *const heif_image,
        master_image_handle: *const heif_image_handle,
        encoder: *mut heif_encoder,
        options: *const heif_encoding_options,
        bbox_size: libc::c_int,
        out_thumb_image_handle: *mut *mut heif_image_handle,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Assign 'thumbnail_image' as the thumbnail image of 'master_image'."]
    pub fn heif_context_assign_thumbnail(
        arg1: *mut heif_context,
        master_image: *const heif_image_handle,
        thumbnail_image: *const heif_image_handle,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " List the number of auxiliary images assigned to this image handle."]
    pub fn heif_image_handle_get_number_of_auxiliary_images(
        handle: *const heif_image_handle,
        aux_filter: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_get_list_of_auxiliary_image_IDs(
        handle: *const heif_image_handle,
        aux_filter: libc::c_int,
        ids: *mut heif_item_id,
        count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " You are responsible to deallocate the returned buffer with heif_image_handle_release_auxiliary_type()."]
    pub fn heif_image_handle_get_auxiliary_type(
        handle: *const heif_image_handle,
        out_type: *mut *const libc::c_char,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_image_handle_release_auxiliary_type(
        handle: *const heif_image_handle,
        out_type: *mut *const libc::c_char,
    );
}
unsafe extern "C" {
    #[doc = " Get the image handle of an auxiliary image."]
    pub fn heif_image_handle_get_auxiliary_image_handle(
        main_image_handle: *const heif_image_handle,
        auxiliary_id: heif_item_id,
        out_auxiliary_handle: *mut *mut heif_image_handle,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " DEPRECATED (because typo in function name). Use heif_image_handle_release_auxiliary_type() instead."]
    pub fn heif_image_handle_free_auxiliary_types(
        handle: *const heif_image_handle,
        out_type: *mut *const libc::c_char,
    );
}
#[doc = " ------------------------- entity groups ------------------------"]
pub type heif_entity_group_id = u32;
#[repr(C)]
#[derive(Debug)]
pub struct heif_entity_group {
    pub entity_group_id: heif_entity_group_id,
    #[doc = " this is a FourCC constant"]
    pub entity_group_type: u32,
    pub entities: *mut heif_item_id,
    pub num_entities: u32,
}
unsafe extern "C" {
    #[doc = " Use 0 for `type_filter` or `item_filter` to disable the filter.\n Returns an array of heif_entity_group structs with *out_num_groups entries."]
    pub fn heif_context_get_entity_groups(
        arg1: *const heif_context,
        type_filter: u32,
        item_filter: heif_item_id,
        out_num_groups: *mut libc::c_int,
    ) -> *mut heif_entity_group;
}
unsafe extern "C" {
    #[doc = " Release an array of entity groups returned by heif_context_get_entity_groups()."]
    pub fn heif_entity_groups_release(arg1: *mut heif_entity_group, num_groups: libc::c_int);
}
#[doc = " If you set a limit to 0, the limit is disabled."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_security_limits {
    pub version: u8,
    #[doc = " Limit on the maximum image size to avoid allocating too much memory.\n For example, setting this to 32768^2 pixels = 1 Gigapixels results\n in 1.5 GB memory need for YUV-4:2:0 or 4 GB for RGB32."]
    pub max_image_size_pixels: u64,
    pub max_number_of_tiles: u64,
    pub max_bayer_pattern_pixels: u32,
    pub max_items: u32,
    pub max_color_profile_size: u32,
    pub max_memory_block_size: u64,
    pub max_components: u32,
    pub max_iloc_extents_per_item: u32,
    pub max_size_entity_group: u32,
    #[doc = " for all boxes that are not covered by other limits"]
    pub max_children_per_box: u32,
    #[doc = " --- version 2"]
    pub max_total_memory: u64,
    pub max_sample_description_box_entries: u32,
    pub max_sample_group_description_box_entries: u32,
}
unsafe extern "C" {
    #[doc = " The global security limits are the default for new heif_contexts.\n These global limits cannot be changed, but you can override the limits for a specific heif_context."]
    pub fn heif_get_global_security_limits() -> *const heif_security_limits;
}
unsafe extern "C" {
    #[doc = " Returns a set of fully disabled security limits. Use with care and only after user confirmation."]
    pub fn heif_get_disabled_security_limits() -> *const heif_security_limits;
}
unsafe extern "C" {
    #[doc = " Returns the security limits for a heif_context.\n By default, the limits are set to the global limits, but you can change them in the returned object."]
    pub fn heif_context_get_security_limits(arg1: *const heif_context)
        -> *mut heif_security_limits;
}
unsafe extern "C" {
    #[doc = " Overwrites the security limits of a heif_context.\n This is a convenience function to easily copy limits."]
    pub fn heif_context_set_security_limits(
        arg1: *mut heif_context,
        arg2: *const heif_security_limits,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Set the maximum image size security limit. This function will set the maximum image area (number of pixels)\n to maximum_width ^ 2. Alternatively to using this function, you can also set the maximum image area\n in the security limits structure returned by heif_context_get_security_limits()."]
    pub fn heif_context_set_maximum_image_size_limit(
        ctx: *mut heif_context,
        maximum_width: libc::c_int,
    );
}
#[doc = " Unspecified / undefined compression format.\n\n This is used to mean \"no match\" or \"any decoder\" for some parts of the\n API. It does not indicate a specific compression format."]
pub const heif_compression_format_heif_compression_undefined: heif_compression_format = 0;
#[doc = " HEVC compression, used for HEIC images.\n\n This is equivalent to H.265."]
pub const heif_compression_format_heif_compression_HEVC: heif_compression_format = 1;
#[doc = " AVC compression. (Currently unused in libheif.)\n\n The compression is defined in ISO/IEC 14496-10. This is equivalent to H.264.\n\n The encapsulation is defined in ISO/IEC 23008-12:2022 Annex E."]
pub const heif_compression_format_heif_compression_AVC: heif_compression_format = 2;
#[doc = " JPEG compression.\n\n The compression format is defined in ISO/IEC 10918-1. The encapsulation\n of JPEG is specified in ISO/IEC 23008-12:2022 Annex H."]
pub const heif_compression_format_heif_compression_JPEG: heif_compression_format = 3;
#[doc = " AV1 compression, used for AVIF images.\n\n The compression format is provided at https://aomediacodec.github.io/av1-spec/\n\n The encapsulation is defined in https://aomediacodec.github.io/av1-avif/"]
pub const heif_compression_format_heif_compression_AV1: heif_compression_format = 4;
#[doc = " VVC compression.\n\n The compression format is defined in ISO/IEC 23090-3. This is equivalent to H.266.\n\n The encapsulation is defined in ISO/IEC 23008-12:2022 Annex L."]
pub const heif_compression_format_heif_compression_VVC: heif_compression_format = 5;
#[doc = " EVC compression. (Currently unused in libheif.)\n\n The compression format is defined in ISO/IEC 23094-1.\n\n The encapsulation is defined in ISO/IEC 23008-12:2022 Annex M."]
pub const heif_compression_format_heif_compression_EVC: heif_compression_format = 6;
#[doc = " JPEG 2000 compression.\n\n The encapsulation of JPEG 2000 is specified in ISO/IEC 15444-16:2021.\n The core encoding is defined in ISO/IEC 15444-1, or ITU-T T.800."]
pub const heif_compression_format_heif_compression_JPEG2000: heif_compression_format = 7;
#[doc = " Uncompressed encoding.\n\n This is defined in ISO/IEC 23001-17:2024."]
pub const heif_compression_format_heif_compression_uncompressed: heif_compression_format = 8;
#[doc = " Mask image encoding.\n\n See ISO/IEC 23008-12:2022 Section 6.10.2"]
pub const heif_compression_format_heif_compression_mask: heif_compression_format = 9;
#[doc = " High Throughput JPEG 2000 (HT-J2K) compression.\n\n The encapsulation of HT-J2K is specified in ISO/IEC 15444-16:2021.\n The core encoding is defined in ISO/IEC 15444-15, or ITU-T T.814."]
pub const heif_compression_format_heif_compression_HTJ2K: heif_compression_format = 10;
#[doc = " libheif known compression formats."]
pub type heif_compression_format = libc::c_uint;
unsafe extern "C" {
    #[doc = " Allocate a new context for reading HEIF files.\n Has to be freed again with heif_context_free()."]
    pub fn heif_context_alloc() -> *mut heif_context;
}
unsafe extern "C" {
    #[doc = " Free a previously allocated HEIF context. You should not free a context twice."]
    pub fn heif_context_free(arg1: *mut heif_context);
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_reading_options {
    _unused: [u8; 0],
}
#[doc = " requested size has been reached, we can read until this point"]
pub const heif_reader_grow_status_heif_reader_grow_status_size_reached: heif_reader_grow_status = 0;
#[doc = " size has not been reached yet, but it may still grow further (deprecated)"]
pub const heif_reader_grow_status_heif_reader_grow_status_timeout: heif_reader_grow_status = 1;
#[doc = " size has not been reached and never will. The file has grown to its full size"]
pub const heif_reader_grow_status_heif_reader_grow_status_size_beyond_eof: heif_reader_grow_status =
    2;
#[doc = " an error has occurred"]
pub const heif_reader_grow_status_heif_reader_grow_status_error: heif_reader_grow_status = 3;
pub type heif_reader_grow_status = libc::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct heif_reader_range_request_result {
    #[doc = " should not return 'heif_reader_grow_status_timeout'"]
    pub status: heif_reader_grow_status,
    #[doc = " Indicates up to what position the file has been read.\n If we cannot read the whole file range (status == 'heif_reader_grow_status_size_beyond_eof'), this is the actual end position.\n On the other hand, it may be that the reader was reading more data than requested. In that case, it should indicate the full size here\n and libheif may decide to make use of the additional data (e.g. for filling 'tili' offset tables)."]
    pub range_end: u64,
    #[doc = " a reader specific error code"]
    pub reader_error_code: libc::c_int,
    #[doc = " libheif will call heif_reader.release_error_msg on this if it is not NULL"]
    pub reader_error_msg: *const libc::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_reader {
    #[doc = " API version supported by this reader"]
    pub reader_api_version: libc::c_int,
    #[doc = " --- version 1 functions ---"]
    pub get_position:
        ::std::option::Option<unsafe extern "C" fn(userdata: *mut libc::c_void) -> i64>,
    #[doc = " The functions read(), and seek() return 0 on success.\n Generally, libheif will make sure that we do not read past the file size."]
    pub read: ::std::option::Option<
        unsafe extern "C" fn(
            data: *mut libc::c_void,
            size: usize,
            userdata: *mut libc::c_void,
        ) -> libc::c_int,
    >,
    pub seek: ::std::option::Option<
        unsafe extern "C" fn(position: i64, userdata: *mut libc::c_void) -> libc::c_int,
    >,
    #[doc = " When calling this function, libheif wants to make sure that it can read the file\n up to 'target_size'. This is useful when the file is currently downloaded and may\n grow with time. You may, for example, extract the image sizes even before the actual\n compressed image data has been completely downloaded.\n\n Even if your input files will not grow, you will have to implement at least\n detection whether the target_size is above the (fixed) file length\n (in this case, return 'size_beyond_eof')."]
    pub wait_for_file_size: ::std::option::Option<
        unsafe extern "C" fn(
            target_size: i64,
            userdata: *mut libc::c_void,
        ) -> heif_reader_grow_status,
    >,
    #[doc = " If this function is defined, libheif will often request a file range before accessing it.\n The purpose of this function is that libheif will usually read very small chunks of data with the\n read() callback above. However, it is inefficient to request such a small chunk of data over a network\n and the network delay will significantly increase the decoding time.\n Thus, libheif will call request_range() with a larger block of data that should be preloaded and the\n subsequent read() calls will work within the requested ranges.\n\n Note: `end_pos` is one byte after the last position to be read.\n You should return\n - 'heif_reader_grow_status_size_reached' if the requested range is available, or\n - 'heif_reader_grow_status_size_beyond_eof' if the requested range exceeds the file size\n   (the valid part of the range has been read)."]
    pub request_range: ::std::option::Option<
        unsafe extern "C" fn(
            start_pos: u64,
            end_pos: u64,
            userdata: *mut libc::c_void,
        ) -> heif_reader_range_request_result,
    >,
    #[doc = " libheif might issue hints when it assumes that a file range might be needed in the future.\n This may happen, for example, when your are doing selective tile accesses and libheif proposes\n to preload offset pointer tables.\n Another difference to request_file_range() is that this call should be non-blocking.\n If you preload any data, do this in a background thread."]
    pub preload_range_hint: ::std::option::Option<
        unsafe extern "C" fn(start_pos: u64, end_pos: u64, userdata: *mut libc::c_void),
    >,
    #[doc = " If libheif does not need access to a file range anymore, it may call this function to\n give a hint to the reader that it may release the range from a cache.\n If you do not maintain a file cache that wants to reduce its size dynamically, you do not\n need to implement this function."]
    pub release_file_range: ::std::option::Option<
        unsafe extern "C" fn(start_pos: u64, end_pos: u64, userdata: *mut libc::c_void),
    >,
    #[doc = " Release an error message that was returned by heif_reader in an earlier call.\n If this function is NULL, the error message string will not be released.\n This is a viable option if you are only returning static strings."]
    pub release_error_msg: ::std::option::Option<unsafe extern "C" fn(msg: *const libc::c_char)>,
}
unsafe extern "C" {
    #[doc = " Read a HEIF file from a named disk file.\n The heif_reading_options should currently be set to NULL."]
    pub fn heif_context_read_from_file(
        arg1: *mut heif_context,
        filename: *const libc::c_char,
        arg2: *const heif_reading_options,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Read a HEIF file stored completely in memory.\n The heif_reading_options should currently be set to NULL.\n DEPRECATED: use heif_context_read_from_memory_without_copy() instead."]
    pub fn heif_context_read_from_memory(
        arg1: *mut heif_context,
        mem: *const libc::c_void,
        size: usize,
        arg2: *const heif_reading_options,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Same as heif_context_read_from_memory() except that the provided memory is not copied.\n That means, you will have to keep the memory area alive as long as you use the heif_context."]
    pub fn heif_context_read_from_memory_without_copy(
        arg1: *mut heif_context,
        mem: *const libc::c_void,
        size: usize,
        arg2: *const heif_reading_options,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_context_read_from_reader(
        arg1: *mut heif_context,
        reader: *const heif_reader,
        userdata: *mut libc::c_void,
        arg2: *const heif_reading_options,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Number of top-level images in the HEIF file. This does not include the thumbnails or the\n tile images that are composed to an image grid. You can get access to the thumbnails via\n the main image handle."]
    pub fn heif_context_get_number_of_top_level_images(ctx: *mut heif_context) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_context_is_top_level_image_ID(
        ctx: *mut heif_context,
        id: heif_item_id,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Fills in image IDs into the user-supplied int-array 'ID_array', preallocated with 'count' entries.\n Function returns the total number of IDs filled into the array."]
    pub fn heif_context_get_list_of_top_level_image_IDs(
        ctx: *mut heif_context,
        ID_array: *mut heif_item_id,
        count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_context_get_primary_image_ID(
        ctx: *mut heif_context,
        id: *mut heif_item_id,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get a handle to the primary image of the HEIF file.\n This is the image that should be displayed primarily when there are several images in the file."]
    pub fn heif_context_get_primary_image_handle(
        ctx: *mut heif_context,
        arg1: *mut *mut heif_image_handle,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the image handle for a known image ID."]
    pub fn heif_context_get_image_handle(
        ctx: *mut heif_context,
        id: heif_item_id,
        arg1: *mut *mut heif_image_handle,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Print information about the boxes of a HEIF file to file descriptor.\n This is for debugging and informational purposes only. You should not rely on\n the output having a specific format. At best, you should not use this at all."]
    pub fn heif_context_debug_dump_boxes_to_file(ctx: *mut heif_context, fd: libc::c_int);
}
unsafe extern "C" {
    #[doc = " ====================================================================================================\n   Write the heif_context to a HEIF file"]
    pub fn heif_context_write_to_file(
        arg1: *mut heif_context,
        filename: *const libc::c_char,
    ) -> heif_error;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_writer {
    #[doc = " API version supported by this writer"]
    pub writer_api_version: libc::c_int,
    #[doc = " TODO: why do we need this parameter?"]
    pub write: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut heif_context,
            data: *const libc::c_void,
            size: usize,
            userdata: *mut libc::c_void,
        ) -> heif_error,
    >,
}
unsafe extern "C" {
    pub fn heif_context_write(
        arg1: *mut heif_context,
        writer: *mut heif_writer,
        userdata: *mut libc::c_void,
    ) -> heif_error;
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_encoder_descriptor {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_encoder_parameter {
    _unused: [u8; 0],
}
unsafe extern "C" {
    #[doc = " Quick check whether there is an enoder available for the given format.\n Note that the encoder may be limited to a certain subset of features (e.g. only 8 bit, only lossy).\n You will have to query the specific capabilities further."]
    pub fn heif_have_encoder_for_format(format: heif_compression_format) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get a list of available encoders. You can filter the encoders by compression format and name.\n Use format_filter==heif_compression_undefined and name_filter==NULL as wildcards.\n The returned list of encoders is sorted by their priority (which is a plugin property).\n The number of encoders is returned, which are not more than 'count' if (out_encoders != nullptr).\n By setting out_encoders==nullptr, you can query the number of encoders, 'count' is ignored.\n Note: to get the actual encoder from the descriptors returned here, use heif_context_get_encoder()."]
    pub fn heif_get_encoder_descriptors(
        format_filter: heif_compression_format,
        name_filter: *const libc::c_char,
        out_encoders: *mut *const heif_encoder_descriptor,
        count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Return a long, descriptive name of the encoder (including version information)."]
    pub fn heif_encoder_descriptor_get_name(
        arg1: *const heif_encoder_descriptor,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Return a short, symbolic name for identifying the encoder.\n This name should stay constant over different encoder versions."]
    pub fn heif_encoder_descriptor_get_id_name(
        arg1: *const heif_encoder_descriptor,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    pub fn heif_encoder_descriptor_get_compression_format(
        arg1: *const heif_encoder_descriptor,
    ) -> heif_compression_format;
}
unsafe extern "C" {
    pub fn heif_encoder_descriptor_supports_lossy_compression(
        arg1: *const heif_encoder_descriptor,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_encoder_descriptor_supports_lossless_compression(
        arg1: *const heif_encoder_descriptor,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get an encoder instance that can be used to actually encode images from a descriptor."]
    pub fn heif_context_get_encoder(
        context: *mut heif_context,
        arg1: *const heif_encoder_descriptor,
        out_encoder: *mut *mut heif_encoder,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get an encoder for the given compression format. If there are several encoder plugins\n for this format, the encoder with the highest plugin priority will be returned."]
    pub fn heif_context_get_encoder_for_format(
        context: *mut heif_context,
        format: heif_compression_format,
        arg1: *mut *mut heif_encoder,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " You have to release the encoder after use."]
    pub fn heif_encoder_release(arg1: *mut heif_encoder);
}
unsafe extern "C" {
    #[doc = " Get the encoder name from the encoder itself."]
    pub fn heif_encoder_get_name(arg1: *const heif_encoder) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Set a 'quality' factor (0-100). How this is mapped to actual encoding parameters is\n encoder dependent."]
    pub fn heif_encoder_set_lossy_quality(
        arg1: *mut heif_encoder,
        quality: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_encoder_set_lossless(arg1: *mut heif_encoder, enable: libc::c_int) -> heif_error;
}
unsafe extern "C" {
    #[doc = " level should be between 0 (= none) to 4 (= full)"]
    pub fn heif_encoder_set_logging_level(
        arg1: *mut heif_encoder,
        level: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get a generic list of encoder parameters.\n Each encoder may define its own, additional set of parameters.\n You do not have to free the returned list."]
    pub fn heif_encoder_list_parameters(
        arg1: *mut heif_encoder,
    ) -> *const *const heif_encoder_parameter;
}
unsafe extern "C" {
    #[doc = " Return the parameter name."]
    pub fn heif_encoder_parameter_get_name(
        arg1: *const heif_encoder_parameter,
    ) -> *const libc::c_char;
}
pub const heif_encoder_parameter_type_heif_encoder_parameter_type_integer:
    heif_encoder_parameter_type = 1;
pub const heif_encoder_parameter_type_heif_encoder_parameter_type_boolean:
    heif_encoder_parameter_type = 2;
pub const heif_encoder_parameter_type_heif_encoder_parameter_type_string:
    heif_encoder_parameter_type = 3;
pub type heif_encoder_parameter_type = libc::c_uint;
unsafe extern "C" {
    #[doc = " Return the parameter type."]
    pub fn heif_encoder_parameter_get_type(
        arg1: *const heif_encoder_parameter,
    ) -> heif_encoder_parameter_type;
}
unsafe extern "C" {
    #[doc = " DEPRECATED. Use heif_encoder_parameter_get_valid_integer_values() instead."]
    pub fn heif_encoder_parameter_get_valid_integer_range(
        arg1: *const heif_encoder_parameter,
        have_minimum_maximum: *mut libc::c_int,
        minimum: *mut libc::c_int,
        maximum: *mut libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " If integer is limited by a range, have_minimum and/or have_maximum will be != 0 and *minimum, *maximum is set.\n If integer is limited by a fixed set of values, *num_valid_values will be >0 and *out_integer_array is set."]
    pub fn heif_encoder_parameter_get_valid_integer_values(
        arg1: *const heif_encoder_parameter,
        have_minimum: *mut libc::c_int,
        have_maximum: *mut libc::c_int,
        minimum: *mut libc::c_int,
        maximum: *mut libc::c_int,
        num_valid_values: *mut libc::c_int,
        out_integer_array: *mut *const libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_encoder_parameter_get_valid_string_values(
        arg1: *const heif_encoder_parameter,
        out_stringarray: *mut *const *const libc::c_char,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_encoder_set_parameter_integer(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
        value: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_encoder_get_parameter_integer(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
        value: *mut libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_encoder_parameter_integer_valid_range(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
        have_minimum_maximum: *mut libc::c_int,
        minimum: *mut libc::c_int,
        maximum: *mut libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_encoder_set_parameter_boolean(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
        value: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_encoder_get_parameter_boolean(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
        value: *mut libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_encoder_set_parameter_string(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
        value: *const libc::c_char,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_encoder_get_parameter_string(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
        value: *mut libc::c_char,
        value_size: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " returns a NULL-terminated list of valid strings or NULL if all values are allowed"]
    pub fn heif_encoder_parameter_string_valid_values(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
        out_stringarray: *mut *const *const libc::c_char,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_encoder_parameter_integer_valid_values(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
        have_minimum: *mut libc::c_int,
        have_maximum: *mut libc::c_int,
        minimum: *mut libc::c_int,
        maximum: *mut libc::c_int,
        num_valid_values: *mut libc::c_int,
        out_integer_array: *mut *const libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Set a parameter of any type to the string value.\n Integer values are parsed from the string.\n Boolean values can be \"true\"/\"false\"/\"1\"/\"0\"\n\n x265 encoder specific note:\n When using the x265 encoder, you may pass any of its parameters by\n prefixing the parameter name with 'x265:'. Hence, to set the 'ctu' parameter,\n you will have to set 'x265:ctu' in libheif.\n Note that there is no checking for valid parameters when using the prefix."]
    pub fn heif_encoder_set_parameter(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
        value: *const libc::c_char,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the current value of a parameter of any type as a human readable string.\n The returned string is compatible with heif_encoder_set_parameter()."]
    pub fn heif_encoder_get_parameter(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
        value_ptr: *mut libc::c_char,
        value_size: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Query whether a specific parameter has a default value."]
    pub fn heif_encoder_has_default(
        arg1: *mut heif_encoder,
        parameter_name: *const libc::c_char,
    ) -> libc::c_int;
}
pub const heif_orientation_heif_orientation_normal: heif_orientation = 1;
pub const heif_orientation_heif_orientation_flip_horizontally: heif_orientation = 2;
pub const heif_orientation_heif_orientation_rotate_180: heif_orientation = 3;
pub const heif_orientation_heif_orientation_flip_vertically: heif_orientation = 4;
pub const heif_orientation_heif_orientation_rotate_90_cw_then_flip_horizontally: heif_orientation =
    5;
pub const heif_orientation_heif_orientation_rotate_90_cw: heif_orientation = 6;
pub const heif_orientation_heif_orientation_rotate_90_cw_then_flip_vertically: heif_orientation = 7;
pub const heif_orientation_heif_orientation_rotate_270_cw: heif_orientation = 8;
#[doc = " The orientation values are defined equal to the EXIF Orientation tag."]
pub type heif_orientation = libc::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct heif_encoding_options {
    pub version: u8,
    #[doc = " default: true"]
    pub save_alpha_channel: u8,
    #[doc = " DEPRECATED. This option is not required anymore. Its value will be ignored."]
    pub macOS_compatibility_workaround: u8,
    #[doc = " default: false"]
    pub save_two_colr_boxes_when_ICC_and_nclx_available: u8,
    #[doc = " Set this to the NCLX parameters to be used in the output image or set to NULL\n when the same parameters as in the input image should be used."]
    pub output_nclx_profile: *mut heif_color_profile_nclx,
    pub macOS_compatibility_workaround_no_nclx_profile: u8,
    #[doc = " libheif will generate irot/imir boxes to match these orientations"]
    pub image_orientation: heif_orientation,
    #[doc = " version 6 options"]
    pub color_conversion_options: heif_color_conversion_options,
    #[doc = " Set this to true to use compressed form of uncC where possible."]
    pub prefer_uncC_short_form: u8,
}
unsafe extern "C" {
    pub fn heif_encoding_options_alloc() -> *mut heif_encoding_options;
}
unsafe extern "C" {
    pub fn heif_encoding_options_copy(
        dst: *mut heif_encoding_options,
        src: *const heif_encoding_options,
    );
}
unsafe extern "C" {
    pub fn heif_encoding_options_free(arg1: *mut heif_encoding_options);
}
unsafe extern "C" {
    #[doc = " Compress the input image.\n Returns a handle to the coded image in 'out_image_handle' unless out_image_handle = NULL.\n 'options' should be NULL for now.\n The first image added to the context is also automatically set the primary image, but\n you can change the primary image later with heif_context_set_primary_image()."]
    pub fn heif_context_encode_image(
        arg1: *mut heif_context,
        image: *const heif_image,
        encoder: *mut heif_encoder,
        options: *const heif_encoding_options,
        out_image_handle: *mut *mut heif_image_handle,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " offsets[] should either be NULL (all offsets==0) or an array of size 2*nImages with x;y offset pairs.\n If background_rgba is NULL, the background is transparent."]
    pub fn heif_context_add_overlay_image(
        ctx: *mut heif_context,
        image_width: u32,
        image_height: u32,
        nImages: u16,
        image_ids: *const heif_item_id,
        offsets: *mut i32,
        background_rgba: *const [u16; 4usize],
        out_iovl_image_handle: *mut *mut heif_image_handle,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_context_set_primary_image(
        arg1: *mut heif_context,
        image_handle: *mut heif_image_handle,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Set the major brand of the file.\n If this function is not called, the major brand is determined automatically from\n the image or sequence content."]
    pub fn heif_context_set_major_brand(ctx: *mut heif_context, major_brand: heif_brand2);
}
unsafe extern "C" {
    #[doc = " Add a compatible brand that is now added automatically by libheif when encoding images (e.g. some application brands like 'geo1')."]
    pub fn heif_context_add_compatible_brand(ctx: *mut heif_context, compatible_brand: heif_brand2);
}
unsafe extern "C" {
    #[doc = " DEPRECATED, typo in function name"]
    pub fn heif_encoder_descriptor_supportes_lossy_compression(
        arg1: *const heif_encoder_descriptor,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " DEPRECATED, typo in function name"]
    pub fn heif_encoder_descriptor_supportes_lossless_compression(
        arg1: *const heif_encoder_descriptor,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " DEPRECATED: use heif_get_encoder_descriptors() instead.\n Get a list of available encoders. You can filter the encoders by compression format and name.\n Use format_filter==heif_compression_undefined and name_filter==NULL as wildcards.\n The returned list of encoders is sorted by their priority (which is a plugin property).\n The number of encoders is returned, which are not more than 'count' if (out_encoders != nullptr).\n By setting out_encoders==nullptr, you can query the number of encoders, 'count' is ignored.\n Note: to get the actual encoder from the descriptors returned here, use heif_context_get_encoder()."]
    pub fn heif_context_get_encoder_descriptors(
        arg1: *mut heif_context,
        format_filter: heif_compression_format,
        name_filter: *const libc::c_char,
        out_encoders: *mut *const heif_encoder_descriptor,
        count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " If the maximum threads number is set to 0, the image tiles are decoded in the main thread.\n This is different from setting it to 1, which will generate a single background thread to decode the tiles.\n Note that this setting only affects libheif itself. The codecs itself may still use multi-threaded decoding.\n You can use it, for example, in cases where you are decoding several images in parallel anyway you thus want\n to minimize parallelism in each decoder."]
    pub fn heif_context_set_max_decoding_threads(ctx: *mut heif_context, max_threads: libc::c_int);
}
unsafe extern "C" {
    #[doc = " Quick check whether there is a decoder available for the given format.\n Note that the decoder still may not be able to decode all variants of that format.\n You will have to query that further (todo) or just try to decode and check the returned error."]
    pub fn heif_have_decoder_for_format(format: heif_compression_format) -> libc::c_int;
}
pub const heif_progress_step_heif_progress_step_total: heif_progress_step = 0;
pub const heif_progress_step_heif_progress_step_load_tile: heif_progress_step = 1;
pub type heif_progress_step = libc::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct heif_decoding_options {
    pub version: u8,
    #[doc = " Ignore geometric transformations like cropping, rotation, mirroring.\n Default: false (do not ignore)."]
    pub ignore_transformations: u8,
    #[doc = " Any of the progress functions may be called from background threads."]
    pub start_progress: ::std::option::Option<
        unsafe extern "C" fn(
            step: heif_progress_step,
            max_progress: libc::c_int,
            progress_user_data: *mut libc::c_void,
        ),
    >,
    pub on_progress: ::std::option::Option<
        unsafe extern "C" fn(
            step: heif_progress_step,
            progress: libc::c_int,
            progress_user_data: *mut libc::c_void,
        ),
    >,
    pub end_progress: ::std::option::Option<
        unsafe extern "C" fn(step: heif_progress_step, progress_user_data: *mut libc::c_void),
    >,
    pub progress_user_data: *mut libc::c_void,
    #[doc = " version 2 options"]
    pub convert_hdr_to_8bit: u8,
    #[doc = " When enabled, an error is returned for invalid input. Otherwise, it will try its best and\n add decoding warnings to the decoded heif_image. Default is non-strict."]
    pub strict_decoding: u8,
    #[doc = " name_id of the decoder to use for the decoding.\n If set to NULL (default), the highest priority decoder is chosen.\n The priority is defined in the plugin."]
    pub decoder_id: *const libc::c_char,
    #[doc = " version 5 options"]
    pub color_conversion_options: heif_color_conversion_options,
    #[doc = " version 6 options"]
    pub cancel_decoding: ::std::option::Option<
        unsafe extern "C" fn(progress_user_data: *mut libc::c_void) -> libc::c_int,
    >,
    #[doc = " When set to NULL, default options will be used"]
    pub color_conversion_options_ext: *mut heif_color_conversion_options_ext,
}
unsafe extern "C" {
    #[doc = " Allocate decoding options and fill with default values.\n Note: you should always get the decoding options through this function since the\n option structure may grow in size in future versions."]
    pub fn heif_decoding_options_alloc() -> *mut heif_decoding_options;
}
unsafe extern "C" {
    pub fn heif_decoding_options_copy(
        dst: *mut heif_decoding_options,
        src: *const heif_decoding_options,
    );
}
unsafe extern "C" {
    pub fn heif_decoding_options_free(arg1: *mut heif_decoding_options);
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_decoder_descriptor {
    _unused: [u8; 0],
}
unsafe extern "C" {
    #[doc = " Get a list of available decoders. You can filter the encoders by compression format.\n Use format_filter==heif_compression_undefined to get all available decoders.\n The returned list of decoders is sorted by their priority (which is a plugin property).\n The number of decoders is returned, which are not more than 'count' if (out_decoders != nullptr).\n By setting out_decoders==nullptr, you can query the number of decoders, 'count' is ignored."]
    pub fn heif_get_decoder_descriptors(
        format_filter: heif_compression_format,
        out_decoders: *mut *const heif_decoder_descriptor,
        count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Return a long, descriptive name of the decoder (including version information)."]
    pub fn heif_decoder_descriptor_get_name(
        arg1: *const heif_decoder_descriptor,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Return a short, symbolic name for identifying the decoder.\n This name should stay constant over different decoder versions.\n Note: the returned ID may be NULL for old plugins that don't support this yet."]
    pub fn heif_decoder_descriptor_get_id_name(
        arg1: *const heif_decoder_descriptor,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Decode an heif_image_handle into the actual pixel image and also carry out\n all geometric transformations specified in the HEIF file (rotation, cropping, mirroring).\n\n If colorspace or chroma is set to heif_colorspace_undefined or heif_chroma_undefined,\n respectively, the original colorspace is taken.\n Decoding options may be NULL. If you want to supply options, always use\n heif_decoding_options_alloc() to get the structure."]
    pub fn heif_decode_image(
        in_handle: *const heif_image_handle,
        out_img: *mut *mut heif_image,
        colorspace: heif_colorspace,
        chroma: heif_chroma,
        options: *const heif_decoding_options,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Release image handle."]
    pub fn heif_image_handle_release(arg1: *const heif_image_handle);
}
unsafe extern "C" {
    #[doc = " Check whether the given image_handle is the primary image of the file."]
    pub fn heif_image_handle_is_primary_image(handle: *const heif_image_handle) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_get_item_id(handle: *const heif_image_handle) -> heif_item_id;
}
unsafe extern "C" {
    #[doc = " Get the resolution of an image."]
    pub fn heif_image_handle_get_width(handle: *const heif_image_handle) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_get_height(handle: *const heif_image_handle) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_has_alpha_channel(arg1: *const heif_image_handle) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_is_premultiplied_alpha(arg1: *const heif_image_handle) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Returns -1 on error, e.g. if this information is not present in the image.\n Only defined for images coded in the YCbCr or monochrome colorspace."]
    pub fn heif_image_handle_get_luma_bits_per_pixel(arg1: *const heif_image_handle)
        -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Returns -1 on error, e.g. if this information is not present in the image.\n Only defined for images coded in the YCbCr colorspace."]
    pub fn heif_image_handle_get_chroma_bits_per_pixel(
        arg1: *const heif_image_handle,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Return the colorspace that libheif proposes to use for decoding.\n Usually, these will be either YCbCr or Monochrome, but it may also propose RGB for images\n encoded with matrix_coefficients=0 or for images coded natively in RGB.\n It may also return *_undefined if the file misses relevant information to determine this without decoding.\n These are only proposed values that avoid colorspace conversions as much as possible.\n You can still request the output in your preferred colorspace, but this may involve an internal conversion."]
    pub fn heif_image_handle_get_preferred_decoding_colorspace(
        image_handle: *const heif_image_handle,
        out_colorspace: *mut heif_colorspace,
        out_chroma: *mut heif_chroma,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the image width from the 'ispe' box. This is the original image size without\n any transformations applied to it. Do not use this unless you know exactly what\n you are doing."]
    pub fn heif_image_handle_get_ispe_width(handle: *const heif_image_handle) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_get_ispe_height(handle: *const heif_image_handle) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Returns whether the image has 'pixel aspect ratio information' information. If 0 is returned, the output is filled with the 1:1 default."]
    pub fn heif_image_handle_get_pixel_aspect_ratio(
        arg1: *const heif_image_handle,
        aspect_h: *mut u32,
        aspect_v: *mut u32,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " This gets the context associated with the image handle.\n Note that you have to release the returned context with heif_context_free() in any case.\n\n This means: when you have several image-handles that originate from the same file and you get the\n context of each of them, the returned pointer may be different even though it refers to the same\n logical context. You have to call heif_context_free() on all those context pointers.\n After you freed a context pointer, you can still use the context through a different pointer that you\n might have acquired from elsewhere."]
    pub fn heif_image_handle_get_context(handle: *const heif_image_handle) -> *mut heif_context;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_image_tiling {
    pub version: libc::c_int,
    #[doc = " --- version 1"]
    pub num_columns: u32,
    pub num_rows: u32,
    pub tile_width: u32,
    pub tile_height: u32,
    pub image_width: u32,
    pub image_height: u32,
    #[doc = " Position of the top left tile.\n Usually, this is (0;0), but if a tiled image is rotated or cropped, it may be that the top left tile should be placed at a negative position.\n The offsets define this negative shift."]
    pub top_offset: u32,
    pub left_offset: u32,
    #[doc = " 0 for normal images, 1 for volumetric (3D), ..."]
    pub number_of_extra_dimensions: u8,
    #[doc = " size of extra dimensions (first 8 dimensions)"]
    pub extra_dimension_size: [u32; 8usize],
}
unsafe extern "C" {
    #[doc = " If 'process_image_transformations' is true, this returns modified sizes.\n If it is false, the top_offset and left_offset will always be (0;0)."]
    pub fn heif_image_handle_get_image_tiling(
        handle: *const heif_image_handle,
        process_image_transformations: libc::c_int,
        out_tiling: *mut heif_image_tiling,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " For grid images, return the image item ID of a specific grid tile.\n If 'process_image_transformations' is true, the tile positions are given in the transformed image coordinate system and\n are internally mapped to the original image tile positions."]
    pub fn heif_image_handle_get_grid_image_tile_id(
        handle: *const heif_image_handle,
        process_image_transformations: libc::c_int,
        tile_x: u32,
        tile_y: u32,
        out_tile_item_id: *mut heif_item_id,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " The tile position is given in tile indices, not in pixel coordinates.\n If the image transformations are processed (option->ignore_image_transformations==false), the tile position\n is given in the transformed coordinates."]
    pub fn heif_image_handle_decode_image_tile(
        in_handle: *const heif_image_handle,
        out_img: *mut *mut heif_image,
        colorspace: heif_colorspace,
        chroma: heif_chroma,
        options: *const heif_decoding_options,
        tile_x: u32,
        tile_y: u32,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " @brief Encodes an array of images into a grid.\n\n @param ctx The file context\n @param tiles User allocated array of images that will form the grid.\n @param rows The number of rows in the grid.\n @param columns The number of columns in the grid.\n @param encoder Defines the encoder to use. See heif_context_get_encoder_for_format()\n @param input_options Optional, may be nullptr.\n @param out_image_handle Returns a handle to the grid. The caller is responsible for freeing it.\n @return Returns an error if ctx, tiles, or encoder is nullptr. If rows or columns is 0."]
    pub fn heif_context_encode_grid(
        ctx: *mut heif_context,
        tiles: *mut *mut heif_image,
        rows: u16,
        columns: u16,
        encoder: *mut heif_encoder,
        input_options: *const heif_encoding_options,
        out_image_handle: *mut *mut heif_image_handle,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_context_add_grid_image(
        ctx: *mut heif_context,
        image_width: u32,
        image_height: u32,
        tile_columns: u32,
        tile_rows: u32,
        encoding_options: *const heif_encoding_options,
        out_grid_image_handle: *mut *mut heif_image_handle,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_context_add_image_tile(
        ctx: *mut heif_context,
        tiled_image: *mut heif_image_handle,
        tile_x: u32,
        tile_y: u32,
        image: *const heif_image,
        encoder: *mut heif_encoder,
    ) -> heif_error;
}
#[doc = "  heif_item_property_unknown = -1,"]
pub const heif_item_property_type_heif_item_property_type_invalid: heif_item_property_type = 0;
#[doc = "  heif_item_property_unknown = -1,"]
pub const heif_item_property_type_heif_item_property_type_user_description:
    heif_item_property_type = 1969513843;
#[doc = "  heif_item_property_unknown = -1,"]
pub const heif_item_property_type_heif_item_property_type_transform_mirror:
    heif_item_property_type = 1768778098;
#[doc = "  heif_item_property_unknown = -1,"]
pub const heif_item_property_type_heif_item_property_type_transform_rotation:
    heif_item_property_type = 1769107316;
#[doc = "  heif_item_property_unknown = -1,"]
pub const heif_item_property_type_heif_item_property_type_transform_crop: heif_item_property_type =
    1668047216;
#[doc = "  heif_item_property_unknown = -1,"]
pub const heif_item_property_type_heif_item_property_type_image_size: heif_item_property_type =
    1769173093;
#[doc = "  heif_item_property_unknown = -1,"]
pub const heif_item_property_type_heif_item_property_type_uuid: heif_item_property_type =
    1970628964;
#[doc = "  heif_item_property_unknown = -1,"]
pub const heif_item_property_type_heif_item_property_type_tai_clock_info: heif_item_property_type =
    1952541027;
#[doc = "  heif_item_property_unknown = -1,"]
pub const heif_item_property_type_heif_item_property_type_tai_timestamp: heif_item_property_type =
    1769234793;
#[doc = " ------------------------- item properties -------------------------"]
pub type heif_item_property_type = libc::c_uint;
unsafe extern "C" {
    #[doc = " Get the heif_property_id for a heif_item_id.\n You may specify which property 'type' you want to receive.\n If you specify 'heif_item_property_type_invalid', all properties associated to that item are returned.\n The number of properties is returned, which are not more than 'count' if (out_list != nullptr).\n By setting out_list==nullptr, you can query the number of properties, 'count' is ignored."]
    pub fn heif_item_get_properties_of_type(
        context: *const heif_context,
        id: heif_item_id,
        type_: heif_item_property_type,
        out_list: *mut heif_property_id,
        count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Returns all transformative properties in the correct order.\n This includes \"irot\", \"imir\", \"clap\".\n The number of properties is returned, which are not more than 'count' if (out_list != nullptr).\n By setting out_list==nullptr, you can query the number of properties, 'count' is ignored."]
    pub fn heif_item_get_transformation_properties(
        context: *const heif_context,
        id: heif_item_id,
        out_list: *mut heif_property_id,
        count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_item_get_property_type(
        context: *const heif_context,
        id: heif_item_id,
        property_id: heif_property_id,
    ) -> heif_item_property_type;
}
#[doc = " The strings are managed by libheif. They will be deleted in heif_property_user_description_release()."]
#[repr(C)]
#[derive(Debug)]
pub struct heif_property_user_description {
    pub version: libc::c_int,
    #[doc = " version 1"]
    pub lang: *const libc::c_char,
    pub name: *const libc::c_char,
    pub description: *const libc::c_char,
    pub tags: *const libc::c_char,
}
unsafe extern "C" {
    #[doc = " Get the \"udes\" user description property content.\n Undefined strings are returned as empty strings."]
    pub fn heif_item_get_property_user_description(
        context: *const heif_context,
        itemId: heif_item_id,
        propertyId: heif_property_id,
        out: *mut *mut heif_property_user_description,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add a \"udes\" user description property to the item.\n If any string pointers are NULL, an empty string will be used instead."]
    pub fn heif_item_add_property_user_description(
        context: *const heif_context,
        itemId: heif_item_id,
        description: *const heif_property_user_description,
        out_propertyId: *mut heif_property_id,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Release all strings and the object itself.\n Only call for objects that you received from heif_item_get_property_user_description()."]
    pub fn heif_property_user_description_release(arg1: *mut heif_property_user_description);
}
pub const heif_transform_mirror_direction_heif_transform_mirror_direction_invalid:
    heif_transform_mirror_direction = -1;
#[doc = " flip image vertically"]
pub const heif_transform_mirror_direction_heif_transform_mirror_direction_vertical:
    heif_transform_mirror_direction = 0;
#[doc = " flip image horizontally"]
pub const heif_transform_mirror_direction_heif_transform_mirror_direction_horizontal:
    heif_transform_mirror_direction = 1;
pub type heif_transform_mirror_direction = libc::c_int;
unsafe extern "C" {
    #[doc = " Will return 'heif_transform_mirror_direction_invalid' in case of error."]
    pub fn heif_item_get_property_transform_mirror(
        context: *const heif_context,
        itemId: heif_item_id,
        propertyId: heif_property_id,
    ) -> heif_transform_mirror_direction;
}
unsafe extern "C" {
    #[doc = " Returns only 0, 90, 180, or 270 angle values.\n Returns -1 in case of error (but it will only return an error in case of wrong usage)."]
    pub fn heif_item_get_property_transform_rotation_ccw(
        context: *const heif_context,
        itemId: heif_item_id,
        propertyId: heif_property_id,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Returns the number of pixels that should be removed from the four edges.\n Because of the way this data is stored, you have to pass the image size at the moment of the crop operation\n to compute the cropped border sizes."]
    pub fn heif_item_get_property_transform_crop_borders(
        context: *const heif_context,
        itemId: heif_item_id,
        propertyId: heif_property_id,
        image_width: libc::c_int,
        image_height: libc::c_int,
        left: *mut libc::c_int,
        top: *mut libc::c_int,
        right: *mut libc::c_int,
        bottom: *mut libc::c_int,
    );
}
unsafe extern "C" {
    #[doc = " @param context     The heif_context for the file\n @param itemId      The image item id to which this property belongs.\n @param fourcc_type The short four-cc type of the property to add.\n @param uuid_type   If fourcc_type=='uuid', this should point to a 16-byte UUID type. It is ignored otherwise and can be NULL.\n @param data        Data to insert for this property (including a full-box header, if required for this box).\n @param size        Length of data in bytes.\n @param is_essential   Whether this property is essential (boolean).\n @param out_propertyId Outputs the id of the inserted property. Can be NULL."]
    pub fn heif_item_add_raw_property(
        context: *const heif_context,
        itemId: heif_item_id,
        fourcc_type: u32,
        uuid_type: *const u8,
        data: *const u8,
        size: usize,
        is_essential: libc::c_int,
        out_propertyId: *mut heif_property_id,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_item_get_property_raw_size(
        context: *const heif_context,
        itemId: heif_item_id,
        propertyId: heif_property_id,
        out_size: *mut usize,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " @param out_data User-supplied array to write the property data to. The required size of the output array is given by heif_item_get_property_raw_size()."]
    pub fn heif_item_get_property_raw_data(
        context: *const heif_context,
        itemId: heif_item_id,
        propertyId: heif_property_id,
        out_data: *mut u8,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the extended type for an extended \"uuid\" box.\n\n This provides the UUID for the extended box.\n\n This method should only be called on properties of type `heif_item_property_type_uuid`.\n\n @param context the heif_context containing the HEIF file\n @param itemId the image item id to which this property belongs.\n @param propertyId the property index (1-based) to get the extended type for\n @param out_extended_type output of the call, must be a pointer to at least 16-bytes.\n @return heif_error_success or an error indicating the failure"]
    pub fn heif_item_get_property_uuid_type(
        context: *const heif_context,
        itemId: heif_item_id,
        propertyId: heif_property_id,
        out_extended_type: *mut [u8; 16usize],
    ) -> heif_error;
}
#[doc = " ------------------------- intrinsic and extrinsic matrices -------------------------"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_camera_intrinsic_matrix {
    pub focal_length_x: f64,
    pub focal_length_y: f64,
    pub principal_point_x: f64,
    pub principal_point_y: f64,
    pub skew: f64,
}
unsafe extern "C" {
    pub fn heif_image_handle_has_camera_intrinsic_matrix(
        handle: *const heif_image_handle,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_get_camera_intrinsic_matrix(
        handle: *const heif_image_handle,
        out_matrix: *mut heif_camera_intrinsic_matrix,
    ) -> heif_error;
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_camera_extrinsic_matrix {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn heif_image_handle_has_camera_extrinsic_matrix(
        handle: *const heif_image_handle,
    ) -> libc::c_int;
}
unsafe extern "C" {
    pub fn heif_image_handle_get_camera_extrinsic_matrix(
        handle: *const heif_image_handle,
        out_matrix: *mut *mut heif_camera_extrinsic_matrix,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_camera_extrinsic_matrix_release(arg1: *mut heif_camera_extrinsic_matrix);
}
unsafe extern "C" {
    pub fn heif_camera_extrinsic_matrix_get_rotation_matrix(
        arg1: *const heif_camera_extrinsic_matrix,
        out_matrix_row_major: *mut f64,
    ) -> heif_error;
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_region_item {
    _unused: [u8; 0],
}
#[doc = " Point gemetry.\n\n The region is represented by a single point."]
pub const heif_region_type_heif_region_type_point: heif_region_type = 0;
#[doc = " Rectangle geometry.\n\n The region is represented by a top left position, and a size defined\n by a width and height. All of the interior points and the edge are\n part of the region."]
pub const heif_region_type_heif_region_type_rectangle: heif_region_type = 1;
#[doc = " Ellipse geometry.\n\n The region is represented by a centre point, and radii in the X and\n Y directions. All of the interior points and the edge are part of the\n region."]
pub const heif_region_type_heif_region_type_ellipse: heif_region_type = 2;
#[doc = " Polygon geometry.\n\n The region is represented by a sequence of points, which is considered\n implicitly closed. All of the interior points and the edge are part\n of the region."]
pub const heif_region_type_heif_region_type_polygon: heif_region_type = 3;
#[doc = " Reference mask.\n\n The region geometry is described by the pixels in another image item,\n which has a item reference of type `mask` from the region item to the\n image item containing the mask.\n\n The image item containing the mask is one of:\n\n - a mask item (see ISO/IEC 23008-12:2022 Section 6.10.2), or a derived\n image from a mask item\n\n - an image item in monochrome format (4:0:0 chroma)\n\n - an image item in colour format with luma and chroma planes (e.g. 4:2:0)\n\n If the pixel value is equal to the minimum sample value (e.g. 0 for unsigned\n integer), the pixel is not part of the region. If the pixel value is equal\n to the maximum sample value (e.g. 255 for 8 bit unsigned integer), the pixel\n is part of the region. If the pixel value is between the minimum sample value\n and maximum sample value, the pixel value represents an (application defined)\n probability that the pixel is part of the region, where higher pixel values\n correspond to higher probability values."]
pub const heif_region_type_heif_region_type_referenced_mask: heif_region_type = 4;
#[doc = " Inline mask.\n\n The region geometry is described by a sequence of bits stored in inline\n in the region, one bit per pixel. If the bit value is `1`, the pixel is\n part of the region. If the bit value is `0`, the pixel is not part of the\n region."]
pub const heif_region_type_heif_region_type_inline_mask: heif_region_type = 5;
#[doc = " Polyline geometry.\n\n The region is represented by a sequence of points, which are not\n considered to form a closed surface. Only the edge is part of the region."]
pub const heif_region_type_heif_region_type_polyline: heif_region_type = 6;
#[doc = " Region type.\n\n Each region item will contain zero or more regions, which may have different geometry or\n mask representations."]
pub type heif_region_type = libc::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct heif_region {
    _unused: [u8; 0],
}
unsafe extern "C" {
    #[doc = " Get the number of region items that are attached to an image.\n\n @param image_handle the image handle for the image to query.\n @return the number of region items, which can be zero."]
    pub fn heif_image_handle_get_number_of_region_items(
        image_handle: *const heif_image_handle,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the region item identifiers for the region items attached to an image.\n\n Possible usage (in C++):\n @code\n  int numRegionItems = heif_image_handle_get_number_of_region_items(handle);\n  if (numRegionItems > 0) {\n      std::vector<heif_item_id> region_item_ids(numRegionItems);\n      heif_image_handle_get_list_of_region_item_ids(handle, region_item_ids.data(), numRegionItems);\n      // use region item ids\n  }\n @endcode\n\n @param image_handle the image handle for the parent image to query\n @param region_item_ids_array array to put the item identifiers into\n @param max_count the maximum number of region identifiers\n @return the number of region item identifiers that were returned."]
    pub fn heif_image_handle_get_list_of_region_item_ids(
        image_handle: *const heif_image_handle,
        region_item_ids_array: *mut heif_item_id,
        max_count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the region item.\n\n Caller is responsible for release of the output heif_region_item with heif_region_item_release().\n\n @param context the context to get the region item from, usually from a file operation\n @param region_item_id the identifier for the region item\n @param out pointer to pointer to the resulting region item\n @return heif_error_ok on success, or an error value indicating the problem"]
    pub fn heif_context_get_region_item(
        context: *const heif_context,
        region_item_id: heif_item_id,
        out: *mut *mut heif_region_item,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the item identifier for a region item.\n\n @param region_item the region item to query\n @return the region item identifier (or -1 if the region_item is null)"]
    pub fn heif_region_item_get_id(region_item: *mut heif_region_item) -> heif_item_id;
}
unsafe extern "C" {
    #[doc = " Release a region item.\n\n This should be called on items from heif_context_get_region_item().\n\n @param region_item the item to release."]
    pub fn heif_region_item_release(region_item: *mut heif_region_item);
}
unsafe extern "C" {
    #[doc = " Get the reference size for a region item.\n\n The reference size specifies the coordinate space used for the region items.\n When the reference size does not match the image size, the regions need to be\n scaled to correspond.\n\n @param out_width the return value for the reference width (before any transformation)\n @param out_height the return value for the reference height (before any transformation)"]
    pub fn heif_region_item_get_reference_size(
        arg1: *mut heif_region_item,
        out_width: *mut u32,
        out_height: *mut u32,
    );
}
unsafe extern "C" {
    #[doc = " Get the number of regions within a region item.\n\n @param region_item the region item to query.\n @return the number of regions"]
    pub fn heif_region_item_get_number_of_regions(
        region_item: *const heif_region_item,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the regions that are part of a region item.\n\n Caller is responsible for releasing the returned `heif_region` objects, using heif_region_release()\n on each region, or heif_region_release_many() on the returned array.\n\n Possible usage (in C++):\n @code\n  int num_regions = heif_image_handle_get_number_of_regions(region_item);\n  if (num_regions > 0) {\n      std::vector<heif_region*> regions(num_regions);\n      int n = heif_region_item_get_list_of_regions(region_item, regions.data(), (int)regions.size());\n      // use regions\n      heif_region_release_many(regions.data(), n);\n  }\n @endcode\n\n @param region_item the region_item to query\n @param out_regions_array array to put the region pointers into\n @param max_count the maximum number of regions, which needs to correspond to the size of the out_regions_array\n @return the number of regions that were returned."]
    pub fn heif_region_item_get_list_of_regions(
        region_item: *const heif_region_item,
        out_regions_array: *mut *mut heif_region,
        max_count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Release a region.\n\n This should be called on regions from heif_region_item_get_list_of_regions().\n\n @param region the region to release.\n\n \\sa heif_region_release_many() to release the whole list"]
    pub fn heif_region_release(region: *const heif_region);
}
unsafe extern "C" {
    #[doc = " Release a list of regions.\n\n This should be called on the list of regions from heif_region_item_get_list_of_regions().\n\n @param regions_array the regions to release.\n @param num_items the number of items in the array\n\n \\sa heif_region_release() to release a single region"]
    pub fn heif_region_release_many(
        regions_array: *const *const heif_region,
        num_items: libc::c_int,
    );
}
unsafe extern "C" {
    #[doc = " Get the region type for a specified region.\n\n @param region the region to query\n @return the corresponding region type as an enumeration value"]
    pub fn heif_region_get_type(region: *const heif_region) -> heif_region_type;
}
unsafe extern "C" {
    #[doc = " Get the values for a point region.\n\n This returns the coordinates in the reference coordinate space (from the parent region item).\n\n @param region the region to query, which must be of type #heif_region_type_point.\n @param out_x the X coordinate, where 0 is the left-most column.\n @param out_y the Y coordinate, where 0 is the top-most row.\n @return heif_error_ok on success, or an error value indicating the problem on failure\n\n \\sa heif_region_get_point_transformed() for a version in pixels after all transformative properties have been applied."]
    pub fn heif_region_get_point(
        region: *const heif_region,
        out_x: *mut i32,
        out_y: *mut i32,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the transformed values for a point region.\n\n This returns the coordinates in pixels after all transformative properties have been applied.\n\n @param region the region to query, which must be of type #heif_region_type_point.\n @param image_id the identifier for the image to transform / scale the region to\n @param out_x the X coordinate, where 0 is the left-most column.\n @param out_y the Y coordinate, where 0 is the top-most row.\n @return heif_error_ok on success, or an error value indicating the problem on failure\n\n \\sa heif_region_get_point() for a version that returns the values in the reference coordinate space."]
    pub fn heif_region_get_point_transformed(
        region: *const heif_region,
        image_id: heif_item_id,
        out_x: *mut f64,
        out_y: *mut f64,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the values for a rectangle region.\n\n This returns the values in the reference coordinate space (from the parent region item).\n The rectangle is represented by a top left corner position, and a size defined\n by a width and height. All of the interior points and the edge are\n part of the region.\n\n @param region the region to query, which must be of type #heif_region_type_rectangle.\n @param out_x the X coordinate for the top left corner, where 0 is the left-most column.\n @param out_y the Y coordinate for the top left corner, where 0 is the top-most row.\n @param out_width the width of the rectangle\n @param out_height the height of the rectangle\n @return heif_error_ok on success, or an error value indicating the problem on failure\n\n \\sa heif_region_get_rectangle_transformed() for a version in pixels after all transformative properties have been applied."]
    pub fn heif_region_get_rectangle(
        region: *const heif_region,
        out_x: *mut i32,
        out_y: *mut i32,
        out_width: *mut u32,
        out_height: *mut u32,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the transformed values for a rectangle region.\n\n This returns the coordinates in pixels after all transformative properties have been applied.\n The rectangle is represented by a top left corner position, and a size defined\n by a width and height. All of the interior points and the edge are\n part of the region.\n\n @param region the region to query, which must be of type #heif_region_type_rectangle.\n @param image_id the identifier for the image to transform / scale the region to\n @param out_x the X coordinate for the top left corner, where 0 is the left-most column.\n @param out_y the Y coordinate for the top left corner, where 0 is the top-most row.\n @param out_width the width of the rectangle\n @param out_height the height of the rectangle\n @return heif_error_ok on success, or an error value indicating the problem on failure\n\n \\sa heif_region_get_rectangle() for a version that returns the values in the reference coordinate space."]
    pub fn heif_region_get_rectangle_transformed(
        region: *const heif_region,
        image_id: heif_item_id,
        out_x: *mut f64,
        out_y: *mut f64,
        out_width: *mut f64,
        out_height: *mut f64,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the values for an ellipse region.\n\n This returns the values in the reference coordinate space (from the parent region item).\n The ellipse is represented by a centre position, and a size defined\n by radii in the X and Y directions. All of the interior points and the edge are\n part of the region.\n\n @param region the region to query, which must be of type #heif_region_type_ellipse.\n @param out_x the X coordinate for the centre point, where 0 is the left-most column.\n @param out_y the Y coordinate for the centre point, where 0 is the top-most row.\n @param out_radius_x the radius value in the X direction.\n @param out_radius_y the radius value in the Y direction\n @return heif_error_ok on success, or an error value indicating the problem on failure\n\n \\sa heif_region_get_ellipse_transformed() for a version in pixels after all transformative properties have been applied."]
    pub fn heif_region_get_ellipse(
        region: *const heif_region,
        out_x: *mut i32,
        out_y: *mut i32,
        out_radius_x: *mut u32,
        out_radius_y: *mut u32,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the transformed values for an ellipse region.\n\n This returns the coordinates in pixels after all transformative properties have been applied.\n The ellipse is represented by a centre position, and a size defined\n by radii in the X and Y directions. All of the interior points and the edge are\n part of the region.\n\n @param region the region to query, which must be of type #heif_region_type_ellipse.\n @param image_id the identifier for the image to transform / scale the region to\n @param out_x the X coordinate for the centre point, where 0 is the left-most column.\n @param out_y the Y coordinate for the centre point, where 0 is the top-most row.\n @param out_radius_x the radius value in the X direction.\n @param out_radius_y the radius value in the Y direction\n @return heif_error_ok on success, or an error value indicating the problem on failure\n\n \\sa heif_region_get_ellipse() for a version that returns the values in the reference coordinate space."]
    pub fn heif_region_get_ellipse_transformed(
        region: *const heif_region,
        image_id: heif_item_id,
        out_x: *mut f64,
        out_y: *mut f64,
        out_radius_x: *mut f64,
        out_radius_y: *mut f64,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the number of points in a polygon.\n\n @param region the region to query, which must be of type #heif_region_type_polygon\n @return the number of points, or -1 on error."]
    pub fn heif_region_get_polygon_num_points(region: *const heif_region) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the points in a polygon region.\n\n This returns the values in the reference coordinate space (from the parent region item).\n\n A polygon is a sequence of points that form a closed shape. The first point does\n not need to be repeated as the last point. All of the interior points and the edge are\n part of the region.\n The points are returned as pairs of X,Y coordinates, in the order X<sub>1</sub>,\n Y<sub>1</sub>, X<sub>2</sub>, Y<sub>2</sub>, ..., X<sub>n</sub>, Y<sub>n</sub>.\n\n @param region the region to equery, which must be of type #heif_region_type_polygon\n @param out_pts_array the array to return the points in, which must have twice as many entries as there are points\n in the polygon.\n @return heif_error_ok on success, or an error value indicating the problem on failure\n\n \\sa heif_region_get_polygon_points_transformed() for a version in pixels after all transformative properties have been applied."]
    pub fn heif_region_get_polygon_points(
        region: *const heif_region,
        out_pts_array: *mut i32,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the transformed points in a polygon region.\n\n This returns the coordinates in pixels after all transformative properties have been applied.\n\n A polygon is a sequence of points that form a closed shape. The first point does\n not need to be repeated as the last point. All of the interior points and the edge are\n part of the region.\n The points are returned as pairs of X,Y coordinates, in the order X<sub>1</sub>,\n Y<sub>1</sub>, X<sub>2</sub>, Y<sub>2</sub>, ..., X<sub>n</sub>, Y<sub>n</sub>.\n\n @param region the region to equery, which must be of type #heif_region_type_polygon\n @param image_id the identifier for the image to transform / scale the region to\n @param out_pts_array the array to return the points in, which must have twice as many entries as there are points\n in the polygon.\n @return heif_error_ok on success, or an error value indicating the problem on failure\n\n \\sa heif_region_get_polygon_points() for a version that returns the values in the reference coordinate space."]
    pub fn heif_region_get_polygon_points_transformed(
        region: *const heif_region,
        image_id: heif_item_id,
        out_pts_array: *mut f64,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the number of points in a polyline.\n\n @param region the region to query, which must be of type #heif_region_type_polyline\n @return the number of points, or -1 on error."]
    pub fn heif_region_get_polyline_num_points(region: *const heif_region) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the points in a polyline region.\n\n This returns the values in the reference coordinate space (from the parent region item).\n\n A polyline is a sequence of points that does not form a closed shape. Even if the\n polyline is closed, the only points that are part of the region are those that\n intersect (even minimally) a one-pixel line drawn along the polyline.\n The points are provided as pairs of X,Y coordinates, in the order X<sub>1</sub>,\n Y<sub>1</sub>, X<sub>2</sub>, Y<sub>2</sub>, ..., X<sub>n</sub>, Y<sub>n</sub>.\n\n Possible usage (in C++):\n @code\n int num_polyline_points = heif_region_get_polyline_num_points(region);\n if (num_polyline_points > 0) {\n     std::vector<int32_t> polyline(num_polyline_points * 2);\n     heif_region_get_polyline_points(region, polyline.data());\n     // do something with points ...\n }\n @endcode\n\n @param region the region to equery, which must be of type #heif_region_type_polyline\n @param out_pts_array the array to return the points in, which must have twice as many entries as there are points\n in the polyline.\n @return heif_error_ok on success, or an error value indicating the problem on failure\n\n \\sa heif_region_get_polyline_points_transformed() for a version in pixels after all transformative properties have been applied."]
    pub fn heif_region_get_polyline_points(
        region: *const heif_region,
        out_pts_array: *mut i32,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the transformed points in a polyline region.\n\n This returns the coordinates in pixels after all transformative properties have been applied.\n\n A polyline is a sequence of points that does not form a closed shape. Even if the\n polyline is closed, the only points that are part of the region are those that\n intersect (even minimally) a one-pixel line drawn along the polyline.\n The points are provided as pairs of X,Y coordinates, in the order X<sub>1</sub>,\n Y<sub>1</sub>, X<sub>2</sub>, Y<sub>2</sub>, ..., X<sub>n</sub>, Y<sub>n</sub>.\n\n @param region the region to query, which must be of type #heif_region_type_polyline\n @param image_id the identifier for the image to transform / scale the region to\n @param out_pts_array the array to return the points in, which must have twice as many entries as there are points\n in the polyline.\n @return heif_error_ok on success, or an error value indicating the problem on failure\n\n \\sa heif_region_get_polyline_points() for a version that returns the values in the reference coordinate space."]
    pub fn heif_region_get_polyline_points_transformed(
        region: *const heif_region,
        image_id: heif_item_id,
        out_pts_array: *mut f64,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get a referenced item mask region.\n\n This returns the values in the reference coordinate space (from the parent region item).\n The mask location is represented by a top left corner position, and a size defined\n by a width and height. The value of each sample in that mask identifies whether the\n corresponding pixel is part of the region.\n\n The mask is provided as an image in another item. The image item containing the mask\n is one of:\n\n - a mask item (see ISO/IEC 23008-12:2022 Section 6.10.2), or a derived\n image from a mask item\n\n - an image item in monochrome format (4:0:0 chroma)\n\n - an image item in colour format with luma and chroma planes (e.g. 4:2:0)\n\n If the pixel value is equal to the minimum sample value (e.g. 0 for unsigned\n integer), the pixel is not part of the region. If the pixel value is equal\n to the maximum sample value (e.g. 255 for 8 bit unsigned integer), the pixel\n is part of the region. If the pixel value is between the minimum sample value\n and maximum sample value, the pixel value represents an (application defined)\n probability that the pixel is part of the region, where higher pixel values\n correspond to higher probability values.\n\n @param region the region to query, which must be of type #heif_region_type_referenced_mask.\n @param out_x the X coordinate for the top left corner, where 0 is the left-most column.\n @param out_y the Y coordinate for the top left corner, where 0 is the top-most row.\n @param out_width the width of the mask region\n @param out_height the height of the mask region\n @param out_mask_item_id the item identifier for the image that provides the mask.\n @return heif_error_ok on success, or an error value indicating the problem on failure"]
    pub fn heif_region_get_referenced_mask_ID(
        region: *const heif_region,
        out_x: *mut i32,
        out_y: *mut i32,
        out_width: *mut u32,
        out_height: *mut u32,
        out_mask_item_id: *mut heif_item_id,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the length of the data in an inline mask region.\n\n @param region the region to query, which must be of type #heif_region_type_inline_mask.\n @return the number of bytes in the mask data, or 0 on error."]
    pub fn heif_region_get_inline_mask_data_len(region: *const heif_region) -> usize;
}
unsafe extern "C" {
    #[doc = " Get data for an inline mask region.\n\n This returns the values in the reference coordinate space (from the parent region item).\n The mask location is represented by a top left corner position, and a size defined\n by a width and height.\n\n The mask is held as inline data on the region, one bit per pixel, most significant\n bit first pixel, no padding. If the bit value is `1`, the corresponding pixel is\n part of the region. If the bit value is `0`, the corresponding pixel is not part of the\n region.\n\n Possible usage (in C++):\n @code\n long unsigned int data_len = heif_region_get_inline_mask_data_len(region);\n int32_t x, y;\n uint32_t width, height;\n std::vector<uint8_t> mask_data(data_len);\n err = heif_region_get_inline_mask(region, &x, &y, &width, &height, mask_data.data());\n @endcode\n\n @param region the region to query, which must be of type #heif_region_type_inline_mask.\n @param out_x the X coordinate for the top left corner, where 0 is the left-most column.\n @param out_y the Y coordinate for the top left corner, where 0 is the top-most row.\n @param out_width the width of the mask region\n @param out_height the height of the mask region\n @param out_mask_data the location to return the mask data\n @return heif_error_ok on success, or an error value indicating the problem on failure"]
    pub fn heif_region_get_inline_mask_data(
        region: *const heif_region,
        out_x: *mut i32,
        out_y: *mut i32,
        out_width: *mut u32,
        out_height: *mut u32,
        out_mask_data: *mut u8,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get a mask region image.\n\n This returns the values in the reference coordinate space (from the parent region item).\n The mask location is represented by a top left corner position, and a size defined\n by a width and height.\n\n This function works when the passed region is either a heif_region_type_referenced_mask or\n a heif_region_type_inline_mask.\n The returned image is a monochrome image where each pixel represents the (scaled) probability\n of the pixel being part of the mask.\n\n If the region type is an inline mask, which always holds a binary mask, this function\n converts the binary inline mask to an 8-bit monochrome image with the values '0' and '255'.\n The pixel value is set to `255` where the pixel is part of the region, and `0` where the\n pixel is not part of the region.\n\n @param region the region to query, which must be of type #heif_region_type_inline_mask.\n @param out_x the X coordinate for the top left corner, where 0 is the left-most column.\n @param out_y the Y coordinate for the top left corner, where 0 is the top-most row.\n @param out_width the width of the mask region\n @param out_height the height of the mask region\n @param out_mask_image the returned mask image\n @return heif_error_ok on success, or an error value indicating the problem on failure\n\n \\note the caller is responsible for releasing the mask image"]
    pub fn heif_region_get_mask_image(
        region: *const heif_region,
        out_x: *mut i32,
        out_y: *mut i32,
        out_width: *mut u32,
        out_height: *mut u32,
        out_mask_image: *mut *mut heif_image,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add a region item to an image.\n\n The region item is a collection of regions (point, polyline, polygon, rectangle, ellipse or mask)\n along with a reference size (width and height) that forms the coordinate basis for the regions.\n\n The concept is to add the region item, then add one or more regions to the region item.\n\n @param image_handle the image to attach the region item to.\n @param reference_width the width of the reference size.\n @param reference_height the height of the reference size.\n @param out_region_item the resulting region item\n @return heif_error_ok on success, or an error indicating the problem on failure"]
    pub fn heif_image_handle_add_region_item(
        image_handle: *mut heif_image_handle,
        reference_width: u32,
        reference_height: u32,
        out_region_item: *mut *mut heif_region_item,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add a point region to the region item.\n\n @param region_item the region item that holds this point region\n @param x the x value for the point location\n @param y the y value for the point location\n @param out_region pointer to pointer to the returned region (optional, see below)\n @return heif_error_ok on success, or an error indicating the problem on failure\n\n @note The `out_region` parameter is optional, and can be set to `NULL` if not needed."]
    pub fn heif_region_item_add_region_point(
        region_item: *mut heif_region_item,
        x: i32,
        y: i32,
        out_region: *mut *mut heif_region,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add a rectangle region to the region item.\n\n @param region_item the region item that holds this rectangle region\n @param x the x value for the top-left corner of this rectangle region\n @param y the y value for the top-left corner of this rectangle region\n @param width the width of this rectangle region\n @param height the height of this rectangle region\n @param out_region pointer to pointer to the returned region (optional, see below)\n @return heif_error_ok on success, or an error indicating the problem on failure\n\n @note The `out_region` parameter is optional, and can be set to `NULL` if not needed."]
    pub fn heif_region_item_add_region_rectangle(
        region_item: *mut heif_region_item,
        x: i32,
        y: i32,
        width: u32,
        height: u32,
        out_region: *mut *mut heif_region,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add a ellipse region to the region item.\n\n @param region_item the region item that holds this ellipse region\n @param x the x value for the centre of this ellipse region\n @param y the y value for the centre of this ellipse region\n @param radius_x the radius of the ellipse in the X (horizontal) direction\n @param radius_y the radius of the ellipse in the Y (vertical) direction\n @param out_region pointer to pointer to the returned region (optional, see below)\n @return heif_error_ok on success, or an error indicating the problem on failure\n\n @note The `out_region` parameter is optional, and can be set to `NULL` if not needed."]
    pub fn heif_region_item_add_region_ellipse(
        region_item: *mut heif_region_item,
        x: i32,
        y: i32,
        radius_x: u32,
        radius_y: u32,
        out_region: *mut *mut heif_region,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add a polygon region to the region item.\n\n A polygon is a sequence of points that form a closed shape. The first point does\n not need to be repeated as the last point.\n The points are provided as pairs of X,Y coordinates, in the order X<sub>1</sub>,\n Y<sub>1</sub>, X<sub>2</sub>, Y<sub>2</sub>, ..., X<sub>n</sub>, Y<sub>n</sub>.\n\n @param region_item the region item that holds this polygon region\n @param pts_array the array of points in X,Y order (see above)\n @param nPoints the number of points\n @param out_region pointer to pointer to the returned region (optional, see below)\n @return heif_error_ok on success, or an error indicating the problem on failure\n\n @note `nPoints` is the number of points, not the number of elements in the array\n @note The `out_region` parameter is optional, and can be set to `NULL` if not needed."]
    pub fn heif_region_item_add_region_polygon(
        region_item: *mut heif_region_item,
        pts_array: *const i32,
        nPoints: libc::c_int,
        out_region: *mut *mut heif_region,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add a polyline region to the region item.\n\n A polyline is a sequence of points that does not form a closed shape. Even if the\n polyline is closed, the only points that are part of the region are those that\n intersect (even minimally) a one-pixel line drawn along the polyline.\n The points are provided as pairs of X,Y coordinates, in the order X<sub>1</sub>,\n Y<sub>1</sub>, X<sub>2</sub>, Y<sub>2</sub>, ..., X<sub>n</sub>, Y<sub>n</sub>.\n\n @param region_item the region item that holds this polyline region\n @param pts_array the array of points in X,Y order (see above)\n @param nPoints the number of points\n @param out_region pointer to pointer to the returned region (optional, see below)\n @return heif_error_ok on success, or an error indicating the problem on failure\n\n @note `nPoints` is the number of points, not the number of elements in the array\n @note The `out_region` parameter is optional, and can be set to `NULL` if not needed."]
    pub fn heif_region_item_add_region_polyline(
        region_item: *mut heif_region_item,
        pts_array: *const i32,
        nPoints: libc::c_int,
        out_region: *mut *mut heif_region,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add a referenced mask region to the region item.\n\n The region geometry is described by the pixels in another image item,\n which has a item reference of type `mask` from the region item to the\n image item containing the mask.\n\n The image item containing the mask is one of:\n\n - a mask item (see ISO/IEC 23008-12:2022 Section 6.10.2), or a derived\n image from a mask item\n\n - an image item in monochrome format (4:0:0 chroma)\n\n - an image item in colour format with luma and chroma planes (e.g. 4:2:0)\n\n If the pixel value is equal to the minimum sample value (e.g. 0 for unsigned\n integer), the pixel is not part of the region. If the pixel value is equal\n to the maximum sample value (e.g. 255 for 8 bit unsigned integer), the pixel\n is part of the region. If the pixel value is between the minimum sample value\n and maximum sample value, the pixel value represents an (application defined)\n probability that the pixel is part of the region, where higher pixel values\n correspond to higher probability values.\n\n @param region_item the region item that holds this mask region\n @param x the x value for the top-left corner of this mask region\n @param y the y value for the top-left corner of this mask region\n @param width the width of this mask region\n @param height the height of this mask region\n @param mask_item_id the item identifier for the mask that is referenced\n @param out_region pointer to pointer to the returned region (optional, see below)\n @return heif_error_ok on success, or an error indicating the problem on failure\n\n @note The `out_region` parameter is optional, and can be set to `NULL` if not needed."]
    pub fn heif_region_item_add_region_referenced_mask(
        region_item: *mut heif_region_item,
        x: i32,
        y: i32,
        width: u32,
        height: u32,
        mask_item_id: heif_item_id,
        out_region: *mut *mut heif_region,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add an inline mask region to the region item.\n\n The region geometry is described by a top left corner position, and a size defined\n by a width and height.\n\n The mask is held as inline data on the region, one bit per pixel, most significant\n bit first pixel, no padding. If the bit value is `1`, the corresponding pixel is\n part of the region. If the bit value is `0`, the corresponding pixel is not part of the\n region.\n\n @param region_item the region item that holds this mask region\n @param x the x value for the top-left corner of this mask region\n @param y the y value for the top-left corner of this mask region\n @param width the width of this mask region\n @param height the height of this mask region\n @param mask_data the location to return the mask data\n @param mask_data_len the length of the mask data, in bytes\n @param out_region pointer to pointer to the returned region (optional, see below)\n @return heif_error_ok on success, or an error value indicating the problem on failure"]
    pub fn heif_region_item_add_region_inline_mask_data(
        region_item: *mut heif_region_item,
        x: i32,
        y: i32,
        width: u32,
        height: u32,
        mask_data: *const u8,
        mask_data_len: usize,
        out_region: *mut *mut heif_region,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add an inline mask region image to the region item.\n\n The region geometry is described by a top left corner position, and a size defined\n by a width and height.\n\n The mask data is held as inline data on the region, one bit per pixel. The provided\n image is converted to inline data, where any pixel with a value >= 0x80 becomes part of the\n mask region. If the image width is less that the specified width, it is expanded\n to match the width of the region (zero fill on the right). If the image height is\n less than the specified height, it is expanded to match the height of the region\n (zero fill on the bottom). If the image width or height is greater than the\n width or height (correspondingly) of the region, the image is cropped.\n\n @param region_item the region item that holds this mask region\n @param x the x value for the top-left corner of this mask region\n @param y the y value for the top-left corner of this mask region\n @param width the width of this mask region\n @param height the height of this mask region\n @param image the image to convert to an inline mask\n @param out_region pointer to pointer to the returned region (optional, see below)\n @return heif_error_ok on success, or an error value indicating the problem on failure"]
    pub fn heif_region_item_add_region_inline_mask(
        region_item: *mut heif_region_item,
        x: i32,
        y: i32,
        width: u32,
        height: u32,
        image: *mut heif_image,
        out_region: *mut *mut heif_region,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Gets the number of items.\n\n This is not the same as the number of images, since there can be other types of items,\n such as metadata.\n\n @param ctx the file context\n @return the number of items"]
    pub fn heif_context_get_number_of_items(ctx: *const heif_context) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the item identifiers.\n\n Fills in the item IDs into the user-supplied array {@code ID_array}, preallocated with {@code count} entries.\n\n @param ctx the file context\n @param ID_array the output array.\n @param count the number of items allocated within {@code ID_array}.\n @return the total number of IDs filled into the array, which may be less than {@code count}."]
    pub fn heif_context_get_list_of_item_IDs(
        ctx: *const heif_context,
        ID_array: *mut heif_item_id,
        count: libc::c_int,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Gets the item type.\n\n Usually, this is a four character code (e.g. `mime` or `uri `), but it can theoretically be\n any 4-byte number. Thus, the type is returned as an integer. You can use {@link heif_fourcc} to map\n between the two representations.\n\n @param ctx the file context\n @param item_id the item identifier for the item\n @return the item type"]
    pub fn heif_item_get_item_type(ctx: *const heif_context, item_id: heif_item_id) -> u32;
}
unsafe extern "C" {
    pub fn heif_item_is_item_hidden(ctx: *const heif_context, item_id: heif_item_id)
        -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Gets the MIME content_type for an item.\n\n Only valid if the item type is `mime`.\n If the item does not exist, or if it is not a `mime` item, NULL is returned.\n\n @param ctx the file context\n @param item_id the item identifier for the item\n @return the item content_type"]
    pub fn heif_item_get_mime_item_content_type(
        ctx: *const heif_context,
        item_id: heif_item_id,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Gets the content_encoding for a MIME item.\n\n Only valid if the item type is `mime`.\n If the item does not exist, or if it is not a `mime` item, NULL is returned.\n\n If the item is not encoded, the returned value will be an empty string (not null).\n\n @param ctx the file context\n @param item_id the item identifier for the item\n @return the item content_type"]
    pub fn heif_item_get_mime_item_content_encoding(
        ctx: *const heif_context,
        item_id: heif_item_id,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Gets the item_uri_type for an item.\n\n Only valid if the item type is `uri `.\n If the item does not exist, or if it is not a `uri ` item, NULL is returned.\n\n @param ctx the file context\n @param item_id the item identifier for the item\n @return the item item_uri_type"]
    pub fn heif_item_get_uri_item_uri_type(
        ctx: *const heif_context,
        item_id: heif_item_id,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    pub fn heif_item_get_item_name(
        ctx: *const heif_context,
        item_id: heif_item_id,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    pub fn heif_item_set_item_name(
        ctx: *mut heif_context,
        item: heif_item_id,
        item_name: *const libc::c_char,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Gets the raw metadata, as stored in the HEIF file.\n\n Data in a \"mime\" item with \"content_encoding\" can be compressed.\n When `out_compression_format` is NULL, the decompressed data will be returned.\n Otherwise, the compressed data is returned and `out_compression_format` will be filled with the\n compression format.\n If the compression method is not supported, an error will be returned.\n\n It is valid to set `out_data` to NULL. In that case, only the `out_data_size` is filled.\n Note that it is inefficient to use `out_data=NULL` just to get the size of compressed data.\n In general, this should be avoided.\n\n If there is no data assigned to the item or there is an error, `out_data_size` is set to zero.\n\n @param ctx the file context\n @param item_id the item identifier for the item\n @param out_compression_format how the data is compressed. If the pointer is NULL, the decompressed data will be returned.\n @param out_data the corresponding raw metadata\n @param out_data_size the size of the metadata in bytes\n @return whether the call succeeded, or there was an error"]
    pub fn heif_item_get_item_data(
        ctx: *const heif_context,
        item_id: heif_item_id,
        out_compression_format: *mut heif_metadata_compression,
        out_data: *mut *mut u8,
        out_data_size: *mut usize,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Free the item data.\n\n This is used to free memory associated with the data returned by\n {@link heif_item_get_item_data} in 'out_data' and set the pointer to NULL.\n\n @param ctx the file context\n @param item_data the data to free"]
    pub fn heif_release_item_data(ctx: *const heif_context, item_data: *mut *mut u8);
}
unsafe extern "C" {
    #[doc = " Get the item ids that reference the given item.\n\n @param ctx the file context.\n @param from_item_id the item identifier for the item.\n @param index the index of the reference to get.\n @param out_reference_type_4cc The 4cc of the reference. (e.g dimg, thmb, cdsc, or auxl)\n @param out_references_to the item references. Use {@link heif_release_item_references} to free the memory.\n @return the number of items that reference the given item. Returns 0 if the index exceeds the number of references."]
    pub fn heif_context_get_item_references(
        ctx: *const heif_context,
        from_item_id: heif_item_id,
        index: libc::c_int,
        out_reference_type_4cc: *mut u32,
        out_references_to: *mut *mut heif_item_id,
    ) -> usize;
}
unsafe extern "C" {
    pub fn heif_release_item_references(
        ctx: *const heif_context,
        references: *mut *mut heif_item_id,
    );
}
unsafe extern "C" {
    pub fn heif_context_add_item_reference(
        ctx: *mut heif_context,
        reference_type: u32,
        from_item: heif_item_id,
        to_item: heif_item_id,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_context_add_item_references(
        ctx: *mut heif_context,
        reference_type: u32,
        from_item: heif_item_id,
        to_item: *const heif_item_id,
        num_to_items: libc::c_int,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " ------------------------- adding new items -------------------------"]
    pub fn heif_context_add_item(
        ctx: *mut heif_context,
        item_type: *const libc::c_char,
        data: *const libc::c_void,
        size: libc::c_int,
        out_item_id: *mut heif_item_id,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_context_add_mime_item(
        ctx: *mut heif_context,
        content_type: *const libc::c_char,
        content_encoding: heif_metadata_compression,
        data: *const libc::c_void,
        size: libc::c_int,
        out_item_id: *mut heif_item_id,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_context_add_precompressed_mime_item(
        ctx: *mut heif_context,
        content_type: *const libc::c_char,
        content_encoding: *const libc::c_char,
        data: *const libc::c_void,
        size: libc::c_int,
        out_item_id: *mut heif_item_id,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_context_add_uri_item(
        ctx: *mut heif_context,
        item_uri_type: *const libc::c_char,
        data: *const libc::c_void,
        size: libc::c_int,
        out_item_id: *mut heif_item_id,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Check whether there is an image sequence in the HEIF file.\n\n @return A boolean whether there is an image sequence in the HEIF file."]
    pub fn heif_context_has_sequence(arg1: *const heif_context) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the timescale (clock ticks per second) for timing values in the sequence.\n\n @note Each track may have its independent timescale.\n\n @return Clock ticks per second. Returns 0 if there is no sequence in the file."]
    pub fn heif_context_get_sequence_timescale(arg1: *const heif_context) -> u32;
}
unsafe extern "C" {
    #[doc = " Get the total duration of the sequence in timescale clock ticks.\n Use `heif_context_get_sequence_timescale()` to get the clock ticks per second.\n\n @return Sequence duration in clock ticks. Returns 0 if there is no sequence in the file."]
    pub fn heif_context_get_sequence_duration(arg1: *const heif_context) -> u64;
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_track {
    _unused: [u8; 0],
}
unsafe extern "C" {
    #[doc = " Free a `heif_track` object received from libheif.\n Passing NULL is ok."]
    pub fn heif_track_release(arg1: *mut heif_track);
}
unsafe extern "C" {
    #[doc = " Get the number of tracks in the HEIF file.\n\n @return Number of tracks or 0 if there is no sequence in the HEIF file."]
    pub fn heif_context_number_of_sequence_tracks(arg1: *const heif_context) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Returns the IDs for each of the tracks stored in the HEIF file.\n The output array must have heif_context_number_of_sequence_tracks() entries."]
    pub fn heif_context_get_track_ids(
        ctx: *const heif_context,
        out_track_id_array: *mut [u32; 0usize],
    );
}
unsafe extern "C" {
    #[doc = " Get the ID of the passed track.\n The track ID will never be 0."]
    pub fn heif_track_get_id(track: *const heif_track) -> u32;
}
unsafe extern "C" {
    #[doc = " Get the heif_track object for the given track ID.\n If you pass `id=0`, the first visual track will be returned.\n If there is no track with the given ID or if 0 is passed and there is no visual track, NULL will be returned.\n\n @note Tracks never have a zero ID. This is why we can use this as a special value to find the first visual track.\n\n @param id Track id or 0 for the first visual track.\n @return heif_track object. You must free this after use.\n/\n// Use id=0 for the first visual track."]
    pub fn heif_context_get_track(arg1: *const heif_context, id: u32) -> *mut heif_track;
}
pub type heif_track_type = u32;
pub const heif_track_type_4cc_heif_track_type_video: heif_track_type_4cc = 1986618469;
pub const heif_track_type_4cc_heif_track_type_image_sequence: heif_track_type_4cc = 1885954932;
pub const heif_track_type_4cc_heif_track_type_metadata: heif_track_type_4cc = 1835365473;
pub type heif_track_type_4cc = libc::c_uint;
unsafe extern "C" {
    #[doc = " Get the four-cc track handler type.\n Typical codes are \"vide\" for video sequences, \"pict\" for image sequences, \"meta\" for metadata tracks.\n These are defined in heif_track_type_4cc, but files may also contain other types.\n\n @return four-cc handler type"]
    pub fn heif_track_get_track_handler_type(arg1: *const heif_track) -> heif_track_type;
}
unsafe extern "C" {
    #[doc = " Get the timescale (clock ticks per second) for this track.\n Note that this can be different from the timescale used at sequence level.\n\n @return clock ticks per second"]
    pub fn heif_track_get_timescale(arg1: *const heif_track) -> u32;
}
unsafe extern "C" {
    #[doc = " Get the image resolution of the track.\n If the passed track is no visual track, an error is returned."]
    pub fn heif_track_get_image_resolution(
        arg1: *const heif_track,
        out_width: *mut u16,
        out_height: *mut u16,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Decode the next image in the passed sequence track.\n If there is no more image in the sequence, `heif_error_End_of_sequence` is returned.\n The parameters `colorspace`, `chroma` and `options` are similar to heif_decode_image().\n If you want to let libheif decide the output colorspace and chroma, set these parameters\n to heif_colorspace_undefined / heif_chroma_undefined. Usually, libheif will return the\n image in the input colorspace, but it may also modify it for example when it has to rotate the image.\n If you want to get the image in a specific colorspace/chroma format, you can specify this\n and libheif will convert the image to match this format."]
    pub fn heif_track_decode_next_image(
        track: *mut heif_track,
        out_img: *mut *mut heif_image,
        colorspace: heif_colorspace,
        chroma: heif_chroma,
        options: *const heif_decoding_options,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the image display duration in clock ticks of this track.\n Make sure to use the timescale of the track and not the timescale of the total sequence."]
    pub fn heif_image_get_duration(arg1: *const heif_image) -> u32;
}
unsafe extern "C" {
    #[doc = " Get the \"sample entry type\" of the first sample sample cluster in the track.\n In the case of metadata tracks, this will usually be \"urim\" for \"URI Meta Sample Entry\".\n The exact URI can then be obtained with 'heif_track_get_urim_sample_entry_uri_of_first_cluster'."]
    pub fn heif_track_get_sample_entry_type_of_first_cluster(arg1: *const heif_track) -> u32;
}
unsafe extern "C" {
    #[doc = " Get the URI of the first sample cluster in an 'urim' track.\n Only call this for tracks with 'urim' sample entry types. It will return an error otherwise.\n\n @param out_uri A string with the URI will be returned. Free this string with `heif_string_release()`."]
    pub fn heif_track_get_urim_sample_entry_uri_of_first_cluster(
        track: *const heif_track,
        out_uri: *mut *const libc::c_char,
    ) -> heif_error;
}
#[repr(C)]
#[derive(Debug)]
pub struct heif_raw_sequence_sample {
    _unused: [u8; 0],
}
unsafe extern "C" {
    #[doc = " Get the next raw sample from the (metadata) sequence track.\n You have to free the returned sample with heif_raw_sequence_sample_release()."]
    pub fn heif_track_get_next_raw_sequence_sample(
        arg1: *mut heif_track,
        out_sample: *mut *mut heif_raw_sequence_sample,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Release a heif_raw_sequence_sample object.\n You may pass NULL."]
    pub fn heif_raw_sequence_sample_release(arg1: *mut heif_raw_sequence_sample);
}
unsafe extern "C" {
    #[doc = " Get a pointer to the data of the (metadata) sample.\n The data pointer stays valid until the heif_raw_sequence_sample object is released.\n\n @param out_array_size Size of the returned array (may be NULL)."]
    pub fn heif_raw_sequence_sample_get_data(
        arg1: *const heif_raw_sequence_sample,
        out_array_size: *mut usize,
    ) -> *const u8;
}
unsafe extern "C" {
    #[doc = " Return the size of the raw data contained in the sample.\n This is the same as returned through the 'out_array_size' parameter of 'heif_raw_sequence_sample_get_data()'."]
    pub fn heif_raw_sequence_sample_get_data_size(arg1: *const heif_raw_sequence_sample) -> usize;
}
unsafe extern "C" {
    #[doc = " Get the sample duration in clock ticks of this track.\n Make sure to use the timescale of the track and not the timescale of the total sequence."]
    pub fn heif_raw_sequence_sample_get_duration(arg1: *const heif_raw_sequence_sample) -> u32;
}
unsafe extern "C" {
    #[doc = " Set an independent global timescale for the sequence.\n If no timescale is set with this function, the timescale of the first track will be used."]
    pub fn heif_context_set_sequence_timescale(arg1: *mut heif_context, timescale: u32);
}
pub const heif_sample_aux_info_presence_heif_sample_aux_info_presence_none:
    heif_sample_aux_info_presence = 0;
pub const heif_sample_aux_info_presence_heif_sample_aux_info_presence_optional:
    heif_sample_aux_info_presence = 1;
pub const heif_sample_aux_info_presence_heif_sample_aux_info_presence_mandatory:
    heif_sample_aux_info_presence = 2;
#[doc = " Specifies whether a 'sample auxiliary info' is stored with the samples.\n The difference between `heif_sample_aux_info_presence_optional` and `heif_sample_aux_info_presence_mandatory`\n is that `heif_sample_aux_info_presence_mandatory` will throw an error if the data is missing when writing a sample."]
pub type heif_sample_aux_info_presence = libc::c_uint;
#[repr(C)]
#[derive(Debug)]
pub struct heif_track_options {
    _unused: [u8; 0],
}
unsafe extern "C" {
    #[doc = " Allocate track options object that is required to set options for a new track.\n When you create a new track, you can also pass a NULL heif_track_options pointer, in which case the default options are used."]
    pub fn heif_track_options_alloc() -> *mut heif_track_options;
}
unsafe extern "C" {
    pub fn heif_track_options_release(arg1: *mut heif_track_options);
}
unsafe extern "C" {
    #[doc = " Set the track specific timescale. This is the number of clock ticks per second.\n The default is 90,000 Hz.\n @param timescale"]
    pub fn heif_track_options_set_timescale(arg1: *mut heif_track_options, timescale: u32);
}
unsafe extern "C" {
    #[doc = " Set whether the aux-info data should be stored interleaved with the sequence samples.\n Default is: false.\n\n If 'true', the aux_info data blocks will be interleaved with the compressed image.\n This has the advantage that the aux_info is localized near the image data.\n\n If 'false', all aux_info will be written as one block after the compressed image data.\n This has the advantage that no aux_info offsets have to be written."]
    pub fn heif_track_options_set_interleaved_sample_aux_infos(
        arg1: *mut heif_track_options,
        interleaved_flag: libc::c_int,
    );
}
unsafe extern "C" {
    pub fn heif_track_options_enable_sample_tai_timestamps(
        arg1: *mut heif_track_options,
        arg2: *const heif_tai_clock_info,
        arg3: heif_sample_aux_info_presence,
    ) -> heif_error;
}
unsafe extern "C" {
    pub fn heif_track_options_enable_sample_gimi_content_ids(
        arg1: *mut heif_track_options,
        arg2: heif_sample_aux_info_presence,
    );
}
unsafe extern "C" {
    #[doc = " Set the GIMI format track ID string. If NULL is passed, no track ID is saved.\n @param track_id"]
    pub fn heif_track_options_set_gimi_track_id(
        arg1: *mut heif_track_options,
        track_id: *const libc::c_char,
    );
}
#[doc = " This structure is for future use. It is not defined yet."]
#[repr(C)]
#[derive(Debug)]
pub struct heif_sequence_encoding_options {
    pub version: u8,
    #[doc = " Set this to the NCLX parameters to be used in the output images or set to NULL\n when the same parameters as in the input images should be used."]
    pub output_nclx_profile: *const heif_color_profile_nclx,
    pub color_conversion_options: heif_color_conversion_options,
}
unsafe extern "C" {
    pub fn heif_sequence_encoding_options_alloc() -> *mut heif_sequence_encoding_options;
}
unsafe extern "C" {
    pub fn heif_sequence_encoding_options_release(arg1: *mut heif_sequence_encoding_options);
}
unsafe extern "C" {
    #[doc = " Add a visual track to the sequence.\n The track ID is assigned automatically.\n\n @param width Image resolution width\n @param height Image resolution height\n @param track_type Has to be heif_track_type_video or heif_track_type_image_sequence\n @param track_options Optional track creation options. If NULL, default options will be used.\n @param encoding_options Options for sequence encoding. If NULL, default options will be used.\n @param out_track Output parameter to receive the track object for the just created track.\n @return"]
    pub fn heif_context_add_visual_sequence_track(
        arg1: *mut heif_context,
        width: u16,
        height: u16,
        track_type: heif_track_type,
        track_options: *const heif_track_options,
        encoding_options: *const heif_sequence_encoding_options,
        out_track: *mut *mut heif_track,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Set the image display duration in the track's timescale units."]
    pub fn heif_image_set_duration(arg1: *mut heif_image, duration: u32);
}
unsafe extern "C" {
    #[doc = " Encode the image into a visual track.\n If the passed track is no visual track, an error will be returned.\n\n @param sequence_encoding_options Options for sequence encoding. If NULL, default options will be used."]
    pub fn heif_track_encode_sequence_image(
        arg1: *mut heif_track,
        image: *const heif_image,
        encoder: *mut heif_encoder,
        sequence_encoding_options: *const heif_sequence_encoding_options,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Add a metadata track.\n The track content type is specified by the 'uri' parameter.\n This will be created as a 'urim' \"URI Meta Sample Entry\".\n\n @param options Optional track creation options. If NULL, default options will be used."]
    pub fn heif_context_add_uri_metadata_sequence_track(
        arg1: *mut heif_context,
        uri: *const libc::c_char,
        options: *const heif_track_options,
        out_track: *mut *mut heif_track,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Allocate a new heif_raw_sequence_sample object.\n Free with heif_raw_sequence_sample_release()."]
    pub fn heif_raw_sequence_sample_alloc() -> *mut heif_raw_sequence_sample;
}
unsafe extern "C" {
    #[doc = " Set the raw sequence sample data."]
    pub fn heif_raw_sequence_sample_set_data(
        arg1: *mut heif_raw_sequence_sample,
        data: *const u8,
        size: usize,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Set the sample duration in track timescale units."]
    pub fn heif_raw_sequence_sample_set_duration(
        arg1: *mut heif_raw_sequence_sample,
        duration: u32,
    );
}
unsafe extern "C" {
    #[doc = " Add a raw sequence sample (usually a metadata sample) to the (metadata) track."]
    pub fn heif_track_add_raw_sequence_sample(
        arg1: *mut heif_track,
        arg2: *const heif_raw_sequence_sample,
    ) -> heif_error;
}
#[doc = " Contains the type of sample auxiliary data assigned to the track samples."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_sample_aux_info_type {
    pub type_: u32,
    pub parameter: u32,
}
unsafe extern "C" {
    #[doc = " Returns how many different types of sample auxiliary data units are assigned to this track's samples."]
    pub fn heif_track_get_number_of_sample_aux_infos(arg1: *const heif_track) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get get the list of sample auxiliary data types used in the track.\n The passed array has to have heif_track_get_number_of_sample_aux_infos() entries."]
    pub fn heif_track_get_sample_aux_info_types(
        arg1: *const heif_track,
        out_types: *mut [heif_sample_aux_info_type; 0usize],
    );
}
unsafe extern "C" {
    #[doc = " Get the GIMI content ID for the track (as a whole).\n If there is no content ID, nullptr is returned.\n\n @return The returned string has to be released with `heif_string_release()`."]
    pub fn heif_track_get_gimi_track_content_id(arg1: *const heif_track) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Get the GIMI content ID stored in the image sample.\n If there is no content ID, NULL is returned.\n @return"]
    pub fn heif_image_get_gimi_sample_content_id(arg1: *const heif_image) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Get the GIMI content ID stored in the metadata sample.\n If there is no content ID, NULL is returned.\n @return"]
    pub fn heif_raw_sequence_sample_get_gimi_sample_content_id(
        arg1: *const heif_raw_sequence_sample,
    ) -> *const libc::c_char;
}
unsafe extern "C" {
    #[doc = " Set the GIMI content ID for an image sample. It will be stored as SAI.\n When passing NULL, a previously set ID will be removed."]
    pub fn heif_image_set_gimi_sample_content_id(
        arg1: *mut heif_image,
        contentID: *const libc::c_char,
    );
}
unsafe extern "C" {
    #[doc = " Set the GIMI content ID for a (metadata) sample. It will be stored as SAI.\n When passing NULL, a previously set ID will be removed."]
    pub fn heif_raw_sequence_sample_set_gimi_sample_content_id(
        arg1: *mut heif_raw_sequence_sample,
        contentID: *const libc::c_char,
    );
}
unsafe extern "C" {
    #[doc = " Returns whether the raw (metadata) sample has a TAI timestamp attached to it (stored as SAI).\n\n @return boolean flag whether a TAI exists for this sample."]
    pub fn heif_raw_sequence_sample_has_tai_timestamp(
        arg1: *const heif_raw_sequence_sample,
    ) -> libc::c_int;
}
unsafe extern "C" {
    #[doc = " Get the TAI timestamp of the (metadata) sample.\n If there is no timestamp assigned to it, NULL will be returned.\n\n @note You should NOT free the returned timestamp with 'heif_tai_timestamp_packet_release()'.\n       The returned struct stays valid until the heif_raw_sequence_sample is released."]
    pub fn heif_raw_sequence_sample_get_tai_timestamp(
        arg1: *const heif_raw_sequence_sample,
    ) -> *const heif_tai_timestamp_packet;
}
unsafe extern "C" {
    #[doc = " Set the TAI timestamp for a raw sequence sample.\n The timestamp will be copied, you can release it after calling this function."]
    pub fn heif_raw_sequence_sample_set_tai_timestamp(
        sample: *mut heif_raw_sequence_sample,
        timestamp: *const heif_tai_timestamp_packet,
    );
}
unsafe extern "C" {
    #[doc = " Returns the TAI clock info of the track.\n If there is no TAI clock info, NULL is returned.\n You should NOT free the returned heif_tai_clock_info.\n The structure stays valid until the heif_track object is released."]
    pub fn heif_track_get_tai_clock_info_of_first_cluster(
        arg1: *mut heif_track,
    ) -> *const heif_tai_clock_info;
}
#[doc = " track_description"]
pub const heif_track_reference_type_heif_track_reference_type_description:
    heif_track_reference_type = 1667527523;
#[doc = " thumbnails"]
pub const heif_track_reference_type_heif_track_reference_type_thumbnails:
    heif_track_reference_type = 1953000802;
#[doc = " auxiliary data (e.g. depth maps or alpha channel)"]
pub const heif_track_reference_type_heif_track_reference_type_auxiliary: heif_track_reference_type =
    1635088492;
#[doc = " --- track references"]
pub type heif_track_reference_type = libc::c_uint;
unsafe extern "C" {
    #[doc = " Add a reference between tracks.\n 'reference_type' can be one of the four-cc codes listed in heif_track_reference_type or any other type."]
    pub fn heif_track_add_reference_to_track(
        arg1: *mut heif_track,
        reference_type: u32,
        to_track: *const heif_track,
    );
}
unsafe extern "C" {
    #[doc = " Return the number of different reference types used in this track's tref box."]
    pub fn heif_track_get_number_of_track_reference_types(arg1: *const heif_track) -> usize;
}
unsafe extern "C" {
    #[doc = " List the reference types used in this track.\n The passed array must have heif_track_get_number_of_track_reference_types() entries."]
    pub fn heif_track_get_track_reference_types(
        arg1: *const heif_track,
        out_reference_types: *mut [u32; 0usize],
    );
}
unsafe extern "C" {
    #[doc = " Get the number of references of the passed type."]
    pub fn heif_track_get_number_of_track_reference_of_type(
        arg1: *const heif_track,
        reference_type: u32,
    ) -> usize;
}
unsafe extern "C" {
    #[doc = " List the track ids this track points to with the passed reference type.\n The passed array must have heif_track_get_number_of_track_reference_of_type() entries."]
    pub fn heif_track_get_references_from_track(
        arg1: *const heif_track,
        reference_type: u32,
        out_to_track_id: *mut [u32; 0usize],
    ) -> usize;
}
unsafe extern "C" {
    #[doc = " Find tracks that are referring to the current track through the passed reference_type.\n The found track IDs will be filled into the passed array, but no more than `array_size` entries will be filled.\n\n @return number of tracks found. If this is equal to 'array_size', you should ask again with a larger array size to be sure you got all tracks."]
    pub fn heif_track_find_referring_tracks(
        arg1: *const heif_track,
        reference_type: u32,
        out_track_id: *mut [u32; 0usize],
        array_size: usize,
    ) -> usize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_tai_clock_info {
    pub version: u8,
    #[doc = " Standard deviation for timestamp generation process.\n May be `heif_tai_clock_info_time_uncertainty_unknown` if unknown."]
    pub time_uncertainty: u64,
    #[doc = " Receptor clock resolution in nanoseconds."]
    pub clock_resolution: u32,
    #[doc = " Clock drift rate in picoseconds/second when synchronization is stopped.\n Maybe `heif_tai_clock_info_clock_drift_rate_unknown` if unknown."]
    pub clock_drift_rate: i32,
    #[doc = " Whether clock is synchronized to an atomic source,\n see the clock_type defines below."]
    pub clock_type: u8,
}
unsafe extern "C" {
    #[doc = " Allocate a new heif_tai_clock_info object and initialize with default values."]
    pub fn heif_tai_clock_info_alloc() -> *mut heif_tai_clock_info;
}
unsafe extern "C" {
    #[doc = " Copies the source object into the destination object.\n Only the fields that are present in both objects are copied.\n The version property has to be set in both structs."]
    pub fn heif_tai_clock_info_copy(dst: *mut heif_tai_clock_info, src: *const heif_tai_clock_info);
}
unsafe extern "C" {
    pub fn heif_tai_clock_info_release(clock_info: *mut heif_tai_clock_info);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct heif_tai_timestamp_packet {
    pub version: u8,
    #[doc = " number of nanoseconds since TAI epoch (1958-01-01T00:00:00.0)"]
    pub tai_timestamp: u64,
    #[doc = " bool"]
    pub synchronization_state: u8,
    #[doc = " bool"]
    pub timestamp_generation_failure: u8,
    #[doc = " bool"]
    pub timestamp_is_modified: u8,
}
unsafe extern "C" {
    #[doc = " Allocate a new heif_tai_timestamp_packet object and initialize with default values."]
    pub fn heif_tai_timestamp_packet_alloc() -> *mut heif_tai_timestamp_packet;
}
unsafe extern "C" {
    #[doc = " Copies the source object into the destination object.\n Only the fields that are present in both objects are copied.\n The version property has to be set in both structs."]
    pub fn heif_tai_timestamp_packet_copy(
        dst: *mut heif_tai_timestamp_packet,
        src: *const heif_tai_timestamp_packet,
    );
}
unsafe extern "C" {
    pub fn heif_tai_timestamp_packet_release(arg1: *mut heif_tai_timestamp_packet);
}
unsafe extern "C" {
    #[doc = " Creates a new clock info property if it doesn't exist yet.\n You can only add one tai_clock_info to an image.\n\n @param clock_info The TAI clock info to set for the item. This object will be copied.\n @param out_optional_propertyId Output parameter for the property ID of the tai_clock_info.\n                                This parameter may be NULL if the info is not required."]
    pub fn heif_item_set_property_tai_clock_info(
        ctx: *mut heif_context,
        itemId: heif_item_id,
        clock_info: *const heif_tai_clock_info,
        out_optional_propertyId: *mut heif_property_id,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the heif_tai_clock_info attached to the item.\n This function allocates a new heif_tai_clock_info and returns it through out_clock.\n\n @param out_clock This parameter must not be nullptr. The object returned through this parameter must\n                  be released with heif_tai_clock_info_release().\n                  If no tai_clock_info property exists for the item, out_clock is set to NULL and\n                  no error is returned."]
    pub fn heif_item_get_property_tai_clock_info(
        ctx: *const heif_context,
        itemId: heif_item_id,
        out_clock: *mut *mut heif_tai_clock_info,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Creates a new TAI timestamp property if it doesn't exist yet.\n You can only add one tai_timestamp to an image.\n\n @param timestamp The TAI timestamp to set for the item. This object will be copied.\n @param out_optional_propertyId Output parameter for the property ID of the TAI timestamp.\n                                This parameter may be NULL if the info is not required."]
    pub fn heif_item_set_property_tai_timestamp(
        ctx: *mut heif_context,
        itemId: heif_item_id,
        timestamp: *const heif_tai_timestamp_packet,
        out_optional_propertyId: *mut heif_property_id,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the heif_tai_timestamp_packet attached to the item.\n This function allocates a new heif_tai_timestamp_packet and returns it through out_timestamp.\n\n @param out_timestamp This parameter must not be NULL. The object returned through this parameter must\n                  be released with heif_tai_timestamp_packet_release().\n                  If no tai_timestamp_packet property exists for the item, *out_timestamp is set to NULL and\n                  no error is returned."]
    pub fn heif_item_get_property_tai_timestamp(
        ctx: *const heif_context,
        itemId: heif_item_id,
        out_timestamp: *mut *mut heif_tai_timestamp_packet,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Attach a TAI timestamp to the image.\n The main use of this function is for image sequences, but it can also be used for still images.\n If used for still images, note that you also have to set the heif_tai_clock_info to the image item\n through heif_item_set_property_tai_clock_info().\n\n @param timestamp The TAI timestamp to set to the image. This object will be copied."]
    pub fn heif_image_set_tai_timestamp(
        img: *mut heif_image,
        timestamp: *const heif_tai_timestamp_packet,
    ) -> heif_error;
}
unsafe extern "C" {
    #[doc = " Get the heif_tai_timestamp_packet attached to the image.\n The main use of this function is for image sequences, but it can also be used for still images.\n This function allocates a new heif_tai_timestamp_packet and returns it through out_timestamp.\n\n @param out_timestamp This parameter must not be NULL. The object returned through this parameter must\n                  be released with heif_tai_timestamp_packet_release().\n                  If no tai_timestamp_packet property exists for the image, *out_timestamp is set to NULL and\n                  no error is returned."]
    pub fn heif_image_get_tai_timestamp(
        img: *const heif_image,
        out_timestamp: *mut *mut heif_tai_timestamp_packet,
    ) -> heif_error;
}
