# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class ApiReleaseContract(Resource):
    """ApiRelease details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param api_id: Identifier of the API the release belongs to.
    :type api_id: str
    :ivar created_date_time: The time the API was released. The date conforms
     to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
     standard.
    :vartype created_date_time: datetime
    :ivar updated_date_time: The time the API release was updated.
    :vartype updated_date_time: datetime
    :param notes: Release Notes
    :type notes: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date_time': {'readonly': True},
        'updated_date_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'api_id': {'key': 'properties.apiId', 'type': 'str'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
        'updated_date_time': {'key': 'properties.updatedDateTime', 'type': 'iso-8601'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
    }

    def __init__(self, *, api_id: str=None, notes: str=None, **kwargs) -> None:
        super(ApiReleaseContract, self).__init__(**kwargs)
        self.api_id = api_id
        self.created_date_time = None
        self.updated_date_time = None
        self.notes = notes
