# Debpkg

A simple, colorful command-line tool for downloading and installing Debian packages from URLs.

## Features

- 🌈 **Colorful CLI** - Beautiful, modern interface with progress bars
- 📦 **Simple Installation** - Download and install .deb packages in one command
- 🔒 **Safe Operations** - Proper permission checking and error handling
- ⚡ **Fast Downloads** - Progress bars with speed indicators
- 🎯 **User Friendly** - Clear error messages and helpful output

## Usage

### Basic Commands

```bash
# Install a .deb package from URL
debpkg install https://example.com/package.deb

# Show help
debpkg --help

# Show version
debpkg --version
```

## Development

### Building

```bash
# Build only
make build

# Build and install
make install

# Clean build artifacts
make clean
```

### Testing

```bash
# Run tests
make test
```

### Project Structure

```
debpkg/
├── cmd/                    # CLI command definitions
│   ├── root.go            # Root command and shared styles
│   └── install.go         # Install command implementation
├── internal/              # Internal packages
│   ├── download/          # File download functionality
│   ├── apt/              # APT package manager integration
│   └── ui/               # UI components and styling
├── main.go               # Application entry point
├── go.mod                # Go module definition
├── Makefile              # Build automation
└── README.md             # This file
```

### Dependencies

The project uses these key dependencies:

- **Cobra** - CLI framework for command structure and parsing
- **Lipgloss** - Styling and colors for beautiful terminal output
- **Progressbar** - Download progress indication


## License

[MIT (Expat)](https://salsa.debian.org/otto/debpkg/-/raw/main//LICENSE)
