# Copyright 2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_MODULE_TYPE="dependencies"
TRINITY_MODULE_NAME="$PN"
inherit trinity-base-2 cmake

DESCRIPTION="The TQt Cryptographic Architecture library"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="LGPL-2"
SLOT="0"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="+ssl"

DEPEND="
	~dev-tqt/tqt-${PV}
	~dev-tqt/tqtinterface-${PV}
	ssl? ( dev-libs/openssl )
"
RDEPEND="${DEPEND}"

src_configure() {
	local mycmakeargs=(
		-DBUILD_TQCA=ON
		-DBUILD_TQCA_TLS=$(usex ssl)
	)

	cmake_src_configure
}
