
#include <stdio.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include "core/polkit-tqt-details.h"

#define TEST_PASSED 0
#define TEST_FAILED 1

using namespace PolkitTQt;

int main(void)
{
  Details details;
  details.insert("1", "aaa");
  details.insert("2", "bbb");
  details.insert("3", "ccc");
  details.insert("4", "ddd");

  if (details.lookup("1") != TQString("aaa"))
  {
    return TEST_FAILED;
  }
  if (details.lookup("2") != TQString("bbb"))
  {
    return TEST_FAILED;
  }
  if (details.lookup("3") != TQString("ccc"))
  {
    return TEST_FAILED;
  }
  if (details.lookup("4") != TQString("ddd"))
  {
    return TEST_FAILED;
  }

  TQStringList list = details.keys();
  if (!list.contains("1"))
  {
    return TEST_FAILED;
  }
  if (!list.contains("2"))
  {
    return TEST_FAILED;
  }
  if (!list.contains("3"))
  {
    return TEST_FAILED;
  }
  if (!list.contains("4"))
  {
    return TEST_FAILED;
  }

  return TEST_PASSED;
}
