/* This file is part of the KDE project
   Copyright (C) 2003 Alexander Dymo <cloudtemple@mksat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include <klineedit.h>
#include <tdelistview.h>
#include <tdecompletionbox.h>
#include <tqheader.h>
#include <tqmap.h>

#include "kcomboview.h"


KComboView::KComboView( bool rw, int defaultWidth, TQWidget* parent, const char* name , CustomCompleter* comp)
    :QComboView(rw, parent, name),  m_comp( comp ), m_defaultWidth(defaultWidth)
{
    if (rw)
    {
        KLineEdit *ed = new KLineEdit(this, "combo edit");
        ed->setCompletionMode(TDEGlobalSettings::CompletionPopup);
        ed->setCompletionObject(m_comp);
        ed->completionBox()->setHScrollBarMode(TQListBox::Auto);
        setLineEdit(ed);
    }
    setMinimumWidth(defaultWidth);
}

KComboView::~KComboView() {
    delete m_comp;
}

void KComboView::addItem(TQListViewItem *it)
{
    m_comp->addItem(it->text(0));
}

void KComboView::removeItem(TQListViewItem *it)
{
    if (it == currentItem())
    {
        setCurrentItem(0);
        setCurrentText(m_defaultText);
    }
    m_comp->removeItem(it->text(0));
    delete it;
}

void KComboView::renameItem(TQListViewItem *it, const TQString &newName)
{
    m_comp->removeItem(it->text(0));
    it->setText(0, newName);
    m_comp->addItem(newName);
}

void KComboView::clear( )
{
    m_comp->clear();
    QComboView::clear();

    setCurrentText(m_defaultText);
}

int KComboView::defaultWidth( )
{
    return m_defaultWidth;
}

void KComboView::setDefaultText( const TQString & text )
{
    m_defaultText = text;
}

void KComboView::setUpListView()
{
    TDEListView *listView = new TDEListView( this, "in-combo" );
    listView->setRootIsDecorated( false );
    listView->setAllColumnsShowFocus(true);
    listView->addColumn("");
    listView->setResizeMode(TQListView::LastColumn);

    listView->header()->hide();

    setListView(listView);
}


#include "kcomboview.moc"
