/**********************************************************************
** Copyright (C) 2000-2002 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef PALETTEEDITORADVANCEDIMPL_H
#define PALETTEEDITORADVANCEDIMPL_H

#include "paletteeditoradvanced.h"

class FormWindow;

class PaletteEditorAdvanced : public PaletteEditorAdvancedBase
{
    TQ_OBJECT
  
public:
    PaletteEditorAdvanced( FormWindow *fw, TQWidget * parent=0, const char * name=0,
			   bool modal=false, WFlags f=0 );
    ~PaletteEditorAdvanced();

    static TQPalette getPalette( bool *ok, const TQPalette &pal, BackgroundMode mode = PaletteBackground,
				TQWidget* parent = 0, const char* name = 0, FormWindow *fw = 0 );

protected slots:
    void paletteSelected(int);

    void onCentral( int );
    void onEffect( int );

    void onChooseCentralColor();
    void onChooseEffectColor();
    void onChoosePixmap();

    void onToggleBuildEffects( bool );
    void onToggleBuildInactive( bool );
    void onToggleBuildDisabled( bool );

protected:
    void mapToActiveCentralRole( const TQColor& );
    void mapToActiveEffectRole( const TQColor& );
    void mapToActivePixmapRole( const TQPixmap& );
    void mapToInactiveCentralRole( const TQColor& );
    void mapToInactiveEffectRole( const TQColor& );
    void mapToInactivePixmapRole( const TQPixmap& );
    void mapToDisabledCentralRole( const TQColor& );
    void mapToDisabledEffectRole( const TQColor& );
    void mapToDisabledPixmapRole( const TQPixmap& );


    void buildPalette();
    void buildActiveEffect();
    void buildInactive();
    void buildInactiveEffect();
    void buildDisabled();
    void buildDisabledEffect();

private:
    void setPreviewPalette( const TQPalette& );
    void updateStyledButtons();
    void setupBackgroundMode( BackgroundMode );

    TQPalette pal() const;
    void setPal( const TQPalette& );

    TQColorGroup::ColorRole centralFromItem( int );
    TQColorGroup::ColorRole effectFromItem( int );
    TQPalette editPalette;
    TQPalette previewPalette;

    FormWindow *formWindow;

    int selectedPalette;
};

#endif
