//
//  kjots
//
//  Copyright (C) 1997 Christoph Neerfeld
//  Copyright (C) 2002, 2003 Aaron J. Seigo
//  Copyright (C) 2003 Stanislav Kljuhhin
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//

#ifndef __KJOTSEDIT_H
#define __KJOTSEDIT_H

#include <ktextedit.h>

class KFind;
class KFindDialog;
class KReplace;
class KReplaceDialog;
class TDEPopupMenu;
class KJotsPage;

class KJotsEdit : public KTextEdit
{
    TQ_OBJECT
  
    public:
        KJotsEdit (TQWidget* parent=0, const char* name=0);
        ~KJotsEdit ();

        void print(TQString title = TQString());
        void setEntry(KJotsPage*);

    signals:
        void findSuccessful();

    public slots:
        // Create the initial KFindDialog.
        void find();
        // Repeat the previous search.
        // Creates KFindDialog if needed.
        void findNext();
        // Repeat the previous search, but in the opposite direction.
        // Creates KFindDialog if needed.
        void findPrev();
        // Creates a KReplaceDialog
        void replace();

    protected slots:
        void openUrl();
        void slotFindHighlight(const TQString&, int, int);
        void slotReplaceHighlight(const TQString&, int, int);
        void slotDoFind();
        void slotDoReplace();
        void slotReplace(const TQString&, int, int, int);
        void slotReplaceNext();

    protected:
        virtual void mousePressEvent (TQMouseEvent *e);

        TDEPopupMenu *web_menu;
        KJotsPage *m_entry; //!< The entry we are editing. It needs to be kept informed.

    private:

        /*
         * Keep track of the current cursor position for find/replace
         * functionality, allowing us to increment easily.
         */
        struct CursorPosition
        {
            // Current paragraph.
            int paragraph;
            // Index from start of current paragraph.
            int paragraphIndex;
        };

        KFind          *m_find;
        KFindDialog    *m_findDialog;
        KReplace       *m_replace;
        KReplaceDialog *m_replaceDialog;

        // Maintaining two positions to allow replace while find still active.
        CursorPosition m_findCursor{0, 0};
        CursorPosition m_replaceCursor{0, 0};

        // Start and end position of selection, used to restart search with initial selection.
        CursorPosition m_selectionStart{0, 0};
        CursorPosition m_selectionEnd{0, 0};

        // Setup for m_findCursor/m_replaceCursor with m_find/m_replace
        void setupCursor(CursorPosition*, const KFind*);
};

#endif // __KJOTSEDIT_H
/* ex: set tabstop=4 softtabstop=4 shiftwidth=4 expandtab: */
