/* posix-util.c - Utility functions for Posix
   Copyright (C) 2001 Werner Koch (dd9jn)
   Copyright (C) 2001, 2002, 2004 g10 Code GmbH

   This file is part of GPGME.
 
   GPGME is free software; you can redistribute it and/or modify it
   under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.
   
   GPGME is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   
   You should have received a copy of the GNU Lesser General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA.  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "util.h"

const char *
_gpgme_get_gpg_path (void)
{
#ifdef GPG_PATH
  return GPG_PATH;
#else
  return NULL;
#endif
}

const char *
_gpgme_get_gpgsm_path (void)
{
#ifdef GPGSM_PATH
  return GPGSM_PATH;
#else
  return NULL;
#endif
}

/* See w32-util.c */
int
_gpgme_get_conf_int (const char *key, int *value)
{
  return 0;
}
