#ifndef VNCVIEWER_H
#define VNCVIEWER_H
/*
 *  Copyright (C) 2000, 2001 Const Kaplinsky.  All Rights Reserved.
 *  Copyright (C) 2000 Tridia Corporation.  All Rights Reserved.
 *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 *  USA.
 */

/*
 * vncviewer.h
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/keysym.h>
#include <X11/Xatom.h>
#include <X11/Xmu/StdSel.h>

#if(defined __cplusplus)
extern "C"
{
#endif

#include "rfb/rfbclient.h"
#include "rfb/rfbproto.h"

/** kvncview.cpp **/

extern AppData appData;

extern Display* dpy;
extern const char *vncServerHost;
extern int vncServerPort;

extern int isQuitFlagSet();
extern int getPassword(char *passwd, int pwlen);
extern void DrawScreenRegion(int x, int y, int width, int height);
extern void DrawAnyScreenRegionX11Thread(int x, int y, int width, int height);
extern void LockFramebuffer();
extern void UnlockFramebuffer();
extern void EnableClientCursor(int state);
extern void beep();
extern void newServerCut(char *bytes, int len);
extern void postMouseEvent(int x, int y, int buttonMask);

#if(defined __cplusplus)
}
#endif
#endif
