/*
    kircmessageredirector.h - IRC Client

    Copyright (c) 2004      by Michel Hermier <michel.hermier@wanadoo.fr>

    Kopete    (c) 2004      by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KIRC_MESSAGEREDIRECTOR_H
#define KIRC_MESSAGEREDIRECTOR_H

#include <tqobject.h>
#include <tqstring.h>

namespace KIRC
{

class Engine;

class Message;

class MessageRedirector
	: public TQObject
{
	TQ_OBJECT
  

public:
	enum {
		Unknown = -1,
		Unlimited = -2
	};

	MessageRedirector(KIRC::Engine *engine,
		int argsSize_min = KIRC::MessageRedirector::Unknown,
		int argsSize_max = KIRC::MessageRedirector::Unknown,
		const TQString &helpMessage = TQString());

	/**
	 * Connects the given object member signal/slot to this message redirector.
	 * The member signal slot should be looking like:
	 * TQ_SIGNAL(mysignal(KIRC::Message &msg))
	 * or
	 * TQ_SIGNAL(myslot(KIRC::Message &msg))
	 */
	bool connect(TQObject *object, const char *member);

	/**
	 * Attempt to send the message.
	 * @return a not empty TQStringList on errors or no slots connected.
	 * 	The returned string list contains all the errors.
	 */
	TQStringList operator()(KIRC::Message &msg);

	void error(TQString &errorMessage);

	TQString helpMessage();

signals:
	void redirect(KIRC::Message &);

private:
	/**
	 * Check that the given message as the correct number of args
	 * and do some message format checks.
	 */
	bool checkValidity(const KIRC::Message &msg);

	TQStringList m_errors;

	int m_argsSize_min;
	int m_argsSize_max;
	TQString m_helpMessage;
};

}

#endif
