/***************************************************************************
*                                droptarget.cpp
*                             -------------------
*
*    Revision     : $Id$
*    begin        : Tue Jan 29 2002
*    copyright    : (C) 2002 by Patrick Charbonnier
*                 : Based On Caitoo v.0.7.3 (c) 1998 - 2000, Matej Koss
*    email        : pch@freeshell.org
*
****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 ***************************************************************************/

#include <tqpainter.h>

#include <tdeaction.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kiconloader.h>
#include <tdeglobalsettings.h>
#include <tdemainwindow.h>
#include <twin.h>
#include <tdelocale.h>
#include <tdepopupmenu.h>
#include <kurldrag.h>

#include "tdemainwidget.h"
#include <tqcursor.h>
#ifdef TQ_WS_X11
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/extensions/shape.h>
#undef Bool
#undef Status
#endif
#include "settings.h"
#include "droptarget.h"

DropTarget::DropTarget(TDEMainWindow * mainWin):TQWidget()
{
    int x = ksettings.dropPosition.x();
    int y = ksettings.dropPosition.y();
    
    TQRect desk = TDEGlobalSettings::desktopGeometry(this);
    TQPixmap bgnd = UserIcon( "target" );

    if (x != -1 &&
        x >= desk.left() && y >= desk.top() &&
        (x + bgnd.width()) <= desk.right() &&
        (y + bgnd.height()) <= desk.bottom() )
    {
        move(ksettings.dropPosition);
        resize(bgnd.width(), bgnd.height());
        KWin::setState(winId(), ksettings.dropState);
    }
    else
    {
        setGeometry(desk.x()+200, desk.y()+200, bgnd.width(), bgnd.height());
        KWin::setState(winId(), NET::SkipTaskbar | NET::StaysOnTop);
    }

    b_sticky = ksettings.dropState & NET::Sticky;

    // setup pixmaps

    if (!bgnd.mask())
        kdError(5001) << "Drop target pixmap has no mask!\n";
    else
        mask = *bgnd.mask();

    setBackgroundPixmap( bgnd );

    // popup menu for right mouse button
    popupMenu = new TDEPopupMenu();
    popupMenu->insertTitle(kapp->caption());
    popupMenu->setCheckable(true);

    pop_Max = popupMenu->insertItem(i18n("Maximize"), this, TQ_SLOT(toggleMinimizeRestore()));
    pop_Min = popupMenu->insertItem(i18n("Minimize"), this, TQ_SLOT(toggleMinimizeRestore()));

    pop_sticky = popupMenu->insertItem(i18n("Sticky"), this, TQ_SLOT(toggleSticky()));
    popupMenu->insertSeparator();
    mainWin->action("drop_target")->plug(popupMenu);
    popupMenu->insertSeparator();
    
    popupMenu->setItemChecked(pop_sticky, b_sticky);
    tdemain->m_paPreferences->plug(popupMenu);
    popupMenu->insertSeparator();
    tdemain->m_paQuit->plug(popupMenu);

    isdragging = false;

    // Enable dropping
    setAcceptDrops(true);
}


DropTarget::~DropTarget()
{
    delete popupMenu;
}


void
DropTarget::mousePressEvent(TQMouseEvent * e)
{
    if (e->button() == TQt::LeftButton)
    {
        // toggleMinimizeRestore ();
//        oldX = 0;
//        oldY = 0;
        isdragging = true;
        dx = TQCursor::pos().x() - pos().x();
        dy = TQCursor::pos().y() - pos().y();
    }
    else if (e->button() == TQt::RightButton)
    {
        popupMenu->setItemEnabled(pop_Min, tdemain->isVisible());
        popupMenu->setItemEnabled(pop_Max, tdemain->isHidden());

        popupMenu->popup(TQCursor::pos());
    }
    else if (e->button() == TQt::MidButton)
    {
        tdemain->slotPasteTransfer();
    }
}


void DropTarget::resizeEvent(TQResizeEvent *)
{
#ifdef TQ_WS_X11
    XShapeCombineMask(x11Display(), winId(), ShapeBounding, 0, 0, mask.handle(), ShapeSet);
#endif
}


void DropTarget::dragEnterEvent(TQDragEnterEvent * event)
{
    event->accept(KURLDrag::canDecode(event)
                  || TQTextDrag::canDecode(event));
}


void DropTarget::dropEvent(TQDropEvent * event)
{
    KURL::List list;
    TQString str;

    if (KURLDrag::decode(event, list))
    {
        tdemain->addTransfers(list);
    }
    else if (TQTextDrag::decode(event, str))
    {
        tdemain->addTransfer(str);
    }
}


void DropTarget::toggleSticky()
{
    b_sticky = !b_sticky;
    popupMenu->setItemChecked(pop_sticky, b_sticky);
    updateStickyState();
}

void DropTarget::updateStickyState()
{
    if (b_sticky)
    {
        KWin::setState(winId(), NET::SkipTaskbar | NET::StaysOnTop | NET::Sticky);
    }
    else
    {
        KWin::clearState(winId(), NET::Sticky);
    }
}

void DropTarget::toggleMinimizeRestore()
{
    if (tdemain->isVisible())
        tdemain->hide();
    else
        tdemain->show();
}

/** No descriptions */
void DropTarget::mouseMoveEvent(TQMouseEvent * e)
{
/*
    if (oldX == 0)
    {
        oldX = e->x();
        oldY = e->y();
        return;
    }
+*/
    if (isdragging)
        move( TQCursor::pos().x() - dx, TQCursor::pos().y() - dy );

//    move(x() + (e->x() - oldX), y() + (e->y() - oldY));  // <<--
}

void DropTarget::mouseReleaseEvent(TQMouseEvent *)
{
    isdragging = false;
}

/** No descriptions */
void DropTarget::mouseDoubleClickEvent(TQMouseEvent * e)
{
    if (e->button() == TQt::LeftButton)
        toggleMinimizeRestore();
}

#include "droptarget.moc"
