/* -------------------------------------------------------------

   main.cpp (part of The KDE Dictionary Client)

   Copyright (C) 2000-2001 Christian Gebauer <gebauer@kde.org>
   (C) by Matthias H�zer 1998

   This file is distributed under the Artistic License.
   See LICENSE for details.

 ------------------------------------------------------------- */

#include <config.h>

#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <tdelibs_export.h>

#include "application.h"
#include "toplevel.h"

static TDECmdLineOptions knoptions[] =
{
  { "c", 0, 0 },
  { "clipboard", I18N_NOOP("Define X11-clipboard content (selected text)"), 0 },
  { "+[word/phrase]", I18N_NOOP("Lookup the given word/phrase"), 0 },
  TDECmdLineLastOption
};


extern "C" TDE_EXPORT int kdemain(int argc, char* argv[])
{
  TDEAboutData aboutData("kdict",
                        I18N_NOOP("Dictionary"),
                        KDICT_VERSION,
                        I18N_NOOP("The TDE Dictionary Client"),
                        TDEAboutData:: License_Artistic,
                        "Copyright (c) 1999-2001, Christian Gebauer\nCopyright (c) 1998, Matthias Hoelzer",
                        0,
                        0);

  aboutData.addAuthor("Christian Gebauer",I18N_NOOP("Maintainer"),"gebauer@kde.org");
  aboutData.addAuthor("Matthias Hoelzer",I18N_NOOP("Original Author"),"hoelzer@kde.org");

  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( knoptions );
  KUniqueApplication::addCmdLineOptions();

  if (!Application::start())
    return 0;

  Application app;

  return app.exec();
}
