#################################################
#
#  (C) 2010 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

# required stuff

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

find_package( TQt )
find_package( TDE )


##### check for gcc visibility support #########

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


if( BUILD_KOPETE OR BUILD_KPPP )
  check_include_file( string.h HAVE_STRING_H )
endif( )

if( BUILD_KOPETE OR BUILD_KTALKD )
  check_include_file( stdint.h HAVE_STDINT_H )
endif( )

if( WITH_SLP )
  check_library_exists( slp "SLPOpen" "" HAVE_SLP )
  if( HAVE_SLP )
    set(LIB_SLP slp )
  else( )
    tde_message_fatal( "openslp is required, but was not found on your system" )
  endif( )
endif( )

if( BUILD_KOPETE AND BUILD_KOPETE_PROTOCOL_SMS AND WITH_GSM )
  check_include_file_cxx( gsmlib/gsm_util.h HAVE_GSMLIB_GSM_UTIL_H )

  if( HAVE_GSMLIB_GSM_UTIL_H )
    find_library( GSM_LIBRARY gsmme )
  endif( )

  if( HAVE_GSMLIB_GSM_UTIL_H AND GSM_LIBRARY )
      set( HAVE_GSMLIB 1 )
  else( )
    tde_message_fatal( "gsmlib is required, but was not found on your system" )
  endif( )
endif( )


check_symbol_exists( strlcat "string.h" HAVE_STRLCAT_PROTO )
check_symbol_exists( strlcpy "string.h" HAVE_STRLCPY_PROTO )
