/**************************************************************************

    channel.h  - The KMidChannel widget (with pure virtual members)
    Copyright (C) 1998  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Send comments and bug fixes to larrosa@kde.org
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/

#ifndef KMIDCHANNEL_H
#define KMIDCHANNEL_H
#include <tqwidget.h>
#include <tqpixmap.h>

#define CHANNELHEIGHT 71
#define KEYBOARDY CHANNELHEIGHT-46

#define CHN_CHANGE_PGM 1
#define CHN_CHANGE_FORCED_STATE 2

class TQFont;
class TQComboBox;
class KMidButton;
class KMidChannel : public TQWidget
{
    TQ_OBJECT
  

private:
    bool pressed[128]; // The 128 keys
    int channel;
    bool replay; // Indicates if music should restart playing after
    // changing the force state
    
protected:
    TQPixmap keyboard;
    TQPixmap button1;
    TQPixmap button2;

    TQComboBox *instrumentCombo;

    KMidButton *forcepgm;
    TQFont *qcvfont;

    TQPen *penB; // Black
    TQPen *penW; // White
    TQPen *penT; // "Transparent" for Background
    
    void paintEvent( TQPaintEvent * );
public:
    KMidChannel(int i,TQWidget *Parent);
    virtual ~KMidChannel();

    void drawKeyboard(TQPainter *qpaint);
    void drawPressedKeys(TQPainter *qpaint);
    void drawKey(TQPainter *qpaint,int key);

    virtual void drawDo   (TQPainter *qpaint,int x,int p) = 0;
    virtual void drawDo__ (TQPainter *qpaint,int x,int p) = 0;
    virtual void drawRe   (TQPainter *qpaint,int x,int p) = 0;
    virtual void drawRe__ (TQPainter *qpaint,int x,int p) = 0;
    virtual void drawMi   (TQPainter *qpaint,int x,int p) = 0;
    virtual void drawFa   (TQPainter *qpaint,int x,int p) = 0;
    virtual void drawFa__ (TQPainter *qpaint,int x,int p) = 0;
    virtual void drawSol  (TQPainter *qpaint,int x,int p) = 0;
    virtual void drawSol__(TQPainter *qpaint,int x,int p) = 0;
    virtual void drawLa   (TQPainter *qpaint,int x,int p) = 0;
    virtual void drawLa__ (TQPainter *qpaint,int x,int p) = 0;
    virtual void drawSi   (TQPainter *qpaint,int x,int p) = 0;

    void noteOn(int key);
    void noteOff(int key);
    void changeInstrument(int pgm);
    void changeForceState(bool i);
    
    void reset(int level=1); // 0 only release notes, 1 also set instr to 0 ...

    void saveState(bool *p,int *pgm);
    void loadState(bool *p,int *pgm);
    
public slots:
    void pgmChanged(int i);
    void changeForcedState(bool);

signals:
    void signalToKMidClient(int *data);
    
};

#endif
