//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQDataStream;
import java.util.ArrayList;

/**

 KServiceGroup represents a group of service, for example
 screensavers.
 This class is typically used like this:
 <pre>
 // Lookup screensaver group
 KServiceGroup.Ptr group = KServiceGroup.baseGroup("screensavers");
 if (!group || !group.isValid()) return;
 KServiceGroup.List list = group.entries();
 // Iterate over all entries in the group
 for( KServiceGroup.List.ConstIterator it = list.begin();
      it != list.end(); it++)
 {
    KSycocaEntry p = (it);
    if (p.isType(KST_KService))
    {
       KService s = (KService)(p);
       printf("Name = %s\n", s.name().latin1());
    }
    else if (p.isType(KST_KServiceGroup))
    {
       KServiceGroup g = (KServiceGroup)(p);
       // Sub group ...
    }
 }
 </pre>
		@short Represents a group of services.

*/
public class KServiceGroup extends KSycocaEntry  {
	protected KServiceGroup(Class dummy){super((Class) null);}
	/**
		 Construct a dummy servicegroup indexed with <code>name.</code>
			@param name the name of the service group
				@short    Construct a dummy servicegroup indexed with <code>name.</code>
	*/
	public KServiceGroup(String name) {
		super((Class) null);
		newKServiceGroup(name);
	}
	private native void newKServiceGroup(String name);
	/**
		 Construct a service and take all informations from a config file
			@param _fullpath full path to the config file
			@param _relpath relative path to the config file
		   		@short    Construct a service and take all informations from a config file
	*/
	public KServiceGroup(String _fullpath, String _relpath) {
		super((Class) null);
		newKServiceGroup(_fullpath,_relpath);
	}
	private native void newKServiceGroup(String _fullpath, String _relpath);
	/**
			 The stream must already be positionned at the correct offset
		   		@short
	*/
	public KServiceGroup(TQDataStream _str, int offset, boolean deep) {
		super((Class) null);
		newKServiceGroup(_str,offset,deep);
	}
	private native void newKServiceGroup(TQDataStream _str, int offset, boolean deep);
	/**
		 Checks whether the entry is valid, returns always true.
				@return true

		@short    Checks whether the entry is valid, returns always true.
	*/
	public native boolean isValid();
	/**
		 Name used for indexing.
				@return the service group's name

		@short    Name used for indexing.
	*/
	public native String name();
	/**
		 Returns the relative path of the service group.
				@return the service group's relative path

		@short    Returns the relative path of the service group.
	*/
	public native String relPath();
	/**
		 Returns the caption of this group.
				@return the caption of this group

		@short    Returns the caption of this group.
	*/
	public native String caption();
	/**
		 Returns the name of the icon associated with the group.
				@return the name of the icon associated with the group,
         or null if not set

		@short    Returns the name of the icon associated with the group.
	*/
	public native String icon();
	/**
		 Returns the comment about this service group.
				@return the descriptive comment for the group, if there is one,
         or null if not set

		@short    Returns the comment about this service group.
	*/
	public native String comment();
	/**
		 Returns the total number of displayable services in this group and
		 any of its subgroups.
				@return the number of child services

		@short    Returns the total number of displayable services in this group and  any of its subgroups.
	*/
	public native int childCount();
	/**
		 Returns true if the NoDisplay flag was set, i.e. if this
		 group should be hidden from menus, while still being in tdesycoca.
				@return true to hide this service group, false to display it

		@short    Returns true if the NoDisplay flag was set, i.
	*/
	public native boolean noDisplay();
	/**
		 Return true if we want to display empty menu entry
				@return true to show this service group as menu entry is empty, false to hide it

		@short    Return true if we want to display empty menu entry
	*/
	public native boolean showEmptyMenu();
	public native void setShowEmptyMenu(boolean b);
	/**
				@return true to show an inline header into menu

		@short
	*/
	public native boolean showInlineHeader();
	public native void setShowInlineHeader(boolean _b);
	/**
				@return true to show an inline alias item into menu

		@short
	*/
	public native boolean inlineAlias();
	public native void setInlineAlias(boolean _b);
	/**
				@return true if we allow to inline menu.

		@short
	*/
	public native boolean allowInline();
	public native void setAllowInline(boolean _b);
	/**
				@return inline limite value

		@short
	*/
	public native int inlineValue();
	public native void setInlineValue(int _val);
	/**
		 Returns a list of untranslated generic names that should be
		 be supressed when showing this group.
		 E.g. The group "Games/Arcade" might want to suppress the generic name
		 "Arcade Game" since it's redundant in this particular context.
				@short    Returns a list of untranslated generic names that should be  be supressed when showing this group.
	*/
	public native ArrayList suppressGenericNames();
	/**
			 Sets information related to the layout of services in this group.
		   		@short
	*/
	public native void setLayoutInfo(String[] layout);
	/**
			 Returns information related to the layout of services in this group.
		   		@short
	*/
	public native ArrayList layoutInfo();
	/**
			 Load the service from a stream.
		   		@short
	*/
	public native void load(TQDataStream arg1);
	/**
			 Save the service to a stream.
		   		@short
	*/
	public native void save(TQDataStream arg1);
	/**
		 List of all Services and ServiceGroups within this
		 ServiceGroup.
			@param sorted true to sort items
			@param excludeNoDisplay true to exclude items marked "NoDisplay"
			@param allowSeparators true to allow separator items to be included
			@param sortByGenericName true to sort GenericName+Name instead of Name+GenericName
				@return the list of entries

		@short    List of all Services and ServiceGroups within this  ServiceGroup.
	*/
	// KServiceGroup::List entries(bool arg1,bool arg2,bool arg3,bool arg4); >>>> NOT CONVERTED
	// KServiceGroup::List entries(bool arg1,bool arg2,bool arg3); >>>> NOT CONVERTED
	// KServiceGroup::List entries(bool arg1,bool arg2); >>>> NOT CONVERTED
	/**
		 List of all Services and ServiceGroups within this
		 ServiceGroup.
			@param sorted true to sort items
				@return the list of entried

		@short    List of all Services and ServiceGroups within this  ServiceGroup.
	*/
	// KServiceGroup::List entries(bool arg1); >>>> NOT CONVERTED
	// KServiceGroup::List entries(); >>>> NOT CONVERTED
	/**
		 Returns a non-empty string if the group is a special base group.
		 By default, "Settings/" is the kcontrol base group ("settings")
		 and "System/Screensavers/" is the screensavers base group ("screensavers").
		 This allows moving the groups without breaking those apps.
			 The base group is defined by the X-TDE-BaseGroup key
		 in the .directory file.
				@return the base group name, or null if no base group

		@short    Returns a non-empty string if the group is a special base group.
	*/
	public native String baseGroupName();
	/**
		 Returns a path to the .directory file describing this service group.
		 The path is either absolute or relative to the "apps" resource.
				@short    Returns a path to the .
	*/
	public native String directoryEntryPath();
	/**
		 This function parse attributes into menu
				@short    This function parse attributes into menu
	*/
	public native void parseAttribute(String item, boolean showEmptyMenu, boolean showInline, boolean showInlineHeader, boolean showInlineAlias, int[] inlineValue);
	/**
		 Returns the group for the given baseGroupName.
		 Can return null if the directory (or the .directory file) was deleted.
				@return the base group with the given name, or 0 if not available.

		@short    Returns the group for the given baseGroupName.
	*/
	// KServiceGroup::Ptr baseGroup(const TQString& arg1); >>>> NOT CONVERTED
	/**
		 Returns the root service group.
				@return the root service group

		@short    Returns the root service group.
	*/
	// KServiceGroup::Ptr root(); >>>> NOT CONVERTED
	/**
		 Returns the group with the given relative path.
			@param relPath the path of the service group
				@return the group with the given relative path name.

		@short    Returns the group with the given relative path.
	*/
	// KServiceGroup::Ptr group(const TQString& arg1); >>>> NOT CONVERTED
	/**
		 Returns the group of services that have X-TDE-ParentApp equal
		 to <code>parent</code> (siblings).
			@param parent the name of the service's parent
				@return the services group

		@short    Returns the group of services that have X-TDE-ParentApp equal  to <code>parent</code> (siblings).
	*/
	// KServiceGroup::Ptr childGroup(const TQString& arg1); >>>> NOT CONVERTED
	/**
			 Add a service to this group
		   		@short
	*/
	protected native void addEntry(KSycocaEntry entry);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
