// TQApplication.cs - A Qt to C# binding.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// Generated File.  Do Not Modify.

namespace Qt {

    using Qt;
    using System;
	using System.Collections;
    using System.Runtime.InteropServices;

    public class TQApplication : TQObject, IDisposable {

        public enum Type {
            Tty = 0,
            GuiClient = 1,
            GuiServer = 2
        }

        public enum ColorMode {
            NormalColors = 0,
            CustomColors = 1
        }

        public enum ColorSpec {
            NormalColor = 0,
            CustomColor = 1,
            ManyColor = 2
        }

        public enum Encoding {
            DefaultCodec = 0,
            UnicodeUTF8 = 1
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_new_QApplication (int argc, string[] argv);
        public TQApplication (string[] argv) : this (TQNull.Instance)
        {
			TQObject.qApp = this;
			qparent = null;
            argv = ParseArguments (argv);
			rawObject = qt_new_QApplication (argv.Length, argv);
            RegisterObject (this);
            RegisterEventDelegate ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_new_QApplication1 (int argc, string[] argv, bool GUIenabled);
        public TQApplication (string[] argv, bool GUIenabled) : this (TQNull.Instance)
        {
			TQObject.qApp = this;
			qparent = null;
            argv = ParseArguments (argv);
			rawObject = qt_new_QApplication1 (argv.Length, argv, GUIenabled);
            RegisterObject (this);
			RegisterEventDelegate ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_new_QApplication2 (int argc, string[] argv, Type arg1);
        public TQApplication (string[] argv, Type arg1) : this (TQNull.Instance)
        {
			TQObject.qApp = this;
			qparent = null;
            argv = ParseArguments (argv);
			rawObject = qt_new_QApplication2 (argv.Length, argv, arg1);
            RegisterObject (this);
			RegisterEventDelegate ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_new_QApplication3 (IntPtr dpy, uint visual, uint cmap);
        public TQApplication (IntPtr dpy, uint visual, uint cmap) : this (TQNull.Instance)
        {
			TQObject.qApp = this;
			qparent = null;
			rawObject = qt_new_QApplication3 (dpy, visual, cmap);
            RegisterObject (this);
			RegisterEventDelegate ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_new_QApplication4 (IntPtr dpy, int argc, string[] argv, uint visual, uint cmap);
        public TQApplication (IntPtr dpy, string[] argv, uint visual, uint cmap) : this (TQNull.Instance)
        {
			TQObject.qApp = this;
			qparent = null;
            argv = ParseArguments (argv);
			rawObject = qt_new_QApplication4 (dpy, argv.Length, argv, visual, cmap);
            RegisterObject (this);
			RegisterEventDelegate ();
        }

        public TQApplication (IntPtr dpy) : this (dpy, (uint) 0) {}

        public TQApplication (IntPtr dpy, uint visual) : this (dpy, visual, (uint) 0) {}

        public TQApplication (IntPtr dpy, string[] argv) : this (dpy, argv, (uint) 0) {}

        public TQApplication (IntPtr dpy, string[] argv, uint visual) : this (dpy, argv, visual, (uint) 0) {}

        internal TQApplication () : this (TQNull.Instance) {}

        internal TQApplication (TQNull dummy) : base (TQNull.Instance) {}

        ~TQApplication ()
        {
            Dispose (false);
        }

		[DllImport("libtqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_del_QApplication (IntPtr obj);
		internal override void Delete ()
		{
			if (deleted) return;

			qt_del_QApplication (rawObject);
			deleted = true;
		}

		private string[] ParseArguments (string[] args)
		{
			ArrayList newargs = new ArrayList();

			foreach (string arg in args) {
				switch (arg) {
				case "--qts-help":
					PrintHelp ();
					Environment.Exit(0);
					break;
				case "--qts-debug":
					QtSupport.enableDebug = true;
					break;
				case "--qts-notracking":
					QtSupport.disableTracking = true;
					break;
				case "--qts-trace-objects":
					QtSupport.traceObjects = true;
					break;
				case "--qts-trace-connects":
					QtSignal.traceConnects = true;
					break;
				case "--qts-trace-children":
					QtSupport.traceChildren = true;
					break;
				default:
					newargs.Add (arg);
					break;
				}
			}

			return newargs.ToArray (typeof (string)) as string[];
		}

		private void PrintHelp ()
		{
			Msg ("Qt# Options:");
			Msg ("");
			Msg ("--qts-help\t\tDisplay help.");
			Msg ("--qts-debug\t\tEnable debug mode.");
			Msg ("--qts-notracking\tDisable object tracking.");
			Msg ("--qts-trace-objects\tTrace object tracking.");
			Msg ("--qts-trace-connects\tTrace signal connections.");
			Msg ("--qts-trace-children\tTrace parent/child relationships.");
		}

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_argc (IntPtr raw);
        public int Argc ()
        {
            return qt_QApplication_argc (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern string[] qt_QApplication_argv (IntPtr raw);
        public string[] Argv ()
        {
            return qt_QApplication_argv (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern Type qt_QApplication_type (IntPtr raw);
        public Type TheType ()
        {
            return qt_QApplication_type (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_mainWidget (IntPtr raw);
        public TQWidget MainWidget ()
        {
            return (TQWidget)LookupObject (qt_QApplication_mainWidget (rawObject), typeof(TQWidget));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setMainWidget (IntPtr raw, IntPtr arg1);
        public void SetMainWidget (TQWidget arg1)
        {
            qt_QApplication_setMainWidget (rawObject, arg1.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_polish (IntPtr raw, IntPtr arg1);
        public void Polish (TQWidget arg1)
        {
            qt_QApplication_polish (rawObject, arg1.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_focusWidget (IntPtr raw);
        public TQWidget FocusWidget ()
        {
            return (TQWidget)LookupObject (qt_QApplication_focusWidget (rawObject), typeof(TQWidget));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_activeWindow (IntPtr raw);
        public TQWidget ActiveWindow ()
        {
            return (TQWidget)LookupObject (qt_QApplication_activeWindow (rawObject), typeof(TQWidget));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_exec (IntPtr raw);
        public int Exec ()
        {
            return qt_QApplication_exec (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_processEvents (IntPtr raw);
        public void ProcessEvents ()
        {
            qt_QApplication_processEvents (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_processEvents1 (IntPtr raw, int maxtime);
        public void ProcessEvents (int maxtime)
        {
            qt_QApplication_processEvents1 (rawObject, maxtime);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_hasPendingEvents (IntPtr raw);
        public bool HasPendingEvents ()
        {
            return qt_QApplication_hasPendingEvents (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_enter_loop (IntPtr raw);
        public int Enter_loop ()
        {
            return qt_QApplication_enter_loop (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_exit_loop (IntPtr raw);
        public void Exit_loop ()
        {
            qt_QApplication_exit_loop (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_loopLevel (IntPtr raw);
        public int LoopLevel ()
        {
            return qt_QApplication_loopLevel (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_notify (IntPtr raw, IntPtr arg1, IntPtr arg2);
        public bool Notify (TQObject arg1, TQEvent arg2)
        {
            return qt_QApplication_notify (rawObject, arg1.RawObject, arg2.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setDefaultCodec (IntPtr raw, IntPtr arg1);
        public void SetDefaultCodec (TQTextCodec arg1)
        {
            qt_QApplication_setDefaultCodec (rawObject, arg1.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_defaultCodec (IntPtr raw);
        public TQTextCodec DefaultCodec ()
        {
            return (TQTextCodec)LookupObject (qt_QApplication_defaultCodec (rawObject), typeof(TQTextCodec));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_installTranslator (IntPtr raw, IntPtr arg1);
        public void InstallTranslator (TQTranslator arg1)
        {
            qt_QApplication_installTranslator (rawObject, arg1.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_removeTranslator (IntPtr raw, IntPtr arg1);
        public void RemoveTranslator (TQTranslator arg1)
        {
            qt_QApplication_removeTranslator (rawObject, arg1.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_translate (IntPtr raw, string context, string key, string comment, Encoding encoding);
        public string Translate (string context, string key, string comment, Encoding encoding)
        {
			TQString qstr = new TQString (qt_QApplication_translate (rawObject, context, key, comment, encoding));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_macEventFilter (IntPtr raw, IntPtr arg1);
        public bool MacEventFilter (IntPtr arg1)
        {
            return qt_QApplication_macEventFilter (rawObject, arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_winEventFilter (IntPtr raw, IntPtr arg1);
        public bool WinEventFilter (IntPtr arg1)
        {
            return qt_QApplication_winEventFilter (rawObject, arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_x11EventFilter (IntPtr raw, IntPtr arg1);
        public bool X11EventFilter (IntPtr arg1)
        {
            return qt_QApplication_x11EventFilter (rawObject, arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_x11ClientMessage (IntPtr raw, IntPtr arg1, IntPtr arg2, bool passive_only);
        public int X11ClientMessage (TQWidget arg1, IntPtr arg2, bool passive_only)
        {
            return qt_QApplication_x11ClientMessage (rawObject, arg1.RawObject, arg2, passive_only);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_qwsEventFilter (IntPtr raw, IntPtr arg1);
        public bool QwsEventFilter (IntPtr arg1)
        {
            return qt_QApplication_qwsEventFilter (rawObject, arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_qwsSetCustomColors (IntPtr raw, int colortable, int start, int numColors);
        public void QwsSetCustomColors (int colortable, int start, int numColors)
        {
            qt_QApplication_qwsSetCustomColors (rawObject, colortable, start, numColors);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_winFocus (IntPtr raw, IntPtr arg1, bool arg2);
        public void WinFocus (TQWidget arg1, bool arg2)
        {
            qt_QApplication_winFocus (rawObject, arg1.RawObject, arg2);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_isSessionRestored (IntPtr raw);
        public bool IsSessionRestored ()
        {
            return qt_QApplication_isSessionRestored (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_sessionId (IntPtr raw);
        public string SessionId ()
        {
			TQString qstr = new TQString (qt_QApplication_sessionId (rawObject));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_commitData (IntPtr raw, IntPtr sm);
        public void CommitData (TQSessionManager sm)
        {
            qt_QApplication_commitData (rawObject, sm.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_saveState (IntPtr raw, IntPtr sm);
        public void SaveState (TQSessionManager sm)
        {
            qt_QApplication_saveState (rawObject, sm.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_wakeUpGuiThread (IntPtr raw);
        public void WakeUpGuiThread ()
        {
            qt_QApplication_wakeUpGuiThread (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_lock (IntPtr raw);
        public void Q_lock ()
        {
            qt_QApplication_lock (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_unlock (IntPtr raw, bool wakeUpGui);
        public void Unlock (bool wakeUpGui)
        {
            qt_QApplication_unlock (rawObject, wakeUpGui);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_locked (IntPtr raw);
        public bool Locked ()
        {
            return qt_QApplication_locked (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_tryLock (IntPtr raw);
        public bool TryLock ()
        {
            return qt_QApplication_tryLock (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setEnableRemoteControl (IntPtr raw, bool enable, IntPtr appId);
        public void SetEnableRemoteControl (bool enable, TQUuid appId)
        {
            qt_QApplication_setEnableRemoteControl (rawObject, enable, appId.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_remoteControlEnabled (IntPtr raw);
        public bool RemoteControlEnabled ()
        {
            return qt_QApplication_remoteControlEnabled (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_applicationId (IntPtr raw);
        public TQUuid ApplicationId ()
        {
            return (TQUuid)LookupObject (qt_QApplication_applicationId (rawObject), typeof(TQUuid));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_quit (IntPtr raw);
        public void Quit ()
        {
            qt_QApplication_quit (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_closeAllWindows (IntPtr raw);
        public void CloseAllWindows ()
        {
            qt_QApplication_closeAllWindows (rawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_style ();
        public static TQStyle Style ()
        {
            return (TQStyle)LookupObject (qt_QApplication_style (), typeof(TQStyle));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setStyle (IntPtr arg1);
        public static void SetStyle (TQStyle arg1)
        {
            qt_QApplication_setStyle (arg1.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_setStyle1 (IntPtr arg1);
        public static TQStyle SetStyle (string arg1)
        {
            return (TQStyle)LookupObject (qt_QApplication_setStyle1 (new TQString (arg1).RawObject), typeof(TQStyle));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern ColorMode qt_QApplication_colorMode ();
        public static ColorMode TheColorMode ()
        {
            return qt_QApplication_colorMode ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setColorMode (TQApplication.ColorMode arg1);
        public static void SetColorMode (TQApplication.ColorMode arg1)
        {
            qt_QApplication_setColorMode (arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_colorSpec ();
        public static int TheColorSpec ()
        {
            return qt_QApplication_colorSpec ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setColorSpec (int arg1);
        public static void SetColorSpec (int arg1)
        {
            qt_QApplication_setColorSpec (arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_overrideCursor ();
        public static TQCursor OverrideCursor ()
        {
            return (TQCursor)LookupObject (qt_QApplication_overrideCursor (), typeof(TQCursor));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setOverrideCursor (IntPtr arg1, bool replace);
        public static void SetOverrideCursor (TQCursor arg1, bool replace)
        {
            qt_QApplication_setOverrideCursor (arg1.RawObject, replace);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_restoreOverrideCursor ();
        public static void RestoreOverrideCursor ()
        {
            qt_QApplication_restoreOverrideCursor ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_hasGlobalMouseTracking ();
        public static bool HasGlobalMouseTracking ()
        {
            return qt_QApplication_hasGlobalMouseTracking ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setGlobalMouseTracking (bool enable);
        public static void SetGlobalMouseTracking (bool enable)
        {
            qt_QApplication_setGlobalMouseTracking (enable);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_palette (IntPtr arg1);
        public static TQPalette Palette (TQWidget arg1)
        {
            return (TQPalette)LookupObject (qt_QApplication_palette (arg1.RawObject), typeof(TQPalette));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setPalette (IntPtr arg1, bool informWidgets, string className);
        public static void SetPalette (TQPalette arg1, bool informWidgets, string className)
        {
            qt_QApplication_setPalette (arg1.RawObject, informWidgets, className);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_font (IntPtr arg1);
        public static TQFont Font (TQWidget arg1)
        {
            return (TQFont)LookupObject (qt_QApplication_font (arg1.RawObject), typeof(TQFont));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setFont (IntPtr arg1, bool informWidgets, string className);
        public static void SetFont (TQFont arg1, bool informWidgets, string className)
        {
            qt_QApplication_setFont (arg1.RawObject, informWidgets, className);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_fontMetrics ();
        public static TQFontMetrics FontMetrics ()
        {
            return (TQFontMetrics)LookupObject (qt_QApplication_fontMetrics (), typeof(TQFontMetrics));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_allWidgets ();
        public static TQWidgetList AllWidgets ()
        {
            return (TQWidgetList)LookupObject (qt_QApplication_allWidgets (), typeof(TQWidgetList));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_topLevelWidgets ();
        public static TQWidgetList TopLevelWidgets ()
        {
            return (TQWidgetList)LookupObject (qt_QApplication_topLevelWidgets (), typeof(TQWidgetList));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_desktop ();
        public static TQDesktopWidget Desktop ()
        {
            return (TQDesktopWidget)LookupObject (qt_QApplication_desktop (), typeof(TQDesktopWidget));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_activePopupWidget ();
        public static TQWidget ActivePopupWidget ()
        {
            return (TQWidget)LookupObject (qt_QApplication_activePopupWidget (), typeof(TQWidget));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_activeModalWidget ();
        public static TQWidget ActiveModalWidget ()
        {
            return (TQWidget)LookupObject (qt_QApplication_activeModalWidget (), typeof(TQWidget));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_clipboard ();
        public static TQClipboard Clipboard ()
        {
            return (TQClipboard)LookupObject (qt_QApplication_clipboard (), typeof(TQClipboard));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_widgetAt (int x, int y, bool child);
        public static TQWidget WidgetAt (int x, int y, bool child)
        {
            return (TQWidget)LookupObject (qt_QApplication_widgetAt (x, y, child), typeof(TQWidget));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_widgetAt1 (IntPtr arg1, bool child);
        public static TQWidget WidgetAt (TQPoint arg1, bool child)
        {
            return (TQWidget)LookupObject (qt_QApplication_widgetAt1 (arg1.RawObject, child), typeof(TQWidget));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_exit (int retcode);
        public static void Exit (int retcode)
        {
            qt_QApplication_exit (retcode);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_sendPostedEvents (IntPtr receiver, int event_type);
        public static void SendPostedEvents (TQObject receiver, int event_type)
        {
            qt_QApplication_sendPostedEvents (receiver.RawObject, event_type);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_sendPostedEvents1 ();
        public static void SendPostedEvents ()
        {
            qt_QApplication_sendPostedEvents1 ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_removePostedEvents (IntPtr receiver);
        public static void RemovePostedEvents (TQObject receiver)
        {
            qt_QApplication_removePostedEvents (receiver.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_startingUp ();
        public static bool StartingUp ()
        {
            return qt_QApplication_startingUp ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_closingDown ();
        public static bool ClosingDown ()
        {
            return qt_QApplication_closingDown ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_flushX ();
        public static void FlushX ()
        {
            qt_QApplication_flushX ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_flush ();
        public static void Flush ()
        {
            qt_QApplication_flush ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_syncX ();
        public static void SyncX ()
        {
            qt_QApplication_syncX ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_beep ();
        public static void Beep ()
        {
            qt_QApplication_beep ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setWinStyleHighlightColor (IntPtr c);
        public static void SetWinStyleHighlightColor (TQColor c)
        {
            qt_QApplication_setWinStyleHighlightColor (c.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_winStyleHighlightColor ();
        public static TQColor WinStyleHighlightColor ()
        {
            return (TQColor)LookupObject (qt_QApplication_winStyleHighlightColor (), typeof(TQColor));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setDesktopSettingsAware (bool arg1);
        public static void SetDesktopSettingsAware (bool arg1)
        {
            qt_QApplication_setDesktopSettingsAware (arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_desktopSettingsAware ();
        public static bool DesktopSettingsAware ()
        {
            return qt_QApplication_desktopSettingsAware ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setCursorFlashTime (int arg1);
        public static void SetCursorFlashTime (int arg1)
        {
            qt_QApplication_setCursorFlashTime (arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_cursorFlashTime ();
        public static int CursorFlashTime ()
        {
            return qt_QApplication_cursorFlashTime ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setDoubleClickInterval (int arg1);
        public static void SetDoubleClickInterval (int arg1)
        {
            qt_QApplication_setDoubleClickInterval (arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_doubleClickInterval ();
        public static int DoubleClickInterval ()
        {
            return qt_QApplication_doubleClickInterval ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setWheelScrollLines (int arg1);
        public static void SetWheelScrollLines (int arg1)
        {
            qt_QApplication_setWheelScrollLines (arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_wheelScrollLines ();
        public static int WheelScrollLines ()
        {
            return qt_QApplication_wheelScrollLines ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setGlobalStrut (IntPtr arg1);
        public static void SetGlobalStrut (TQSize arg1)
        {
            qt_QApplication_setGlobalStrut (arg1.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_globalStrut ();
        public static TQSize GlobalStrut ()
        {
            return (TQSize)LookupObject (qt_QApplication_globalStrut (), typeof(TQSize));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setLibraryPaths (IntPtr arg1);
        public static void SetLibraryPaths (TQStringList arg1)
        {
            qt_QApplication_setLibraryPaths (arg1.RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_libraryPaths ();
        public static TQStringList LibraryPaths ()
        {
            return (TQStringList)LookupObject (qt_QApplication_libraryPaths (), typeof(TQStringList));
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_addLibraryPath (IntPtr arg1);
        public static void AddLibraryPath (string arg1)
        {
            qt_QApplication_addLibraryPath (new TQString (arg1).RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_removeLibraryPath (IntPtr arg1);
        public static void RemoveLibraryPath (string arg1)
        {
            qt_QApplication_removeLibraryPath (new TQString (arg1).RawObject);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setStartDragTime (int ms);
        public static void SetStartDragTime (int ms)
        {
            qt_QApplication_setStartDragTime (ms);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_startDragTime ();
        public static int StartDragTime ()
        {
            return qt_QApplication_startDragTime ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setStartDragDistance (int l);
        public static void SetStartDragDistance (int l)
        {
            qt_QApplication_setStartDragDistance (l);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_startDragDistance ();
        public static int StartDragDistance ()
        {
            return qt_QApplication_startDragDistance ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setReverseLayout (bool b);
        public static void SetReverseLayout (bool b)
        {
            qt_QApplication_setReverseLayout (b);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_reverseLayout ();
        public static bool ReverseLayout ()
        {
            return qt_QApplication_reverseLayout ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QApplication_horizontalAlignment (int align);
        public static int HorizontalAlignment (int align)
        {
            return qt_QApplication_horizontalAlignment (align);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_isEffectEnabled (Qt.UIEffect arg1);
        public static bool IsEffectEnabled (Qt.UIEffect arg1)
        {
            return qt_QApplication_isEffectEnabled (arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_setEffectEnabled (Qt.UIEffect arg1, bool enable);
        public static void SetEffectEnabled (Qt.UIEffect arg1, bool enable)
        {
            qt_QApplication_setEffectEnabled (arg1, enable);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QApplication_qwsDecoration ();
        public static IntPtr QwsDecoration ()
        {
            return qt_QApplication_qwsDecoration ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_qwsSetDecoration (IntPtr arg1);
        public static void QwsSetDecoration (IntPtr arg1)
        {
            qt_QApplication_qwsSetDecoration (arg1);
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern Qt.WindowsVersion qt_QApplication_winVersion ();
        public static Qt.WindowsVersion WinVersion ()
        {
            return qt_QApplication_winVersion ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_winMouseButtonUp ();
        public static void WinMouseButtonUp ()
        {
            qt_QApplication_winMouseButtonUp ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_create_xim ();
        public static void Create_xim ()
        {
            qt_QApplication_create_xim ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QApplication_close_xim ();
        public static void Close_xim ()
        {
            qt_QApplication_close_xim ();
        }

        [DllImport("libtqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QApplication_x11_apply_settings ();
        public static bool X11_apply_settings ()
        {
            return qt_QApplication_x11_apply_settings ();
        }

        public string Translate (string context, string key)
        {
            return Translate(context, key, "");
        }

        public string Translate (string context, string key, string comment)
        {
            return Translate(context, key, comment, Encoding.DefaultCodec);
        }

        public void Unlock ()
        {
            Unlock(true);
        }

        public void SetEnableRemoteControl (bool enable)
        {
            SetEnableRemoteControl(enable, new TQUuid ());
        }

        public static void SetOverrideCursor (TQCursor arg1)
        {
            SetOverrideCursor(arg1, false);
        }

        public static TQPalette Palette ()
        {
            return Palette(new TQWidget ());
        }

        public static void SetPalette (TQPalette arg1)
        {
            SetPalette(arg1, false);
        }

        public static void SetPalette (TQPalette arg1, bool informWidgets)
        {
            SetPalette(arg1, informWidgets, "");
        }

        public static TQFont Font ()
        {
            return Font(new TQWidget ());
        }

        public static void SetFont (TQFont arg1)
        {
            SetFont(arg1, false);
        }

        public static void SetFont (TQFont arg1, bool informWidgets)
        {
            SetFont(arg1, informWidgets, "");
        }

        public static TQWidget WidgetAt (int x, int y)
        {
            return WidgetAt(x, y, false);
        }

        public static TQWidget WidgetAt (TQPoint arg1)
        {
            return WidgetAt(arg1, false);
        }

        public static void Exit ()
        {
            Exit((int) 0);
        }

        public static void SetEffectEnabled (Qt.UIEffect arg1)
        {
            SetEffectEnabled(arg1, true);
        }

        // Begin interface methods.

    }
}
