#!/usr/bin/env kjscmd

function write_page( name, body )
{
    var markUp = "";

    markUp += '<html>\n';

    markUp += '<head>\n';
    markUp += '<title>' + name + '</title>\n';
    markUp += '<style type="text/css"><!--\n';
    markUp += 'h1 { text-align: center; background-color: #ccccff; }\n';
    markUp += 'h2 { background-color: #eeeeff; }\n';
    markUp += 'h3 { background-color: #eeeeff; }\n';
    markUp += 'th { background-color: #cccccc; }\n';
    markUp += 'td { background-color: #eeeeee; }\n';
    markUp +=  '--></style>\n';
    markUp += '</head>\n';

    markUp += '<body>\n';
    markUp += '<a href="index.html">All Objects</a>';
    markUp += '| <a href="index-static.html">Statics</a>';
    markUp += '| <a href="index-objects.html">Objects</a>';
    markUp += '| <a href="index-kjsembedobjects.html">KJSEmbed Objects</a>';
    markUp += '| <a href="index-qtobjects.html">Qt Objects</a>';
    markUp += '| <a href="index-kdeobjects.html">KDE Objects</a>';
    markUp += '| <a href="index-exceptions.html">Exceptions</a>';
    markUp += '| <a href="index-nocreate.html">Uncreatable Objects</a>\n';
    markUp += '<h1>' + name + '</h1>\n';
    markUp += '<hr>\n';
    markUp += body;
    markUp += '<hr>\n';
    markUp += '</body>\n';

    markUp += '</html>\n';
    return markUp;
}

function write_classlist( title, intro, classlist )
{
    text = '<h3>'+title+'</h3>';
    text += intro;
    text += '<ul>\n';

    var hrefroot = '';
    for ( var i = 0; i < classlist.length; i++ )
    {
	text += '<li>';
	var href = classlist[i].toLowerCase() + '.html';
	href = href.replace( /.*::/, '' );

	var name = classlist[i];
	text += '<a href="' + hrefroot + href + '">' + name + '</a>\n';
    }
    text += '</ul>\n';

    return text;
}

function write_classes( title, desc, sections )
{
    var txt = desc;
    for ( var i = 0; i < sections.length; i += 3 ) {
	txt += write_classlist( sections[ i ], sections[ i+1 ], sections[ i+2 ] );
    }

    return write_page( title, txt );
}

function generate_docs_object( name, obj )
{
    var fileText = write_page( name,
	       'Bindings for the ' + name + ' class.<br />' + dump(obj) );
    System.writeFile("jsref/" + name.toLowerCase() + ".html", fileText);
}

function generate_docs_nocreate( name )
{
    var fileText = write_page( name,
         'Bindings for the ' + name + ' class.<br />'
       + 'This class is understood by the interpreter, but cannot be created from scripts.' );

    System.writeFile("jsref/" + name.toLowerCase() + ".html", fileText);
}

//
// Document the static objects
//
function document_statics( statics )
{
    for ( var idx = 0; idx < statics.length; idx++ ) {
	var name = statics[idx];
	try
	{
	var obj = eval( name );
	var fileText = write_page( name,
		   'Bindings for the static ' + name + ' object.' + dump(obj) );
	System.writeFile("jsref/" + name.toLowerCase() + ".html", fileText);
    }
	catch(x)
	{
		println("Error: " + x );
	}
    }
}

//
// Build script that will document the constructable objects
//

function document_constructable( objects )
{
    for ( var idx = 0; idx < objects.length; idx++ )
    {
	println('Document class: ' + objects[idx] );

	try {
	  generate_docs_object( objects[idx], Factory.createObject( objects[idx] ));
		println(', Success');
	}
	catch(x) {
		println(', Error ' + x );
		generate_docs_nocreate( objects[idx] );
		nocreate.push( objects[idx] );
	}
    }
}
////
//// Main
////


var statics = [ 'Factory', 'System', 'Global', 'StdDialog',
                'StdAction', 'StdDirs', 'StdIcons', 'Qt' ];
qttps = [];
kdetps = [];
kjsetps = [];
other = [];
nocreate = [];
var expts = [ 'ReferenceError', 'EvalError', 'RangeError', 'TypeError' ];
tps = Factory.types().sort();

statics.sort();
expts.sort();

cons = Factory.constructors().sort();
cons += 'Part';

for ( var i=0; i < tps.length; i++ ) {

    if ( /^Q/.test(tps[i]) ) {
 	qttps.push( tps[i] );
    }
    else if ( /^KJSEmbed::/.test(tps[i]) ) {
	if ( tps[i] != 'KJSEmbed::Bindings::JSDCOPInterface' ) {
	    kjsetps.push( tps[i] );
	}
    }
    else if ( /^K/.test(tps[i]) ) {
 	kdetps.push( tps[i] );
    }
    else {
 	other.push( tps[i] );
    }
}

//
// Generate object reference pages
//

document_constructable( tps );
document_statics( statics );
document_statics( expts );

generate_docs_object( 'TextStream', System.stdin );
generate_docs_object( 'Application', application );
generate_docs_object( 'KJSEmbedPart', part );
generate_docs_object( 'TQListViewItem', new TQListViewItem(new TQListView()) );
generate_docs_object( 'TQCheckListItem', new TQCheckListItem(new TQListView()) );
generate_docs_object( 'TQCanvasText', new TQCanvasText(new TQCanvas()) );

other.push( 'Application' );
other.sort();

//
// Generate index pages
//
index = [ 'Static Objects',
	  'Statics that are available to scripts as JS objects.',
	  statics,

	  'Object Types',
	  'The non-widget objects that are defined for scripts.',
	  other,

	  'KJSEmbed Objects',
	  'KDE objects that are available to scripts as JS objects.',
	  kjsetps,

	  'Qt Objects',
	  'Qt objects that are available to scripts as JS objects.',
	  qttps,

	  'KDE Objects',
	  'KDE objects that are available to scripts as JS objects.',
	  kdetps,

	  'Exception Types',
	  'Exceptions that are defined for scripts.',
	  expts,

	  'Unconstructable Types',
	  'Known type that scripts cannot create.',
	  nocreate
    ];

System.writeFile( "jsref/index.html",
		  write_classes( 'All Scriptable Objects',
				 'The full set of objects that can be accessed by scripts.',
				 index  ) );

System.writeFile( "jsref/index-static.html", write_classes( index[0], index[1], ['','',index[2]] ) );
System.writeFile( "jsref/index-objects.html", write_classes( index[3], index[4], ['','',index[5]] ) );
System.writeFile( "jsref/index-kjsembedobjects.html", write_classes( index[6], index[7], ['','',index[8]] ) );
System.writeFile( "jsref/index-qtobjects.html", write_classes( index[9], index[10], ['','',index[11]] ) );
System.writeFile( "jsref/index-kdeobjects.html", write_classes( index[12], index[13], ['','',index[14]] ) );
System.writeFile( "jsref/index-exceptions.html", write_classes( index[15], index[16], ['','',index[17]] ) );
System.writeFile( "jsref/index-nocreate.html", write_classes( index[18], index[19], ['','',index[20]] ) );

System.exit(0);
