/* This file is part of the Keep project
   Copyright (C) 2006 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "backuplistviewitem.h"

#include <tdelocale.h>
#include <tqdir.h>
#include <tdelistview.h>

BackupListViewItem::BackupListViewItem(TDEListView *parent,Backup &backup): TQListViewItem (parent) 
{ 
	setBackup(backup);
}

BackupListViewItem::~BackupListViewItem()
{
}

Backup BackupListViewItem::backup()
{
	return m_backup;
}

void BackupListViewItem::setBackup(Backup backup)
{
	m_backup = backup;
	setBackupText();
}

void BackupListViewItem::setBackupText()
{
	setText(0, TQDir(m_backup.source()).dirName() );
	setText(1, TQDir(m_backup.dest()).dirName() );
	setText(2, i18n("%1 days").arg(m_backup.interval()));
	TQString deleteAfter;
	if ( m_backup.neverDelete() == true )
		deleteAfter = i18n("Never");
	else
		deleteAfter = i18n("%1 days").arg(m_backup.deleteAfter());
	setText(3, deleteAfter);
}


