/*
 *
 *  TrayIcon for tdebluez
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluez.
 *
 *  tdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  tdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef TRAYICON_H
#define TRAYICON_H


#include <tqtooltip.h>
#include <tdeconfig.h>
#include <tdepopupmenu.h>
#include <tdeactionclasses.h>

#include <ksystemtray.h>
#include <khelpmenu.h>
#include <knotifydialog.h>
#include <knotifyclient.h>
#include <kprocess.h>

#include "adapterconfigdialog.h"
#include "devicewizard.h"

class TQTimer;
class TDEToggleAction;
class TDEAction;
class TDEActionMenu;
class TDEPopupMenu;
class KHelpMenu;
class TDEBluetoothApp;

/**
 @author Fred Schaettgen
 */
class TrayIcon: public KSystemTray
{
    TQ_OBJECT

public:
    TrayIcon(TDEBluetoothApp* app);
    ~TrayIcon();
    //	void setAlwaysShowIcon(bool state);

private slots:
    // void slotQuitSelected();
    //	void slotShowIconToggled(bool);
    void slotServiceConfig();
    //	void slotPairedConfig();
    void slotDeviceConfig();
    void slotAdapterConfig();
    void slotInputConfig();
    void slotkbluemonitor();
    void slotkbluelock();
    //	void slotkbtobexclient();
    void slotConfigureNotifications()
    {
        KNotifyDialog::configure(this);
    }
    ;
    void slotQuitSelected();
    void slotReportBug()
    {
        helpMenu->reportBug();
    }
    ;
    void slotAbout()
    {
        helpMenu->aboutApplication();
    }
    ;
    void slotShowHelp();
//    void slotSearchIcon();
    void slotIconAutostartToggled(bool state);
    void slotIconAgentToggled(bool state);
    void slotIconObexToggled(bool state);
    // gui -> manager
    void slotPowerOn(bool state);
    // manager -> gui
    void slotPowerOnChanged(const TQString&, bool);
    void slotDeviceConnectedChanged(const TQString&, bool);
    void slotAddAdapter(const TQString&);
    void slotRemoveAdapter(const TQString&);
    void slotDiscoverableTimeoutChanged(const TQString&, TQ_UINT32 timeout);
    void slotDiscoverableChanged(const TQString&, bool state);
    //	void slotDiscoveringChanged(const TQString&, bool state);
    void slotUpdateToolTip(const TQString& adapter, const TQString& name);
    void slotAdapterAliasChanged(const TQString&, const TQString&);

protected:
    void mousePressEvent(TQMouseEvent *e);

private:
//    TQTimer *blinkTimer;
    bool iconConnectingBlinkState;

    KHelpMenu *helpMenu;
    TDEBluetoothApp* app;

    AdapterConfigDialog *adapterConfigDialog; // for BT Adapters
    DeviceWizard *deviceWizard; // for BT Devices

    bool acceptClose;
    KPixmap iconIdle;
    KPixmap iconConnected;
    KPixmap iconNoAdapter;
    KPixmap iconOff;

    TDEToggleAction *agentIconAction;
    TDEToggleAction *obexIconAction;
    //	TDEToggleAction *showIconAction;
    TDEToggleAction *autostartIconAction;
    TQMap<TQString, TDEToggleAction *> showPowerOnActionMap;

    TDEAction *serviceConfigAction;
    //	TDEAction *pairedConfigAction;
    TDEAction *adapterConfigAction;
    TDEAction *deviceConfigAction;
    //	TDEAction *inputConfigAction;
    TDEAction *showHelpAction;
    TDEAction *kbluemonAction;
    TDEAction *kbluelockAction;
    TDEAction *kbtobexclientAction;
    TDEAction *aboutAction;
    TDEActionMenu *configActionMenu;
    TDEActionMenu *helpActionMenu;

    void setupTray(bool);
    void updateIcon();

    void updateTooltip(const TQString &text);

    TQString localAndEnglish(const TQCString& s);

signals:
    //	void setObexSrv(bool);
    void setPowerOn(bool);

};

#endif
