/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2008
*/
#ifndef KMFTRANSACTION_H
#define KMFTRANSACTION_H

#include "tqdict.h"
#include "tqvaluelist.h"
#include "tqptrlist.h"
#include "tqstring.h"
#include "tqobject.h"
#include "tquuid.h"
#include "tqguardedptr.h"


namespace KMF {
class NetfilterObject;
/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/

class KMFTransaction{
	friend class KMFUndoEngine;
	public:
    	KMFTransaction( const TQString& transactionName, NetfilterObject* );
    	~KMFTransaction();
		const TQString& name() const {
			return m_transactionName;
		};
		
		const TQUuid& objectUuid() const {
			return m_objectUuid;
		};
		
		const TQUuid& uuid() const {
			return m_uuID;
		};
		const TQString& toString();
		
		const TQString& undoXML() const {
			return m_undoXML;
		};
		
		const TQString& redoXML() const {
			return m_redoXML;
		};
		
	private: 
		KMFTransaction();
		void commit();
		NetfilterObject* undo();
		NetfilterObject* redo();
		
	private:
		 TQString m_transactionName;
		// int m_objectID;
		 TQUuid m_objectUuid;
		 
		 TQUuid m_uuID;
		 TQString m_undoXML; 
		 TQString m_redoXML; 
};
}
#endif
