//
// C++ Interface: kmfiptablesdocumentconverter
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
// License: GPL
//
#ifndef KMFIPTABLESDOCUMENTCONVERTER_H
#define KMFIPTABLESDOCUMENTCONVERTER_H

/**
@author Christian Hubinger
*/

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqvaluelist.h>


namespace KMF {
class KMFNetZone;
class KMFNetHost;
class IPTRule;
class IPTChain;
class IPTable;
class KMFIPTDoc;
class KMFProtocol;
class KMFProtocolUsage;
class KMFGenericDoc;
class KMFErrorHandler;
class KMFError;


class KMFIPTablesDocumentConverter{
public:
    KMFIPTablesDocumentConverter();

    ~KMFIPTablesDocumentConverter();
	KMFIPTDoc* compileToIPTDoc( KMFGenericDoc* doc );

private:
	void addToChains( KMFNetZone*, KMFIPTDoc* , IPTChain*, const TQString& );
	void createRules( KMFNetZone*, IPTChain*, const TQString& );
	void setupLocalhostRules(  KMFGenericDoc*, KMFIPTDoc* );
	void setupConnectionTracking( KMFIPTDoc* );
	void setupPolicies( KMFGenericDoc*, KMFIPTDoc* );
	void createZoneProtocolRules( IPTChain*, KMFProtocolUsage* );
	void createZoneProtocol( IPTChain*, KMFProtocolUsage* prot , const TQString& option, const TQString& ports );
	void createHostProtocolRules( IPTChain*, KMFNetHost*, KMFProtocolUsage*, const TQString& );
	void createHostProtocol( IPTChain*, KMFNetHost*, KMFProtocolUsage* prot , const TQString& option, const TQString&, const TQString& );
	void setupInAndOutHosts( KMFIPTDoc*, KMFNetZone*,  const TQString& );
	void setupForbiddenHosts( KMFIPTDoc*, KMFNetZone*, const TQString&  );
	
	void setupICMPRules( KMFGenericDoc*, KMFIPTDoc* );
	
	void setupNatRules( KMFGenericDoc*, KMFIPTDoc* );
	void setupNatTarget( KMFGenericDoc*, IPTRule* );
	void setupLogging( KMFGenericDoc*, KMFIPTDoc* );
	void setupLoggingRules( KMFGenericDoc*, IPTChain* );

private: // DATA
	KMFGenericDoc *m_genericDoc;
	KMFErrorHandler *m_errorHandler;
	KMFError *m_err;
	KMFIPTDoc *m_iptdoc;
};
}
#endif
