#include "process.h"




	Process::Process()
	{
		_buffer = TQString();
		_process = new TDEProcess();
	
		connect(_process, TQ_SIGNAL(receivedStdout(TDEProcess*, char*, int)),
			this, TQ_SLOT(slotProcessOutput(TDEProcess*, char*, int)));
	
	}
	
	Process::~Process()
	{
	}
	
	void Process::setCommand(TQString command)
	{
		// make clean
		_process->clearArguments();
		_buffer = TQString();
		
		*_process << "/bin/bash";
		*_process << "-c";
		*_process << command;
	}
	
	
	void Process::start(bool block)
	{
		if( block )
			_process->start(TDEProcess::Block, TDEProcess::Stdout);
		else
			_process->start(TDEProcess::DontCare, TDEProcess::Stdout);
	}
	
	TQString Process::getBuffer()
	{
		return _buffer;
	}
	
	int Process::exitStatus()
	{
		return _process->exitStatus();
	}
	
	bool Process::normalExit()
	{
		return _process->normalExit();
	}
	
	void Process::slotProcessOutput(TDEProcess* process, char* buffer, int len)
	{
		if (process != _process) return;
	
		_buffer.append(TQString::fromLocal8Bit(buffer, len));
	}

#include "process.moc"

