/***************************************************************************
                          lircsupport.h  -  description
                             -------------------
    begin                : Mon Feb 4 2002
    copyright            : (C) 2002 by Martin Witte / Frank Schwanz
    email                : witte@kawo1.rwth-aachen.de / schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LIRCSUPPORT_H
#define LIRCSUPPORT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqobject.h>
#include "../../src/include/timecontrol_interfaces.h"
#include "../../src/include/radio_interfaces.h"
#include "../../src/include/radiodevicepool_interfaces.h"
#include "../../src/include/soundstreamclient_interfaces.h"
#include "../../src/include/plugins.h"


enum LIRC_Actions {
    LIRC_DIGIT_0,
    LIRC_DIGIT_1,
    LIRC_DIGIT_2,
    LIRC_DIGIT_3,
    LIRC_DIGIT_4,
    LIRC_DIGIT_5,
    LIRC_DIGIT_6,
    LIRC_DIGIT_7,
    LIRC_DIGIT_8,
    LIRC_DIGIT_9,
    LIRC_POWER_ON,
    LIRC_POWER_OFF,
    LIRC_PAUSE,
    LIRC_RECORD_START,
    LIRC_RECORD_STOP,
    LIRC_VOLUME_INC,
    LIRC_VOLUME_DEC,
    LIRC_CHANNEL_NEXT,
    LIRC_CHANNEL_PREV,
    LIRC_SEARCH_NEXT,
    LIRC_SEARCH_PREV,
    LIRC_SLEEP,
    LIRC_APPLICATION_QUIT
};


struct lirc_config;
class TQSocketNotifier;
class TQTimer;

class LircSupport : public TQObject,
                    public PluginBase,
                    public IRadioClient,
                    public ITimeControlClient,
                    public ISoundStreamClient,
                    public IRadioDevicePoolClient
{
TQ_OBJECT
  
public:
    LircSupport(const TQString &name);
    ~LircSupport();

    virtual bool connectI (Interface *);
    virtual bool disconnectI (Interface *);

    virtual TQString pluginClassName() const { return "LircSupport"; }

    virtual const TQString &name() const { return PluginBase::name(); }
    virtual       TQString &name()       { return PluginBase::name(); }


    virtual void                               setActions(const TQMap<LIRC_Actions, TQString> &actions, const TQMap<LIRC_Actions, TQString> &alt_actions);
    virtual const TQMap<LIRC_Actions, TQString> &getActions()            const { return m_Actions; }
    virtual const TQMap<LIRC_Actions, TQString> &getAlternativeActions() const { return m_AlternativeActions; }

    // PluginBase

public:
    virtual void   saveState (TDEConfig *) const;
    virtual void   restoreState (TDEConfig *);

    virtual ConfigPageInfo  createConfigurationPage();
    virtual AboutPageInfo   createAboutPage();

    // IRadioClient methods

RECEIVERS:
    bool noticePowerChanged(bool /*on*/)                          { return false; }
    bool noticeStationChanged (const RadioStation &, int /*idx*/) { return false; }
    bool noticeStationsChanged(const StationList &/*sl*/)         { return false; }
    bool noticePresetFileChanged(const TQString &/*f*/)            { return false; }

    bool noticeCurrentSoundStreamIDChanged(SoundStreamID /*id*/)  { return false; }

    // ITimeControlClient

RECEIVERS:
    bool noticeAlarmsChanged(const AlarmVector &)      { return false; }
    bool noticeAlarm(const Alarm &)                    { return false; }
    bool noticeNextAlarmChanged(const Alarm *)         { return false; }
    bool noticeCountdownStarted(const TQDateTime &/*end*/) { return false; }
    bool noticeCountdownStopped()                      { return false; }
    bool noticeCountdownZero()                         { return false; }
    bool noticeCountdownSecondsChanged(int /*n*/)      { return false; }

    // IRadioDevicePoolClient

RECEIVERS:
    bool noticeActiveDeviceChanged(IRadioDevice *)     { return false; }
    bool noticeDevicesChanged(const TQPtrList<IRadioDevice> &)  { return false; }
    bool noticeDeviceDescriptionChanged(const TQString &) { return false; }


protected:
    void     activateStation(int i);
    bool     checkActions(const TQString &string, int repeat_counter, const TQMap<LIRC_Actions, TQString> &map);

protected slots:
    void slotLIRC(int socket);
    void slotKbdTimedOut();

signals:

    void sigUpdateConfig();

    void sigRawLIRCSignal(const TQString &what, int repeat_counter, bool &consumed);

protected:

    TQSocketNotifier        *m_lirc_notify;
    int                     m_fd_lirc;
    struct lirc_config     *m_lircConfig;

    TQTimer                 *m_kbdTimer;
    int                     m_addIndex;
    bool                    m_TakeRawLIRC;

    TQMap<LIRC_Actions, TQString>  m_Actions;
    TQMap<LIRC_Actions, TQString>  m_AlternativeActions;
};



#endif
