/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_NOTATIONSELECTIONPASTER_H_
#define _RG_NOTATIONSELECTIONPASTER_H_

#include "NotationTool.h"
#include "base/Event.h"


class TQMouseEvent;


namespace Rosegarden
{

class ViewElement;
class NotationView;
class EventSelection;


/**
 * Selection pasting - unused at the moment
 */
class NotationSelectionPaster : public NotationTool
{
public:

    ~NotationSelectionPaster();
    
    virtual void handleLeftButtonPress(timeT,
                                       int height, int staffNo,
                                       TQMouseEvent*,
                                       ViewElement* el);

protected:
    NotationSelectionPaster(EventSelection&,
                            NotationView*);

    //--------------- Data members ---------------------------------

    EventSelection& m_selection;

};



}

#endif
