/*
 * systemtray.cpp
 *
 * Copyright (C) 2003-2005 Jürgen Kofler <kaffeine@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeglobal.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdepopupmenu.h>
#include <tdeaction.h>

#include <tqtimer.h>
#include <tqlabel.h>
#include <tqtooltip.h>

#include "systemtray.h"
#include "systemtray.moc"


class TitleLabel : public TQLabel
{

public:
	TitleLabel() : TQLabel(0, "tray_osd", WStyle_Customize | WStyle_NoBorder | WStyle_StaysOnTop | WX11BypassWM)
	{}
	virtual ~TitleLabel() {}

protected:
	void enterEvent(TQEvent*)
	{
		hide();
	}
};

SystemTray::SystemTray(TQWidget *parent, const char *name ) : KSystemTray(parent,name)
{
	kdDebug() << "SystemTray: Create System Tray" << endl;


	TDEAction* play = new TDEAction(i18n("Play / Pause"), "media-playback-start", 0, this, TQ_SIGNAL(signalPlay()), actionCollection(), "trayplay");
	TDEAction* next = new TDEAction(i18n("&Next"), "go-next", 0, this, TQ_SIGNAL(signalNext()), actionCollection(), "traynext");
	TDEAction* previous = new TDEAction(i18n("&Previous"), "go-previous", 0, this, TQ_SIGNAL(signalPrevious()), actionCollection(), "trayprevious");
	TDEAction* stop = new TDEAction(i18n("Stop"), "media-playback-stop", 0, this, TQ_SIGNAL(signalStop()), actionCollection(), "traystop");
	TDEAction* mute = new TDEAction(i18n("&Mute"), "player_mute", 0, this, TQ_SIGNAL(signalMute()), actionCollection(), "traymute");

	play->plug(contextMenu());
	next->plug(contextMenu());
	previous->plug(contextMenu());
	stop->plug(contextMenu());
	mute->plug(contextMenu());

	m_osd = new TitleLabel;
	m_osd->setFrameStyle(TQFrame::Panel | TQFrame::Plain);
	m_osd->setLineWidth(1);
	m_osd->setAlignment(SingleLine);
	connect(&m_hideTimer, TQ_SIGNAL(timeout()), this, TQ_SLOT(slotHideOSD()));

	setPixmap(TDEGlobal::iconLoader()->loadIcon("kaffeine", TDEIcon::Panel, 22));
	TQToolTip::add(this, i18n("Kaffeine Player"));
}


SystemTray::~SystemTray()
{}

void SystemTray::wheelEvent(TQWheelEvent *e)
{
	if(e->delta() < 0)
		actionCollection()->action("traynext")->activate();
	else
		actionCollection()->action("trayprevious")->activate();
	e->accept();
}

void SystemTray::mousePressEvent(TQMouseEvent *e)
{
	switch(e->button()) {
	case TQt::LeftButton:
	case TQt::RightButton:
	default:
		KSystemTray::mousePressEvent(e);
		break;
	case MidButton:
		if(!rect().contains(e->pos()))
			return;
		actionCollection()->action("trayplay")->activate();
		break;
    }
}

void SystemTray::showTitle(const TQString& title, uint secs)
{
	if (title.isEmpty())
		return;

	TQToolTip::remove(this); // all the time remove it before add it.
	TQToolTip::add(this, title);
	if (secs > 0)
	{
		m_osd->setText(TQString("<nobr><b>") + title + "</b></nobr>");
		m_osd->adjustSize();
		TQPoint global = mapToGlobal(TQPoint(0,0));
		m_osd->move(global.x() - m_osd->width() + 10, global.y() - m_osd->height() + 15);
		m_osd->show();
		m_hideTimer.start(secs * 1000);
	}
}

void SystemTray::slotHideOSD()
{
	m_osd->hide();
	m_hideTimer.stop();
}
