//
// C++ Interface: k9cddrive
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9CDDRIVE_H
#define K9CDDRIVE_H
#include "k9common.h"

#include <tqobject.h>

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqvaluelist.h>
#include <k3bdevice.h>
#include <k3bdevicemanager.h>


/**
  *@author 
  */
class k9CdDrive : public TQObject {
    TQ_OBJECT
  
public:
    k9CdDrive();
    ~k9CdDrive();
    int num;
    TQString name;
    TQString device;
    bool canWriteCDR;
    bool canReadDVD;
    bool canWriteDVD;

    void setWriteSpeeds(const TQValueList< int >& _value);
    TQValueList< int > getWriteSpeeds() const;

private:
   TQValueList <int> writeSpeeds;
};

class k9CdDrives : public TQObject  {
    TQ_OBJECT
  
public:
    k9CdDrives();
    ~k9CdDrives();
    /** No descriptions */
    int count();
    /** No descriptions */
    k9CdDrive * getDrive(int num);
    void eject(const TQString & device);
    void scanDrives();
signals:
    void deviceAdded(k9CdDrive *drive);
    void deviceRemoved(k9CdDrive *drive);
private: // Private methods
    K3bDevice::DeviceManager *m_devMgr;
    void readConfig();
    TQPtrList <k9CdDrive> drives;
};
#endif
