/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*                                                                         *
*   Copyright (C) 2003-2005 by                                            *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef DEPENDANCIESDIALOG_H
#define DEPENDANCIESDIALOG_H

#include <tqgroupbox.h>
#include <tqlabel.h>

#include <tdelistview.h>
#include <kdialogbase.h>

#include "datablocks/elementlist.h"

struct ListInfo {
	ElementList list;
	TQString name;
};

/**
@author Unai Garro
*/
class DependanciesDialog: public KDialogBase
{
public:
	//Methods
	DependanciesDialog( TQWidget *parent, const TQValueList<ListInfo> &lists, bool deps_are_deleted = true );
	DependanciesDialog( TQWidget *parent, const ListInfo &list, bool deps_are_deleted = true );

	~DependanciesDialog();

	void setCustomWarning( const TQString &msg ){ m_msg = msg; }

public slots:
	void accept();

private:
	//Widgets
	TQLabel *instructionsLabel;

	bool m_depsAreDeleted;
	TQString m_msg;

	// Methods
	void init( const TQValueList<ListInfo> &lists );
	void loadList( TDEListBox*, const ElementList &list );
};

#endif
