/***************************************************************************
    smb4ksharesview_part  -  This Part includes the shares icon view
    of Smb4K.
                             -------------------
    begin                : Mo Dez 4 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHARESICONVIEW_PART_H
#define SMB4KSHARESICONVIEW_PART_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <tdeparts/part.h>
#include <tdeparts/factory.h>

// applications specific includes
#include "smb4ksharesiconview.h"

/**
 * This is one of the parts of Smb4K. It contains the shares icon
 * view.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSharesIconViewPart : public KParts::Part
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor.
     *
     * @param parentWidget        The parent widget
     *
     * @param widgetName          The name the widget should have
     *
     * @param parent              The parent object
     *
     * @param name                The name this object should have
     */
    Smb4KSharesIconViewPart( TQWidget *parentWidget = 0, const char *widgetName = 0,
                             TQObject *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    virtual ~Smb4KSharesIconViewPart();

  protected:
    /**
     * Reimplemented from KParts::Part.
     */
    void customEvent( TQCustomEvent *e );

  protected slots:
    /**
     * Opens a context menu over the icon view item @p item at position
     * @p pos if requested.
     *
     * @param item                The icon view item or NULL if the user clicked
     *                            somewhere else.
     *
     * @param pos                 The position where the user clicked.
     */
    void slotContextMenuRequested( TQIconViewItem *item, const TQPoint & pos );

    /**
     * This slot is called when the selection in the icon view changed. It
     * enables or disables the actions according to known options/states.
     * Please note that it won't be invoked when the user clicked on the
     * viewport. Use slotMouseButtonPressed() to also catch that event.
     *
     * @param item                The icon view item that was selected
     */
    void slotSelectionChanged( TQIconViewItem *item );

    /**
     * This slot is called when the user presses any mouse button somewhere
     * in the icon view. It enables or disables the actions according to known
     * options/states.
     *
     * @param item                The icon view item that was clicked or NULL if the
     *                            user clicked onto the viewport.
     */
    void slotMouseButtonPressed( TQIconViewItem *item );

    /**
     * This slot is called by the Smb4KMounter::updated() signal and updates
     * the icon view according to the list that is returned by Smb4KMounter::getShares().
     */
    void slotMountedShares();

    /**
     * This slot is connected to the 'Unmount action'. You will be able to
     * unmount a certain share when activating this slot.
     */
    void slotUnmountShare();

    /**
     * This slot is connected to the 'Force Unmounting' action and is, thus,
     * only useful under Linux, because only there the possibility for a forced
     * (i.e. lazy) unmount exists.
     *
     * When activating this slot, the selected share will be unmounted, even if
     * it is not accessible or the server already went offline.
     */
    void slotForceUnmountShare();

    /**
     * This slot is connected to the 'Unmount All' action. All shares - either of
     * the user or that are present on the system (depending on the settings the
     * user chose) - will be unmounted. Please note that Smb4KMounter::unmountAllShares()
     * is invoked directly.
     */
    void slotUnmountAllShares();

    /**
     * This slot is connected to the 'Synchronize' action. The current item will be
     * synchronized with a local copy (or vice versa) if you activate it.
     */
    void slotSynchronize();

    /**
     * This slot is connected to the 'Konsole' action. The mount point of the current
     * share item will be opened in Konsole.
     */
    void slotKonsole();

    /**
     * This slot is connected to the 'Konqueror' action. The contents of the current
     * share item will be opened in the file manager.
     */
    void slotFilemanager();

    /**
     * This slot is called by the synchronizer whenever the state of the synchronization
     * process changed.
     *
     * @param state             The state the synchronizer is in.
     */
    void slotSynchronizationState( int state );

  private:
    /**
     * Set up the actions
     */
    void setupActions();

    /**
     * Load settings for the widget or the actions.
     */
    void loadSettings();

    /**
     * The icon view.
     */
    Smb4KSharesIconView *m_widget;

    /**
     * The action menu.
     */
    TDEActionMenu *m_menu;
};


class TDEInstance;
class TDEAboutData;

class Smb4KSharesIconViewPartFactory : public KParts::Factory
{
  TQ_OBJECT
  

  public:
    /**
     * The constructor
     */
    Smb4KSharesIconViewPartFactory();

    /**
     * The destructor
     */
    virtual ~Smb4KSharesIconViewPartFactory();

    /**
     * Reimplemented from KParts::Factory
     */
    virtual KParts::Part *createPartObject( TQWidget *parentWidget, const char *widgetName,
                                            TQObject *parent, const char *name,
                                            const char *classname, const TQStringList &args );

    /**
     * The instance
     */
    static TDEInstance *instance();

  private:
    /**
     * The factory's instance.
     */
    static TDEInstance *m_instance;

    /**
     * The factory's TDEAboutData object
     */
    static TDEAboutData *m_about;
};


#endif
