/*
 * kbiffurl.h
 * Copyright (C) 1999 Kurt Granroth <granroth@kde.org>
 * Copyright (C) 1999 Bjorn Hansson <Bjorn.Hansson@signal.uu.se>
 *
 * $Id$
 *
 */
#ifndef KBIFFURL_H
#define KBIFFURL_H

#include <kurl.h>

/**
 * This is a simple extension to the KURL class.
 */
class KBiffURL : public KURL
{
public:
	/**
	 * Default constructor
	 */
	KBiffURL();

	/**
	 * Construct a KBiffURL object from _url
	 */
	KBiffURL(const TQString& _url);

	/**
	 * Returns the parameter value found in the search part of the URL
	 */
	TQString searchPar( const TQString & _parName ) const;

	/**
	 * Sets a parameter value in the search part of the URL
	 */
	void setSearchPar( const TQString & _parName, const TQString & _newParVal );

	TQString pass() const;

private:
	/**
	 * Returns the position of a parameter within the search part
	 */
	int findPos( const TQString & _searchPart, const TQString & _parName ) const;
};
#endif // KBIFFURL_H
