/***************************************************************************
 *   Copyright (C) 2006-2012 by Thomas Schweitzer                          *
 *   thomas-schweitzer(at)arcor.de                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2.0 as   *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program in the file LICENSE.GPL; if not, write to the *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef INDENTHANDLER_H
#define INDENTHANDLER_H

#include <tqwidget.h>
#include <tqvaluevector.h>

class MainWindow;
class UiGuiErrorMessage;
class UiGuiIniFileParser;
class UiGuiSettings;

class TQCheckBox;
class TQComboBox;
class TQLabel;
class TQLineEdit;
class TQSpinBox;
class TQToolBox;
class TQToolButton;
class TQVBoxLayout;


class IndentHandler : public TQWidget
{
	TQ_OBJECT

	public:
		IndentHandler(int indenterID, MainWindow *mainWindow = nullptr, TQWidget *parent = nullptr);
		~IndentHandler();

		TQString          generateShellScript(const TQString &configFilename);
		TQString          callIndenter(const TQString &sourceCode, const TQString &inputFileExtension);
		bool              loadConfigFile(const TQString &filePathName);
		void              resetToDefaultValues();
		TQStringList      getAvailableIndenters();
		TQString          getPossibleIndenterFileExtensions();
		TQString          getParameterString();
		TQString          getIndenterCfgFile();
		TQString          getManual();
		TQString          getCurrentIndenterName();
		void              contextMenuEvent(TQContextMenuEvent *event);

	signals:
		void indenterSettingsChanged();

	private slots:
		void setIndenter(int indenterID);
		void showIndenterManual() const;
		void openConfigFileDialog();
		void saveasIndentCfgFileDialog();
		void createIndenterCallShellScript();
		void resetIndenterParameter();
		void handleChangedIndenterSettings();
		void indenterProcessFinished();

	private:
		TQString callExecutableIndenter(const TQString &sourceCode, const TQString &inputFileExt);
		void     saveConfigFile(const TQString &filePathName, const TQString &parameterString);
		void     readIndentIniFile(const TQString &iniFilePath);
		bool     createIndenterCallString();

		// Holds a reference to all created pages of the parameter categories toolbox and their layout
		struct IndenterParameterCategoryPage
		{
			TQWidget     *widget;
			TQVBoxLayout *vboxLayout;
		};
		TQValueVector<IndenterParameterCategoryPage> m_indenterParameterCategoryPages;

		// Holds a reference to all checkboxes needed for boolean parameters and their names
		struct ParamBoolean
		{
			TQString    paramName;
			TQString    trueString;
			TQString    trueRegexString;
			TQString    falseString;
			TQString    falseRegexString;
			TQCheckBox *checkBox;
		};
		TQValueVector<ParamBoolean> m_paramBooleans;

		// Holds a reference to all line edits needed for parameter setting and the parameters name
		struct ParamString
		{
			TQString    paramName;
			TQString    paramCallName;
			TQString    paramCallNameRegex;
			TQCheckBox *valueEnabledChkBox;
			TQLineEdit *lineEdit;
			TQLabel    *label;
		};
		TQValueVector<ParamString> m_paramStrings;

		// Hold a reference to all spin boxes needed for parameter setting and the parameters name
		struct ParamNumeric
		{
			TQString    paramName;
			TQString    paramCallName;
			TQString    paramCallNameRegex;
			TQCheckBox *valueEnabledChkBox;
			TQSpinBox  *spinBox;
			TQLabel    *label;
		};
		TQValueVector<ParamNumeric> m_paramNumerics;

		// Hold a reference to all combo boxes needed for parameter setting and the parameters name
		struct ParamMultiple
		{
			TQString     paramName;
			TQCheckBox  *valueEnabledChkBox;
			TQComboBox  *comboBox;
			TQStringList choicesStrings;
			TQStringList choicesRegexStrings;
			TQStringList choicesReadableStrings;
		};
		TQValueVector<ParamMultiple> m_paramMultiples;

		UiGuiSettings      *m_settings;

		TQComboBox         *m_indenterSelectionCombobox;
		TQToolButton       *m_indenterParameterHelpButton;
		// Vertical layout box, into which the toolbox will be added
		TQVBoxLayout       *m_toolBoxContainerLayout;
		TQToolBox          *m_indenterParameterCategoriesToolBox;
		UiGuiIniFileParser *m_indenterSettings;
		TQStringList        m_indenterParameters;
		// The indenters name in a descriptive form
		TQString            m_indenterName;
		TQString            m_indenterConfigFilename;
		// The indenters file name (w/o extension), that is being called
		TQString            m_indenterFileName;
		TQString            m_indenterDirectoryStr;
		TQString            m_tempDirectoryStr;
		TQString            m_settingsDirectoryStr;
		TQStringList        m_indenterIniFileList;
		TQString            m_globalConfigFilename;
		TQString            m_cfgFileParameterEnding;
		TQString            m_parameterOrder;
		TQString            m_inputFileParameter;
		TQString            m_inputFileName;
		TQString            m_outputFileParameter;
		TQString            m_outputFileName;
		TQString            m_fileTypes;
		TQString            m_useCfgFileParameter;
		TQString            m_indenterShowHelpParameter;
		MainWindow         *m_mainWindow;
		TQWidget           *m_parent;
		UiGuiErrorMessage  *m_errorMessageDialog;
		TQString            m_indenterExecutableCallString;
		TQString            m_indenterExecutableSuffix;
		bool                m_indenterProcessFinished;

		//TODO: This function should go into a string helper/tool class/file.
		TQString           encodeToHTML(const TQString &text);

		friend class UiGuiInfoDialog;
};

#endif // INDENTHANDLER_H
