#include <tqsql.h>
#include <tqsqldatabase.h>
#include <tqstringlist.h>
#include <iostream>
#include <tqapplication.h>
#include <tqtextstream.h>

#include "svnqt/client.h"
#include "svnqt/svnqttypes.h"

#include "svnqt/cache/LogCache.h"
#include "svnqt/cache/ReposLog.h"
#include "svnqt/cache/test/testconfig.h"
#include "svnqt/cache/DatabaseException.h"

int main(int argc,char**argv)
{
    TQApplication app(argc,argv);

    svn::ContextP m_CurrentContext;
    svn::Client* m_Svnclient;
    m_Svnclient=svn::Client::getobject(0,0);
    m_CurrentContext = new svn::Context();

    m_Svnclient->setContext(m_CurrentContext);

    TQStringList list;
    TQStringList::Iterator it;
    // goes into "self" of logcache
    new svn::cache::LogCache(TESTDBPATH);
    list = TQSqlDatabase::drivers();
    it = list.begin();
    while( it != list.end() ) {
        std::cout << (*it).TOUTF8().data() << std::endl;
        ++it;
    }
    svn::cache::ReposLog rl(m_Svnclient,"http://www.alwins-world.de/repos/tdesvn");
    TQDataBase db = rl.Database();
    if (!db) {
        std::cerr << "No database object."<<std::endl;
        exit(-1);
    }
    list = db->tables();
    it = list.begin();
    while( it != list.end() ) {
        std::cout << ( *it ).TOUTF8().data() << std::endl;
        ++it;
    }
    svn::LogEntriesMap lm;
    try {
        rl.simpleLog(lm,100,svn::Revision::HEAD);
    }
    catch (const svn::cache::DatabaseException&cl)
    {
        std::cerr << cl.msg().TOUTF8().data() <<std::endl;
    }
    catch (const svn::Exception&ce)
    {
        std::cerr << "Exception: " << ce.msg().TOUTF8().data() <<std::endl;
    }
    svn::LogEntriesMap::ConstIterator lit = lm.begin();
    std::cout<<"Count: "<<lm.count()<<std::endl;

    svn::Revision r("{2006-09-27}");
    std::cout << r.toString().TOUTF8().data() << " -> " << rl.date2numberRev(r).toString().TOUTF8().data()<<std::endl;
    r = svn::Revision::HEAD;
    std::cout << rl.date2numberRev(r).toString().TOUTF8().data()<<std::endl;
    try {
        rl.insertLogEntry(lm[100]);
    }
    catch (const svn::cache::DatabaseException&cl)
    {
        std::cerr << cl.msg().TOUTF8().data() << std::endl;
    }
    TQSqlQuery q("insert into logentries(revision,date,author,message) values ('100','1122591406','alwin','copy and moving works now in basic form')",db);
    q.exec();
    std::cerr << "\n" << q.lastError().text().TOUTF8().data()<<std::endl;

    try {
        rl.log("/trunk/src/svnqt",1,1000,svn::Revision::UNDEFINED,lm,false,-1);
    }
    catch (const svn::cache::DatabaseException&cl)
    {
        std::cerr << cl.msg().TOUTF8().data() <<std::endl;
    }
    catch (const svn::Exception&ce)
    {
        std::cerr << "Exception: " << ce.msg().TOUTF8().data() <<std::endl;
    }
    std::cout<<"Count: "<<lm.count()<<std::endl;
    return 0;
}
