/* This file is part of the KDE project
   Copyright (C) 2003 Alexander Dymo <cloudtemple@mksat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include <tqcheckbox.h>
#include <tqlabel.h>
#include "removesubprojectdialog.h"

RemoveSubprojectDialog::RemoveSubprojectDialog(TQString caption, TQString question, TQWidget* parent, const char* name, bool modal, WFlags fl)
    : RemoveSubprojectDlgBase(parent,name, modal,fl)
{
    setCaption(caption);
    removeLabel->setText(question);
}

RemoveSubprojectDialog::~RemoveSubprojectDialog()
{
}

/*$SPECIALIZATION$*/
void RemoveSubprojectDialog::reject()
{
    TQDialog::reject();
}

void RemoveSubprojectDialog::accept()
{
    TQDialog::accept();
}

bool RemoveSubprojectDialog::removeFromDisk( )
{
    return removeCheckBox->isChecked();
}


#include "removesubprojectdialog.moc"

