/*=========================================================================
| KCalDAV
|--------------------------------------------------------------------------
| (c) 2010  Timothy Pearson
| (c) 2009  Kumaran Santhanam (initial KDE4 version)
|
| This project is released under the GNU General Public License.
| Please see the file COPYING for more details.
|--------------------------------------------------------------------------
| Remote calendar loading.
 ========================================================================*/

/*=========================================================================
| INCLUDES
 ========================================================================*/

#include "reader.h"
#include <kdebug.h>
#include <kcharsets.h>
#include <string>

/*=========================================================================
| NAMESPACE
 ========================================================================*/

using namespace KCal;

/*=========================================================================
| METHODS
 ========================================================================*/

void CalDavReader::cleanJob() {
    CalDavJob::cleanJob();
    mData = "";
}

void CalDavReader::cleanTasksJob() {
    CalDavJob::cleanJob();
    mTasksData = "";
}

void CalDavReader::cleanJournalsJob() {
    CalDavJob::cleanJob();
    mJournalsData = "";
}

int CalDavReader::runJob(runtime_info* RT) {
    kdDebug() << "reader::run, url: " << url() << '\n';

    response* result = caldav_get_response();
    CALDAV_RESPONSE res = OK;

    if ((OK == res) && (url() != "")) {
      if (mGetAll) {
          kdDebug() << "getting all objects" << '\n';
          res = caldav_getall_object(result, std::string(url().ascii()).c_str(), RT);
      } else {
          kdDebug() << "getting object from the specified time range" << '\n';
          res = caldav_get_object(result, mTimeStart.toTime_t(), mTimeEnd.toTime_t(), std::string(url().ascii()).c_str(), RT);
      }

      if (OK == res) {
          kdDebug() << "success" << '\n';
          if (result->msg) {
              mData = KCharsets::resolveEntities(TQString::fromUtf8(result->msg));
          } else {
              kdDebug() << "empty collection" << '\n';
              // empty collection
              mData = "";
          }
      }
    }

    caldav_free_response(&result);

    return res;
}

int CalDavReader::runTasksJob(runtime_info* RT) {
    kdDebug() << "reader::run, tasksUrl: " << tasksUrl() << '\n';

    response* result = caldav_get_response();
    CALDAV_RESPONSE tasksres = OK;

    if ((OK == tasksres) && (tasksUrl() != "")) {
      kdDebug() << "reader::run, url: " << tasksUrl() << '\n';

      if (mGetAll) {
          kdDebug() << "getting all objects" << '\n';
          tasksres = caldav_tasks_getall_object(result, std::string(tasksUrl().ascii()).c_str(), RT);
      } else {
          kdDebug() << "getting object from the specified time range" << '\n';
          tasksres = caldav_tasks_get_object(result, mTimeStart.toTime_t(), mTimeEnd.toTime_t(), std::string(tasksUrl().ascii()).c_str(), RT);
      }

      if (OK == tasksres) {
          kdDebug() << "success" << '\n';
          if (result->msg) {
              mTasksData = KCharsets::resolveEntities(TQString::fromUtf8(result->msg));
          } else {
              kdDebug() << "empty collection" << '\n';
              // empty collection
              mTasksData = "";
          }
      }

      caldav_free_response(&result);
    }

    return tasksres;
}

int CalDavReader::runJournalsJob(runtime_info* RT) {
    kdDebug() << "reader::run, journalsUrl: " << journalsUrl() << '\n';

    response* result = caldav_get_response();
    CALDAV_RESPONSE journalsres = OK;

    if ((OK == journalsres) && (journalsUrl() != "")) {
      kdDebug() << "reader::run, url: " << journalsUrl() << '\n';

      if (mGetAll) {
          kdDebug() << "getting all objects" << '\n';
          journalsres = caldav_tasks_getall_object(result, std::string(journalsUrl().ascii()).c_str(), RT);
      } else {
          kdDebug() << "getting object from the specified time range" << '\n';
          journalsres = caldav_tasks_get_object(result, mTimeStart.toTime_t(), mTimeEnd.toTime_t(), std::string(journalsUrl().ascii()).c_str(), RT);
      }

      if (OK == journalsres) {
          kdDebug() << "success" << '\n';
          if (result->msg) {
              mJournalsData = KCharsets::resolveEntities(TQString::fromUtf8(result->msg));
          } else {
              kdDebug() << "empty collection" << '\n';
              // empty collection
              mJournalsData = "";
          }
      }

      caldav_free_response(&result);
    }

    return journalsres;
}

// EOF ========================================================================
