/*
   $Id$
*/

/****************************************************************************
 ** Copyright (C)  2002-2004 Klarlvdalens Datakonsult AB.  All rights reserved.
 **
 ** This file is part of the KDGantt library.
 **
 ** This file may be distributed and/or modified under the terms of the
 ** GNU General Public License version 2 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.
 **
 ** Licensees holding valid commercial KDGantt licenses may use this file in
 ** accordance with the KDGantt Commercial License Agreement provided with
 ** the Software.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** See http://www.klaralvdalens-datakonsult.se/Public/products/ for
 **   information about KDGantt Commercial License Agreements.
 **
 ** Contact info@klaralvdalens-datakonsult.se if any conditions of this
 ** licensing are not clear to you.
 **
 ** As a special exception, permission is given to link this program
 ** with any edition of TQt, and distribute the resulting executable,
 ** without including the source code for TQt in the source distribution.
 **
 **********************************************************************/


#ifndef KDGANTTSEMISIZINGCONTROL_H
#define KDGANTTSEMISIZINGCONTROL_H

#include "KDGanttSizingControl.h"
#include <tqlayout.h>
class TQPushButton;
class TQBoxLayout;

class KDGanttSemiSizingControl : public KDGanttSizingControl
{
    TQ_PROPERTY( ArrowPosition arrowPosition READ arrowPosition WRITE setArrowPosition )
    TQ_ENUMS( ArrowPosition )
    TQ_OBJECT
  

public:
    enum ArrowPosition { Before, After };

    KDGanttSemiSizingControl( TQWidget* parent = 0, const char* name = 0 );
    KDGanttSemiSizingControl( TQt::Orientation orientation, TQWidget* parent = 0,
                           const char* name = 0 );
    KDGanttSemiSizingControl( ArrowPosition arrowPosition,
                         TQt::Orientation orientation, TQWidget* parent = 0,
                         const char* name = 0 );

    void setMinimizedWidget( TQWidget* widget );
    void setMaximizedWidget( TQWidget* widget );
    TQWidget* minimizedWidget() const;
    TQWidget* maximizedWidget() const;

    void setOrientation( TQt::Orientation orientation );
    TQt::Orientation orientation() const;

    void setArrowPosition( ArrowPosition arrowPosition );
    ArrowPosition arrowPosition() const;

public slots:
    virtual void minimize( bool minimize );
    virtual void restore( bool restore );

protected:
    void setup();
    void init();
    enum Direction {Left, Right, Up, Down };
    TQPixmap pixmap( Direction );

private:
    TQt::Orientation _orient;
    ArrowPosition _arrowPos;
    TQWidget* _minimizedWidget;
    TQWidget* _maximizedWidget;
    TQBoxLayout* _layout;
    TQPushButton* _but;
};


#endif
