/*
    This file is part of KAddressBook.
    Copyright (c) 2003 - 2004 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef SOUNDWIDGET_H
#define SOUNDWIDGET_H

#include <tdeabc/sound.h>

#include "contacteditorwidget.h"

class KURLRequester;

class TQCheckBox;
class TQPushButton;

class SoundWidget : public KAB::ContactEditorWidget
{
  TQ_OBJECT
  

  public:
    SoundWidget( TDEABC::AddressBook *ab, TQWidget *parent, const char *name = 0 );
    ~SoundWidget();

    void loadContact( TDEABC::Addressee *addr );
    void storeContact( TDEABC::Addressee *addr );
    void setReadOnly( bool readOnly );

  private slots:
    void playSound();
    void loadSound();
    void updateGUI();
    void urlChanged( const TQString& );

  private:
    KURLRequester *mSoundUrl;

    TQCheckBox *mUseSoundUrl;
    TQPushButton *mPlayButton;

    TDEABC::Sound mSound;
    bool mReadOnly;
};

class SoundWidgetFactory : public KAB::ContactEditorWidgetFactory
{
  public:
    KAB::ContactEditorWidget *createWidget( TDEABC::AddressBook *ab, TQWidget *parent, const char *name )
    {
      return new SoundWidget( ab, parent, name );
    }

    TQString pageIdentifier() const { return "misc"; }
};

#endif
