/***************************************************************************
*                               dlgDirectories.cpp
*                             -------------------
*
*    Revision     : $Id$
*    begin        : Tue Jan 29 2002
*    copyright    : (C) 2002 by Patrick Charbonnier
*                 : Based On Caitoo v.0.7.3 (c) 1998 - 2000, Matej Koss
*    email        : pch@freeshell.org
*
****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 ***************************************************************************/


#include <tqpushbutton.h>
#include <tqtoolbutton.h>
#include <tqlistview.h>

#include <tqdir.h>

#include <tdefiledialog.h>
#include <klineedit.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kurlrequester.h>

#include "settings.h"
#include "dlgDirectories.h"
#include <tdeapplication.h>

DlgDirectories::DlgDirectories(TQWidget * parent)
    : DlgDirectoriesBase(parent)
{
    connect( le_ext, TQ_SIGNAL( textChanged ( const TQString & ) ), this,  TQ_SLOT( slotDirectoryChanged( ) ) );
    connect( le_dir, TQ_SIGNAL( textChanged ( const TQString & ) ), this,  TQ_SLOT( slotDirectoryChanged( ) ) );

    le_dir->setMode( KFile::Directory );
    lv_entries->setSortColumn( -1 );

    slotDirectoryChanged();
}

void DlgDirectories::slotDirectoryChanged( )
{
    pb_add->setEnabled(!le_ext->text().isEmpty() &&!le_dir->url().isEmpty() );
}

void DlgDirectories::selectEntry(TQListViewItem * item)
{
    if (item) {
        le_ext->setText(item->text(0));
        le_dir->setURL(item->text(1));

    } else {
        le_ext->clear();
        le_dir->clear();
    }
    updateUpDown();
}


void DlgDirectories::updateUpDown()
{
    TQListViewItem *item = lv_entries->selectedItem();

    pb_up->setEnabled( item && item->itemAbove() );
    pb_down->setEnabled( item && item->itemBelow() );
}

void DlgDirectories::addEntry()
{
    TQString ext = le_ext->text();
    TQString dir = le_dir->url();

    if (ext.contains(",") || dir.contains(",") || ext.isEmpty() || dir.isEmpty()) {
        KMessageBox::error(this, i18n("Each row consists of exactly one\nextension type and one folder."), i18n("Error"));
        return;
    }

    TQDir f(dir);

    if (!f.exists()) {
        KMessageBox::error(this, i18n("Folder does not exist:\n%1").arg(dir), i18n("Error"));
        return;
    }

    new TQListViewItem(lv_entries, ext, dir);
    updateUpDown();

    emit configChanged();
}


void DlgDirectories::deleteEntry()
{
    TQListViewItem *item = lv_entries->selectedItem();
    delete item;
    updateUpDown();
    emit configChanged();
}


void DlgDirectories::changeEntry()
{
    TQListViewItem *old_item = lv_entries->selectedItem();

    if (old_item) {
        TQString ext = le_ext->text();
        TQString dir = le_dir->url();

        if (ext.contains(",") || dir.contains(",") || ext.isEmpty() || dir.isEmpty()) {
            KMessageBox::error(this, i18n("Each row consists of exactly one\nextension type and one folder."), i18n("Error"));
            return;
        }

        TQDir f(dir);

        if (!f.exists()) {
            KMessageBox::error(this, i18n("Folder does not exist:\n%1").arg(dir), i18n("Error"));
            return;
        }

        new TQListViewItem(lv_entries, old_item, ext, dir);
        delete old_item;
        emit configChanged();
    }
}


void DlgDirectories::downEntry()
{
    TQListViewItem *item = lv_entries->selectedItem();

    if ( !item )
        return;

    item->moveItem( item->itemBelow() );

    updateUpDown();
    emit configChanged();
}


void DlgDirectories::upEntry()
{
    TQListViewItem *item = lv_entries->selectedItem();

    if ( !item || !item->itemAbove() )
        return;

    item->moveItem( item->itemAbove()->itemAbove() );

    updateUpDown();
    emit configChanged();
}


void DlgDirectories::setData()
{
    DirList::Iterator it;

    if (ksettings.defaultDirList.count() > 0) {
        // we need to insert items in the reverse order
        // because "new TQListViewItem" puts itself at the beginning
        for (it = ksettings.defaultDirList.fromLast(); it != ksettings.defaultDirList.begin(); it--) {
            new TQListViewItem(lv_entries, (*it).extRegexp, (*it).defaultDir);
        }
        new TQListViewItem(lv_entries, (*it).extRegexp, (*it).defaultDir);
    }
}


void DlgDirectories::applyData()
{
    ksettings.defaultDirList.clear();
    TQListViewItemIterator it(lv_entries);

    for (; it.current(); ++it) {
        TQListViewItem *item = it.current();

        DirItem ditem;

        ditem.extRegexp = item->text(0);
        ditem.defaultDir = item->text(1);
        ksettings.defaultDirList.append(ditem);
    }
}

#include "dlgDirectories.moc"
