//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.TQListBoxItem;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQPoint;
import org.trinitydesktop.qt.TQSize;
import org.trinitydesktop.qt.TQDropEvent;
import org.trinitydesktop.qt.TQWidget;
import org.trinitydesktop.qt.TQPalette;
import org.trinitydesktop.qt.TQResizeEvent;
import org.trinitydesktop.qt.TQFrame;

/**

 KURLBar is a widget that displays icons together with a description. They
 can be arranged either horizontally or vertically. Clicking on an item
 will cause the activated() signal to be emitted. The user can edit
 existing items by choosing "Edit entry" in the contextmenu. He can also
 remove or add new entries (via drag&drop or the context menu).
 KURLBar offers the methods readConfig() and writeConfig() to
 read and write the configuration of all the entries. It can differentiate
 between global and local entries -- global entries will be saved in the
 global configuration (kdeglobals), while local entries will be saved in
 your application's TDEConfig object.
 Due to the configurability, you usually only insert some default entries
 once and then solely use the read and writeConfig methods to preserve the
 user's configuration.
 The widget has a "current" item, that is visualized to differentiate it
 from others.
 See {@link KURLBarSignals} for signals emitted by KURLBar
		@author Carsten Pfeiffer <pfeiffer@kde.org>

		@short A URL-bar widget, as used in the KFileDialog.

*/
public class KURLBar extends TQFrame  {
	protected KURLBar(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Constructs a KURLBar. Set <code>useGlobalItems</code> to true if you want to
		 allow global/local item separation.
		     		@short    Constructs a KURLBar.
	*/
	public KURLBar(boolean useGlobalItems, TQWidget parent, String name, int f) {
		super((Class) null);
		newKURLBar(useGlobalItems,parent,name,f);
	}
	private native void newKURLBar(boolean useGlobalItems, TQWidget parent, String name, int f);
	public KURLBar(boolean useGlobalItems, TQWidget parent, String name) {
		super((Class) null);
		newKURLBar(useGlobalItems,parent,name);
	}
	private native void newKURLBar(boolean useGlobalItems, TQWidget parent, String name);
	public KURLBar(boolean useGlobalItems, TQWidget parent) {
		super((Class) null);
		newKURLBar(useGlobalItems,parent);
	}
	private native void newKURLBar(boolean useGlobalItems, TQWidget parent);
	public KURLBar(boolean useGlobalItems) {
		super((Class) null);
		newKURLBar(useGlobalItems);
	}
	private native void newKURLBar(boolean useGlobalItems);
	/**
		 Inserts a new item into the KURLBar and returns the created
		 KURLBarItem.
			 <code>url</code> the url of the item
		 <code>description</code> the description of the item (shown in the view)
		 <code>applicationLocal</code> whether this should be a global or a local item
		 <code>icon</code> an icon -- if empty, the default icon for the url will be used
		 <code>group</code> the icon-group for using icon-effects
		     		@short    Inserts a new item into the KURLBar and returns the created  KURLBarItem.
	*/
	public native KURLBarItem insertItem(KURL url, String description, boolean applicationLocal, String icon, int group);
	public native KURLBarItem insertItem(KURL url, String description, boolean applicationLocal, String icon);
	public native KURLBarItem insertItem(KURL url, String description, boolean applicationLocal);
	public native KURLBarItem insertItem(KURL url, String description);
	/**
		 Inserts a new dynamic item into the KURLBar and returns the created
		 KURLBarItem.
			 <code>url</code> the url of the item
		 <code>description</code> the description of the item (shown in the view)
		 <code>icon</code> an icon -- if empty, the default icon for the url will be used
		 <code>group</code> the icon-group for using icon-effects
				@short    Inserts a new dynamic item into the KURLBar and returns the created  KURLBarItem.
	*/
	public native KURLBarItem insertDynamicItem(KURL url, String description, String icon, int group);
	public native KURLBarItem insertDynamicItem(KURL url, String description, String icon);
	public native KURLBarItem insertDynamicItem(KURL url, String description);
	/**
		 The items can be arranged either vertically in one column or
		 horizontally in one row.
				@short    The items can be arranged either vertically in one column or  horizontally in one row.
		@see #orientation
	*/
	public native void setOrientation(int orient);
	/**
				@return the current orientation mode.

		@short
		@see #setOrientation
	*/
	public native int orientation();
	/**
		 Allows to set a custom KURLBarListBox.
		 Note: The previous listbox will be deleted. Items of the previous
		 listbox will not be moved to the new box.
				@short    Allows to set a custom KURLBarListBox.
		@see #listBox
	*/
	public native void setListBox(KURLBarListBox arg1);
	/**
				@return the KURLBarListBox that is used.

		@short
		@see #setListBox
	*/
	public native KURLBarListBox listBox();
	/**
		 Sets the default iconsize to be used for items inserted with
		 insertItem. By default TDEIcon.SizeMedium.
				@short    Sets the default iconsize to be used for items inserted with  insertItem.
		@see #iconsize
	*/
	public native void setIconSize(int size);
	/**
				@return the default iconsize used for items inserted with
 insertItem. By default TDEIcon.SizeMedium

		@short
		@see #setIconSize
	*/
	public native int iconSize();
	/**
		 Clears the view, removes all items.
		     		@short    Clears the view, removes all items.
	*/
	public native void clear();
	/**
				@return a proper sizehint, depending on the orientation and the number
 of items available.

		@short
	*/
	public native TQSize sizeHint();
	/**
				@return a proper minimum size (reimplemented)

		@short
	*/
	public native TQSize minimumSizeHint();
	/**
		 Call this method to read a saved configuration from <code>config</code>,
		 inside the group <code>itemGroup.</code> All items in there will be restored.
		 The reading of every item is delegated to the readItem() method.
		     		@short    Call this method to read a saved configuration from <code>config</code>,  inside the group <code>itemGroup.</code>
	*/
	public native void readConfig(TDEConfig config, String itemGroup);
	/**
		 Call this method to save the current configuration into <code>config</code>,
		 inside the group <code>iconGroup.</code> The writeItem() method is used
		 to save each item.
		     		@short    Call this method to save the current configuration into <code>config</code>,  inside the group <code>iconGroup.</code>
	*/
	public native void writeConfig(TDEConfig config, String itemGroup);
	/**
		 Called from readConfig() to read the i'th from <code>config.</code>
		 After reading a KURLBarItem is created and initialized with the read
		 values (as well as the given <code>applicationLocal</code>).
		     		@short    Called from readConfig() to read the i'th from <code>config.</code>
	*/
	public native void readItem(int i, TDEConfig config, boolean applicationLocal);
	/**
		 Called from writeConfig() to save the KURLBarItem <code>item</code> as the
		 i'th entry in the config-object.
		 <code>global</code> tell whether it should be saved in the global configuration
		 or not (using TDEConfig.writeEntry( key, value, true, global ) ).
		     		@short    Called from writeConfig() to save the KURLBarItem <code>item</code> as the  i'th entry in the config-object.
	*/
	public native void writeItem(KURLBarItem item, int i, TDEConfig arg3, boolean global);
	/**
				@return the current KURLBarItem, or 0L if none.

		@short
		@see #setCurrentItem
		@see #currentURL
	*/
	public native KURLBarItem currentItem();
	/**
				@return the url of the current item or an invalid url, if there is
 no current item.

		@short
		@see #currentItem
		@see #setCurrentItem
	*/
	public native KURL currentURL();
	/**
				@return true when the urlbar was modified by the user (e.g. by
 editing/adding/removing one or more entries). Will be reset to false
 after calling writeConfig().

		@short
	*/
	public native boolean isModified();
	/**
				@return true when the urlbar may not be modified by the user

		@short
	*/
	public native boolean isImmutable();
	/**
				@return true if the bar is in vertical mode.

		@short
	*/
	public native boolean isVertical();
	/**
		 Makes the item with the url <code>url</code> the current item. Does nothing
		 if no item with that url is available.
				@short    Makes the item with the url <code>url</code> the current item.
		@see #currentItem
		@see #currentURL
	*/
	public native void setCurrentItem(KURL url);
	/**
		 Pops up a KURLBarItemDialog to let the user add a new item.
		 Uses editItem() to do the job.
				@return false if the user aborted the dialog and no item is added.

		@short    Pops up a KURLBarItemDialog to let the user add a new item.
	*/
	protected native boolean addNewItem();
	/**
		 Pops up a KURLBarItemDialog to let the user edit the properties
		 of <code>item.</code> Invoked e.g. by addNewItem(), when the user drops
		 a url  onto the bar or from the contextmenu.
				@return false if the user aborted the dialog and <code>item</code> is not
 changed.

		@short    Pops up a KURLBarItemDialog to let the user edit the properties  of <code>item.</code>
	*/
	protected native boolean editItem(KURLBarItem item);
	protected native void resizeEvent(TQResizeEvent arg1);
	protected native void paletteChange(TQPalette arg1);
	/**
		 Reimplemented to show a contextmenu, allowing the user to add, edit
		 or remove items, or change the iconsize.
		     		@short    Reimplemented to show a contextmenu, allowing the user to add, edit  or remove items, or change the iconsize.
	*/
	protected native void slotContextMenuRequested(TQListBoxItem arg1, TQPoint pos);
	/**
		 Called when an item has been selected. Emits the activated()
		 signal.
		     		@short    Called when an item has been selected.
	*/
	protected native void slotSelected(TQListBoxItem arg1);
	/**
		 Called when a url was dropped onto the bar to show a
		 KURLBarItemDialog.
		     		@short    Called when a url was dropped onto the bar to show a  KURLBarItemDialog.
	*/
	protected native void slotDropped(TQDropEvent arg1);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
