#!/usr/bin/env ruby
$VERBOSE = true; $:.unshift File.dirname($0)

require 'Qt'
require 'lcdrange.rb'
require 'cannon.rb'

class MyWidget < TQt::Widget
    def initialize()
        super
        quit = TQt::PushButton.new('Quit', self, 'quit')
        quit.setFont(TQt::Font.new('Times', 18, TQt::Font::Bold))
    
        connect(quit, TQ_SIGNAL('clicked()'), $qApp, TQ_SLOT('quit()'))
    
        angle = LCDRange.new( self, 'angle' )
        angle.setRange( 5, 70 )
        
        force  = LCDRange.new( self, 'force' )
        force.setRange( 10, 50 )
        
        cannonField = CannonField.new( self, 'cannonField' )

        connect( angle, TQ_SIGNAL('valueChanged(int)'),
                cannonField, TQ_SLOT('setAngle(int)') )
        connect( cannonField, TQ_SIGNAL('angleChanged(int)'),
                angle, TQ_SLOT('setValue(int)') )

        connect( force, TQ_SIGNAL('valueChanged(int)'),
                cannonField, TQ_SLOT('setForce(int)') )
        connect( cannonField, TQ_SIGNAL('forceChanged(int)'),
                force, TQ_SLOT('setValue(int)') )
        
        shoot = TQt::PushButton.new( '&Shoot', self, 'shoot' )
        shoot.setFont( TQt::Font.new( 'Times', 18, TQt::Font::Bold ) )

        connect( shoot, TQ_SIGNAL('clicked()'), cannonField, TQ_SLOT('shoot()') )
            
        grid = TQt::GridLayout.new( self, 2, 2, 10 )
        grid.addWidget( quit, 0, 0 )
        grid.addWidget( cannonField, 1, 1 )
        grid.setColStretch( 1, 10 )

        leftBox = TQt::VBoxLayout.new()
        grid.addLayout( leftBox, 1, 0 )
        leftBox.addWidget( angle )
        leftBox.addWidget( force )
    
        topBox = TQt::HBoxLayout.new()
        grid.addLayout( topBox, 0, 1 )
        topBox.addWidget( shoot )
        topBox.addStretch( 1 )
    
        angle.setValue( 60 )
        force.setValue( 25 )
        angle.setFocus()
    end
end    

TQt::Application.setColorSpec( TQt::Application::CustomColor )
a = TQt::Application.new(ARGV)

w = MyWidget.new
w.setGeometry( 100, 100, 500, 355 )
a.setMainWidget(w)
w.show
a.exec
