#ifndef _ENGINE_H
#define _ENGINE_H

#include <tqobject.h>
#include <kurl.h>
#include <arts/kmedia2.h>
#include <noatun/playlist.h>
#include <tdemacros.h>
class Visualization;

namespace Arts
{
	class SoundServerV2;

	class Synth_AMAN_PLAY;
}

namespace Noatun
{
	class StereoEffectStack;
	class StereoVolumeControl;
	class Equalizer;
	class Session;
}

class NoatunApp;

/**
 * Handles all playing, connecting to aRts.
 * Does almost everything related to multimedia.
 * Most interfacing should be done with Player
 **/
class TDE_EXPORT Engine : public TQObject
{
TQ_OBJECT
  
friend class NoatunApp;
public:
	Engine(TQObject *parent=0);
	~Engine();
	void setInitialized();
	bool initialized() const;

public slots:
	/**
	 * opens the file, use play() to start playing
	 **/
	bool open(const PlaylistItem &file);
	/**
	 * Continues playing
	 **/
	bool play();
	/**
	 * Terminates playing, does not close the file
	 **/
	void pause();
	/**
	 * resets the engine
	 **/
	void stop();
	/**
	 * skips to a timecode
	 * unit is milliseconds
	 **/
	void seek(int msec);

	void setVolume(int percent);

	void connectPlayObject();
signals:
	void done();
	/**
	 * emitted when arts dies and noatun has to start
	 * it again. This is called when the new arts
	 * is already initialized
	 **/
	void artsError();

	void aboutToPlay();

	void receivedStreamMeta(
		const TQString &streamName, const TQString &streamGenre,
		const TQString &streamUrl, const TQString &streamBitrate,
		const TQString &trackTitle, const TQString &trackUrl
	);

	void playingFailed();

	private slots:
		void slotProxyError();
		void deleteProxy();

public:
	int state();
	int position(); // return position in milliseconds
	int length(); // return track-length in milliseconds
	int volume() const;

private:
	int openMixerFD();
	void closeMixerFD(int);
	void useHardwareMixer(bool);
	bool initArts();

public:
	Arts::SoundServerV2 *server() const;
	Arts::PlayObject playObject() const;
	Arts::SoundServerV2 *simpleSoundServer() const;
	Noatun::StereoEffectStack *effectStack() const;
	Noatun::Equalizer *equalizer() const;
	Noatun::StereoEffectStack *visualizationStack() const;
	Noatun::StereoEffectStack *globalEffectStack() const;
	Noatun::Session *session() const;

private:
	class EnginePrivate;
	EnginePrivate *d;
	bool mPlay;
};

#endif
