# Copyright 1999-2024 Gentoo Authors
# Copyright 2020-2024 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="7"

inherit autotools flag-o-matic

DESCRIPTION="HTTP/HTML indexing and searching system"
HOMEPAGE="https://github.com/solbu/hldig"
SRC_URI="https://github.com/solbu/${PN}/archive/v${PV}.tar.gz -> ${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 arm arm64 ppc ppc64 x86"
IUSE="ssl"

# Don't use Gentoo mirrors
RESTRICT="mirror"

DEPEND="
	app-arch/unzip
	sys-libs/zlib
	ssl? ( dev-libs/openssl:= )
"
RDEPEND="${DEPEND}
	!www-misc/htdig
"

HTML_DOCS=( docs/. )

src_prepare() {
	default
	sed -e "s/AM_CONFIG_HEADER/AC_CONFIG_HEADERS/" -i configure.ac db/configure.ac || die
	eautoreconf
}

src_configure() {
	append-cxxflags "-std=c++11"
	local myeconfargs=(
		--disable-static
		--with-config-dir="${EPREFIX}"/etc/${PN}
		--with-default-config-file="${EPREFIX}"/etc/${PN}/${PN}.conf
		--with-database-dir="${EPREFIX}"/var/lib/${PN}/db
		--with-cgi-bin-dir="${EPREFIX}"/var/www/localhost/cgi-bin
		--with-search-dir="${EPREFIX}"/var/www/localhost/hldocs/${PN}
		--with-image-dir="${EPREFIX}"/var/www/localhost/hldocs/${PN}
		$(use_with ssl)
	)
	econf "${myeconfargs[@]}"
}

src_install () {
	default
	sed -i "s:${D}::g" \
		"${ED}"/etc/${PN}/${PN}.conf \
		"${ED}"/usr/bin/rundig \
		|| die "sed failed (removing \${D} from installed files)"

	keepdir "/var/lib/${PN}/db"

	# Symlink hlsearch so it can be easily found.
	dosym ../../var/www/localhost/cgi-bin/hlsearch /usr/bin/hlsearch

	# Add symlinks for compatibility with applications using htdig
	dosym /usr/bin/hldb_dump /usr/bin/htdb_dump
	dosym /usr/bin/hldb_load /usr/bin/htdb_load
	dosym /usr/bin/hldb_stat /usr/bin/htdb_stat
	dosym /usr/bin/hldig /usr/bin/htdig
	dosym /usr/bin/hldump /usr/bin/htdump
	dosym /usr/bin/hlfuzzy /usr/bin/htfuzzy
	dosym /usr/bin/hlload /usr/bin/htload
	dosym /usr/bin/hlmerge /usr/bin/htmerge
	dosym /usr/bin/hlnotify /usr/bin/htnotify
	dosym /usr/bin/hlpurge /usr/bin/htpurge
	dosym /usr/bin/hlsearch /usr/bin/htsearch
	dosym /usr/bin/hlstat /usr/bin/htstat

	# No static archives
	find "${D}" -name '*.la' -delete || die
}
